package immibis.core.api.porting;

import java.util.EnumSet;



/* $if mc < 1.3.2$
import net.minecraft.src.forge.*;
import net.minecraft.src.*;
public abstract class PortableBaseMod extends NetworkMod {
	@Override public boolean clientSideRequired() {return true;}
    @Override public boolean serverSideRequired() {return false;}
    
    public boolean onTickInGame() {return false;}
    
    $if client2$
	public boolean onTickInGame(float f, net.minecraft.client.Minecraft mc) {
	$else$
	public boolean onTickInGame(net.minecraft.server.MinecraftServer mc) {
	$endif$
		return onTickInGame();
	}
	
	public void enableClockTicks(boolean server) {
		ModLoader.setInGameHook(this, true, true);
	}
}
$else$ */
import cpw.mods.fml.common.IScheduledTickHandler;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.Side;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.registry.TickRegistry;
public abstract class PortableBaseMod {
	public boolean clientSideRequired() {return true;}
    public boolean serverSideRequired() {return false;}
    
    public abstract String getVersion();
    public String getPriorities() {return "";}
    public void load() {}
    public void modsLoaded() {}
    
    public boolean onTickInGame() {return false;}
    
    public void enableClockTicks(final boolean server) {
    	TickRegistry.registerScheduledTickHandler(new IScheduledTickHandler() {
			
			@Override
			public EnumSet<TickType> ticks() {
				return EnumSet.of(server ? TickType.SERVER : TickType.CLIENT);
			}
			
			@Override
			public void tickStart(EnumSet<TickType> type, Object... tickData) {
				onTickInGame();
			}
			
			@Override
			public void tickEnd(EnumSet<TickType> type, Object... tickData) {
				
			}
			
			@Override
			public String getLabel() {
				return PortableBaseMod.this.getClass().getSimpleName();
			}
			
			@Override
			public int nextTickSpacing() {
				return 1;
			}
		}, server ? Side.SERVER : Side.CLIENT);
    }
}
/* $endif$ */