/*
 * Decompiled with CFR 0.152.
 */
package immibis.core;

import immibis.core.Config;

public class BlockMetaPair {
    public int id;
    public int data;

    public BlockMetaPair(int n, int n2) {
        this.id = n;
        this.data = n2;
        if (this.id > Config.getMaxBlockID()) {
            this.id = 0;
        }
    }

    public int hashCode() {
        return (this.data << 16) + this.id;
    }

    public boolean equals(Object object) {
        try {
            BlockMetaPair blockMetaPair = (BlockMetaPair)object;
            return blockMetaPair.id == this.id && blockMetaPair.data == this.data;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public static BlockMetaPair parse(String string) {
        String[] stringArray = string.split(":");
        if (stringArray.length != 2) {
            throw new NumberFormatException("Not a valid block ID/data value: " + string);
        }
        return new BlockMetaPair(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]));
    }
}

