/*
 * Decompiled with CFR 0.152.
 */
package immibis.core.covers;

import immibis.core.covers.CoverSystemProxy;
import immibis.core.covers.EnumAxisPosition;
import immibis.core.covers.EnumPosition;
import immibis.core.covers.PartType;

public class Part {
    public final PartType type;
    public final double size;
    public final EnumPosition pos;
    protected fp aabb;

    public Part(PartType partType, EnumPosition enumPosition) {
        this.type = partType;
        this.size = partType.size;
        this.pos = enumPosition;
    }

    private static double getMinFromAxisPosition(EnumAxisPosition enumAxisPosition, double d) {
        switch (enumAxisPosition) {
            case Span: 
            case Negative: {
                return 0.0;
            }
            case Positive: {
                return 1.0 - d;
            }
            case Centre: {
                return (1.0 - d) / 2.0;
            }
        }
        throw new IllegalArgumentException("ap");
    }

    private static double getMaxFromAxisPosition(EnumAxisPosition enumAxisPosition, double d) {
        switch (enumAxisPosition) {
            case Span: 
            case Positive: {
                return 1.0;
            }
            case Negative: {
                return d;
            }
            case Centre: {
                return (1.0 + d) / 2.0;
            }
        }
        throw new IllegalArgumentException("ap");
    }

    private double getMinFromAxisPosition(EnumAxisPosition enumAxisPosition) {
        switch (enumAxisPosition) {
            case Span: 
            case Negative: {
                return 0.0;
            }
            case Positive: {
                return 1.0 - this.size;
            }
            case Centre: {
                return (1.0 - this.size) / 2.0;
            }
        }
        throw new IllegalArgumentException("ap");
    }

    private double getMaxFromAxisPosition(EnumAxisPosition enumAxisPosition) {
        switch (enumAxisPosition) {
            case Span: 
            case Positive: {
                return 1.0;
            }
            case Negative: {
                return this.size;
            }
            case Centre: {
                return (1.0 + this.size) / 2.0;
            }
        }
        throw new IllegalArgumentException("ap");
    }

    public fp getBoundingBox() {
        if (this.aabb == null) {
            this.aabb = Part.getBoundingBox(this.pos, this.size);
        }
        return this.aabb;
    }

    public static fp getBoundingBox(EnumPosition enumPosition, double d) {
        double d2 = Part.getMinFromAxisPosition(enumPosition.x, d);
        double d3 = Part.getMinFromAxisPosition(enumPosition.y, d);
        double d4 = Part.getMinFromAxisPosition(enumPosition.z, d);
        double d5 = Part.getMaxFromAxisPosition(enumPosition.x, d);
        double d6 = Part.getMaxFromAxisPosition(enumPosition.y, d);
        double d7 = Part.getMaxFromAxisPosition(enumPosition.z, d);
        return fp.a((double)d2, (double)d3, (double)d4, (double)d5, (double)d6, (double)d7);
    }

    public jz writeToNBT() {
        ph ph2 = new ph();
        ph2.a("type", this.type.id);
        ph2.a("pos", (byte)this.pos.ordinal());
        return ph2;
    }

    public static Part readFromNBT(jz jz2) {
        ph ph2 = (ph)jz2;
        PartType partType = (PartType)CoverSystemProxy.parts.get(ph2.f("type"));
        EnumPosition enumPosition = EnumPosition.values()[ph2.d("pos")];
        Part part = new Part(partType, enumPosition);
        return part;
    }
}

