/*
 * Decompiled with CFR 0.152.
 */
package immibis.core.covers;

import immibis.core.covers.BlockCoverableBase;
import immibis.core.covers.CoverSystemProxy;
import immibis.core.covers.EnumPartClass;
import immibis.core.covers.EnumPosition;
import immibis.core.covers.ICoverableTile;
import immibis.core.covers.Part;
import immibis.core.covers.PartType;
import immibis.core.covers.TileCoverableBase;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;

public class CoverImpl {
    LinkedList parts = new LinkedList();
    public BlockCoverableBase wrappedBlock;
    public double hollow_edge_size;
    public qj te;

    public CoverImpl(qj qj2, double d) {
        this.te = qj2;
        this.hollow_edge_size = d;
    }

    public CoverImpl(qj qj2) {
        this(qj2, 0.25);
    }

    void harvestBlock(ge ge2, ih ih2, int n, int n2, int n3, int n4) {
        ih2.c(0.025f);
        qj qj2 = ge2.b(n, n2, n3);
        if (qj2 == null || !(qj2 instanceof ICoverableTile)) {
            return;
        }
        if (n4 == -2) {
            if (this.wrappedBlock != null) {
                this.wrappedBlock.harvestBlockMultipart(ge2, ih2, n, n2, n3, ge2.c(n, n2, n3));
                ((TileCoverableBase)qj2).convertToMultipartBlockInPlace();
            }
            return;
        }
        if (n4 < 0) {
            return;
        }
        CoverImpl coverImpl = ((ICoverableTile)qj2).getCoverImpl();
        if (n4 >= coverImpl.parts.size()) {
            return;
        }
        Part part = (Part)coverImpl.parts.get(n4);
        if (part == null) {
            return;
        }
        CoverSystemProxy.blockMultipart.a(ge2, n, n2, n3, new kp(CoverSystemProxy.blockMultipart.bO, 1, part.type.id));
        coverImpl.parts.remove(n4);
        if (coverImpl.parts.size() == 0 && this.wrappedBlock == null) {
            ge2.b(n, n2, n3, 0);
        }
        ge2.j(n, n2, n3);
    }

    public void writeToNBT(ph ph2) {
        tx tx2 = new tx();
        for (Part part : this.parts) {
            tx2.a(part.writeToNBT());
        }
        ph2.a("Covers", (jz)tx2);
    }

    public void readFromNBT(ph ph2) {
        this.parts.clear();
        tx tx2 = ph2.n("Covers");
        if (tx2 == null) {
            return;
        }
        for (int i = 0; i < tx2.d(); ++i) {
            this.parts.add(Part.readFromNBT(tx2.a(i)));
        }
    }

    public wu collisionRayTrace(ge ge2, int n, int n2, int n3, cj cj2, cj cj3) {
        wu wu2;
        fp fp2;
        int n4 = 0;
        cj2 = cj2.c((double)(-n), (double)(-n2), (double)(-n3));
        cj3 = cj3.c((double)(-n), (double)(-n2), (double)(-n3));
        double d = cj3.c(cj2) + 1.0;
        Part part = null;
        wu wu3 = null;
        int n5 = -1;
        for (Part part2 : this.parts) {
            double d2;
            fp2 = part2.getBoundingBox();
            wu2 = fp2.a(cj2, cj3);
            if (wu2 != null && (d2 = wu2.f.c(cj2)) < d) {
                wu3 = wu2;
                d = d2;
                part = part2;
                n5 = n4;
            }
            ++n4;
        }
        if (part == null) {
            return null;
        }
        fp fp3 = part.aabb;
        int n6 = 0;
        fp2 = wu3.f;
        if (fp2.a <= fp3.a) {
            n6 = 4;
        } else if (fp2.a >= fp3.d) {
            n6 = 5;
        } else if (fp2.b <= fp3.b) {
            n6 = 0;
        } else if (fp2.b >= fp3.e) {
            n6 = 1;
        } else if (fp2.c <= fp3.c) {
            n6 = 2;
        } else if (fp2.c >= fp3.f) {
            n6 = 3;
        }
        wu2 = new wu(n, n2, n3, n6, fp2.c((double)n, (double)n2, (double)n3));
        wu2.subHit = n5;
        return wu2;
    }

    public boolean addPart(Part part) {
        if (!this.canPlace(part.type, part.pos)) {
            return false;
        }
        this.parts.add(part);
        return true;
    }

    public boolean canPlaceCentre(double d) {
        fp fp2 = Part.getBoundingBox(EnumPosition.Centre, d);
        for (Part part : this.parts) {
            if (!part.getBoundingBox().a(fp2)) continue;
            return false;
        }
        return true;
    }

    public boolean canPlace(PartType partType, EnumPosition enumPosition) {
        for (Part part : this.parts) {
            if (part.pos == enumPosition) {
                return false;
            }
            if (part.pos.clazz == enumPosition.clazz || !part.getBoundingBox().a(Part.getBoundingBox(enumPosition, partType.size))) continue;
            return false;
        }
        return true;
    }

    public void getCollidingBoundingBoxes(ge ge2, int n, int n2, int n3, fp fp2, ArrayList arrayList) {
        for (Part part : this.parts) {
            arrayList.add(part.getBoundingBox().c((double)n, (double)n2, (double)n3));
        }
    }

    public boolean isSideOpen(int n) {
        fp fp2 = fp.a((double)0.25, (double)0.25, (double)0.25, (double)0.75, (double)0.75, (double)0.75);
        switch (n) {
            case 4: {
                fp2.a = 0.0;
                break;
            }
            case 5: {
                fp2.d = 1.0;
                break;
            }
            case 0: {
                fp2.b = 0.0;
                break;
            }
            case 1: {
                fp2.e = 1.0;
                break;
            }
            case 2: {
                fp2.c = 0.0;
                break;
            }
            case 3: {
                fp2.f = 1.0;
            }
        }
        for (Part part : this.parts) {
            if (part.type.clazz == EnumPartClass.HollowPanel || part.pos == EnumPosition.Centre || !part.getBoundingBox().a(fp2)) continue;
            return false;
        }
        return true;
    }

    public boolean isSideOpen(int n, int n2, int n3, int n4, int n5, int n6) {
        fp fp2 = fp.a((double)0.25, (double)0.25, (double)0.25, (double)0.75, (double)0.75, (double)0.75);
        if (n4 < n) {
            fp2.a = 0.0;
        }
        if (n4 > n) {
            fp2.d = 1.0;
        }
        if (n5 < n2) {
            fp2.b = 0.0;
        }
        if (n5 > n2) {
            fp2.e = 1.0;
        }
        if (n6 < n3) {
            fp2.c = 0.0;
        }
        if (n6 > n3) {
            fp2.f = 1.0;
        }
        for (Part part : this.parts) {
            if (part.type.clazz == EnumPartClass.HollowPanel || part.pos == EnumPosition.Centre || !part.getBoundingBox().a(fp2)) continue;
            return false;
        }
        return true;
    }

    public void writeDescriptionPacket(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.wrappedBlock == null ? 0 : this.wrappedBlock.bO);
        dataOutputStream.writeShort(this.parts.size());
        for (Part part : this.parts) {
            dataOutputStream.writeByte(part.pos.ordinal());
            dataOutputStream.writeShort(part.type.id);
        }
    }

    public void readDescriptionPacket(DataInputStream dataInputStream) throws IOException {
        short s = dataInputStream.readShort();
        this.wrappedBlock = s == 0 ? null : (BlockCoverableBase)vz.m[s];
        int n = dataInputStream.readShort();
        this.parts.clear();
        for (int i = 0; i < n; ++i) {
            EnumPosition enumPosition = EnumPosition.values()[dataInputStream.readByte()];
            int n2 = dataInputStream.readShort() & 0xFFFF;
            this.parts.add(new Part((PartType)CoverSystemProxy.parts.get(n2), enumPosition));
        }
    }

    public void copyPartsTo(CoverImpl coverImpl) {
        for (Part part : this.parts) {
            coverImpl.addPart(part);
        }
    }

    public lx getDefaultDescriptionPacket() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(this.te.l);
            dataOutputStream.writeInt(this.te.m);
            dataOutputStream.writeInt(this.te.n);
            this.writeDescriptionPacket(dataOutputStream);
            gl gl2 = new gl();
            gl2.a = "ImmibisCoreCDP";
            gl2.c = byteArrayOutputStream.toByteArray();
            gl2.b = gl2.c.length;
            return gl2;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }
}

