/*
 * Decompiled with CFR 0.152.
 */
package immibis.core.covers;

import immibis.core.covers.CoverSystemProxy;
import immibis.core.covers.EnumAxisPosition;
import immibis.core.covers.EnumPosition;
import immibis.core.covers.PartType;

public class Part {
    public final PartType type;
    public final double size;
    public final EnumPosition pos;
    protected fb aabb;

    public Part(PartType type, EnumPosition pos) {
        this.type = type;
        this.size = type.size;
        this.pos = pos;
    }

    private static double getMinFromAxisPosition(EnumAxisPosition ap, double size) {
        switch (ap) {
            case Span: 
            case Negative: {
                return 0.0;
            }
            case Positive: {
                return 1.0 - size;
            }
            case Centre: {
                return (1.0 - size) / 2.0;
            }
        }
        throw new IllegalArgumentException("ap");
    }

    private static double getMaxFromAxisPosition(EnumAxisPosition ap, double size) {
        switch (ap) {
            case Span: 
            case Positive: {
                return 1.0;
            }
            case Negative: {
                return size;
            }
            case Centre: {
                return (1.0 + size) / 2.0;
            }
        }
        throw new IllegalArgumentException("ap");
    }

    private double getMinFromAxisPosition(EnumAxisPosition ap) {
        switch (ap) {
            case Span: 
            case Negative: {
                return 0.0;
            }
            case Positive: {
                return 1.0 - this.size;
            }
            case Centre: {
                return (1.0 - this.size) / 2.0;
            }
        }
        throw new IllegalArgumentException("ap");
    }

    private double getMaxFromAxisPosition(EnumAxisPosition ap) {
        switch (ap) {
            case Span: 
            case Positive: {
                return 1.0;
            }
            case Negative: {
                return this.size;
            }
            case Centre: {
                return (1.0 + this.size) / 2.0;
            }
        }
        throw new IllegalArgumentException("ap");
    }

    public fb getBoundingBox() {
        if (this.aabb == null) {
            this.aabb = Part.getBoundingBox(this.pos, this.size);
        }
        return this.aabb;
    }

    public static fb getBoundingBox(EnumPosition pos, double size) {
        double minx = Part.getMinFromAxisPosition(pos.x, size);
        double miny = Part.getMinFromAxisPosition(pos.y, size);
        double minz = Part.getMinFromAxisPosition(pos.z, size);
        double maxx = Part.getMaxFromAxisPosition(pos.x, size);
        double maxy = Part.getMaxFromAxisPosition(pos.y, size);
        double maxz = Part.getMaxFromAxisPosition(pos.z, size);
        return fb.a((double)minx, (double)miny, (double)minz, (double)maxx, (double)maxy, (double)maxz);
    }

    public iw writeToNBT() {
        nu c = new nu();
        c.a("type", this.type.id);
        c.a("pos", (byte)this.pos.ordinal());
        return c;
    }

    public static Part readFromNBT(iw tag) {
        nu c = (nu)tag;
        PartType type = (PartType)CoverSystemProxy.parts.get(c.f("type"));
        EnumPosition pos = EnumPosition.values()[c.d("pos")];
        Part p = new Part(type, pos);
        return p;
    }
}

