/*
 * Decompiled with CFR 0.152.
 */
package immibis.core.covers;

import immibis.core.covers.BlockCoverableBase;
import immibis.core.covers.CoverSystemProxy;
import immibis.core.covers.EnumPartClass;
import immibis.core.covers.EnumPosition;
import immibis.core.covers.ICoverableTile;
import immibis.core.covers.Part;
import immibis.core.covers.PartType;
import immibis.core.covers.TileCoverableBase;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.LinkedListLimmibis.core.covers.Par;

public class CoverImpl {
    Par parts = new LinkedList();
    public BlockCoverableBase wrappedBlock;
    public double hollow_edge_size;
    public ow te;

    public CoverImpl(ow te, double hes) {
        this.te = te;
        this.hollow_edge_size = hes;
    }

    public CoverImpl(ow te) {
        this(te, 0.25);
    }

    void harvestBlock(fq world, hk ply, int x, int y, int z, int subHit) {
        ply.c(0.025f);
        ow te = world.b(x, y, z);
        if (te == null || !(te instanceof ICoverableTile)) {
            return;
        }
        if (subHit == -2) {
            if (this.wrappedBlock != null) {
                this.wrappedBlock.harvestBlockMultipart(world, ply, x, y, z, world.c(x, y, z));
                ((TileCoverableBase)te).convertToMultipartBlockInPlace();
            }
            return;
        }
        if (subHit < 0) {
            return;
        }
        CoverImpl cover = ((ICoverableTile)te).getCoverImpl();
        if (subHit >= cover.parts.size()) {
            return;
        }
        Part p = (Part)cover.parts.get(subHit);
        if (p == null) {
            return;
        }
        CoverSystemProxy.blockMultipart.a(world, x, y, z, new jm(CoverSystemProxy.blockMultipart.bO, 1, p.type.id));
        cover.parts.remove(subHit);
        if (cover.parts.size() == 0 && this.wrappedBlock == null) {
            world.b(x, y, z, 0);
        }
        world.h(x, y, z);
    }

    public void writeToNBT(nu tag) {
        sg l = new sg();
        for (Part p : this.parts) {
            l.a(p.writeToNBT());
        }
        tag.a("Covers", (iw)l);
    }

    public void readFromNBT(nu tag) {
        this.parts.clear();
        sg l = tag.m("Covers");
        if (l == null) {
            return;
        }
        for (int k = 0; k < l.d(); ++k) {
            this.parts.add(Part.readFromNBT(l.a(k)));
        }
    }

    public uv collisionRayTrace(fq world, int x, int y, int z, cc src, cc dst) {
        int k = 0;
        src = src.c((double)(-x), (double)(-y), (double)(-z));
        dst = dst.c((double)(-x), (double)(-y), (double)(-z));
        double best = dst.c(src) + 1.0;
        Part hit = null;
        uv hitInfo = null;
        int subHit = -1;
        for (Part p : this.parts) {
            double rtdist;
            fb aabb = p.getBoundingBox();
            uv rt = aabb.a(src, dst);
            if (rt != null && (rtdist = rt.f.c(src)) < best) {
                hitInfo = rt;
                best = rtdist;
                hit = p;
                subHit = k;
            }
            ++k;
        }
        if (hit == null) {
            return null;
        }
        fb aabb = hit.aabb;
        int side = 0;
        cc hitVec = hitInfo.f;
        if (hitVec.a <= aabb.a) {
            side = 4;
        } else if (hitVec.a >= aabb.d) {
            side = 5;
        } else if (hitVec.b <= aabb.b) {
            side = 0;
        } else if (hitVec.b >= aabb.e) {
            side = 1;
        } else if (hitVec.c <= aabb.c) {
            side = 2;
        } else if (hitVec.c >= aabb.f) {
            side = 3;
        }
        uv pos = new uv(x, y, z, side, hitVec.c((double)x, (double)y, (double)z));
        pos.subHit = subHit;
        return pos;
    }

    public boolean addPart(Part part) {
        if (!this.canPlace(part.type, part.pos)) {
            return false;
        }
        this.parts.add(part);
        return true;
    }

    public boolean canPlaceCentre(double size) {
        fb aabb = Part.getBoundingBox(EnumPosition.Centre, size);
        for (Part p : this.parts) {
            if (!p.getBoundingBox().a(aabb)) continue;
            return false;
        }
        return true;
    }

    public boolean canPlace(PartType type, EnumPosition pos) {
        for (Part p : this.parts) {
            if (p.pos == pos) {
                return false;
            }
            if (p.pos.clazz == pos.clazz || !p.getBoundingBox().a(Part.getBoundingBox(pos, type.size))) continue;
            return false;
        }
        return true;
    }

    public void getCollidingBoundingBoxes(fq world, int x, int y, int z, fb mask, ArrayList list) {
        for (Part p : this.parts) {
            list.add(p.getBoundingBox().c((double)x, (double)y, (double)z));
        }
    }

    public boolean isSideOpen(int side) {
        fb aabb = fb.a((double)0.25, (double)0.25, (double)0.25, (double)0.75, (double)0.75, (double)0.75);
        switch (side) {
            case 4: {
                aabb.a = 0.0;
                break;
            }
            case 5: {
                aabb.d = 1.0;
                break;
            }
            case 0: {
                aabb.b = 0.0;
                break;
            }
            case 1: {
                aabb.e = 1.0;
                break;
            }
            case 2: {
                aabb.c = 0.0;
                break;
            }
            case 3: {
                aabb.f = 1.0;
            }
        }
        for (Part p : this.parts) {
            if (p.type.clazz == EnumPartClass.HollowPanel || p.pos == EnumPosition.Centre || !p.getBoundingBox().a(aabb)) continue;
            return false;
        }
        return true;
    }

    public boolean isSideOpen(int myx, int myy, int myz, int x, int y, int z) {
        fb aabb = fb.a((double)0.25, (double)0.25, (double)0.25, (double)0.75, (double)0.75, (double)0.75);
        if (x < myx) {
            aabb.a = 0.0;
        }
        if (x > myx) {
            aabb.d = 1.0;
        }
        if (y < myy) {
            aabb.b = 0.0;
        }
        if (y > myy) {
            aabb.e = 1.0;
        }
        if (z < myz) {
            aabb.c = 0.0;
        }
        if (z > myz) {
            aabb.f = 1.0;
        }
        for (Part p : this.parts) {
            if (p.type.clazz == EnumPartClass.HollowPanel || p.pos == EnumPosition.Centre || !p.getBoundingBox().a(aabb)) continue;
            return false;
        }
        return true;
    }

    public Packet230ModLoader getDescriptionPacket(Packet230ModLoader base) {
        Packet230ModLoader p = new Packet230ModLoader();
        p.packetType = base == null ? 1 : base.packetType;
        (p.dataInt = new int[4 + this.parts.size() + (base == null ? 0 : base.dataInt.length)])[3] = (this.wrappedBlock == null ? 0 : this.wrappedBlock.bO) + (this.parts.size() << 16);
        p.dataInt[0] = this.te.l;
        p.dataInt[1] = this.te.m;
        p.dataInt[2] = this.te.n;
        if (base != null) {
            p.dataInt[3] = p.dataInt[3] | Integer.MIN_VALUE;
        }
        for (int k = 0; k < this.parts.size(); ++k) {
            Part pt = (Part)this.parts.get(k);
            p.dataInt[k + 4] = pt.pos.ordinal() + (pt.type.id << 8);
        }
        if (base != null) {
            int n = this.parts.size() + 4;
            for (int k = 0; k < base.dataInt.length; ++k) {
                p.dataInt[k + n] = base.dataInt[k];
            }
            p.dataString = base.dataString;
            p.dataFloat = base.dataFloat;
            p.modId = base.modId;
        } else {
            p.modId = mod_ImmibisCore.instance.getId();
        }
        p.l = true;
        return p;
    }

    public void consumeDescriptionPacket(Packet230ModLoader p) {
        int k;
        int[] ai = p.dataInt;
        int ncovers = ai[3] >> 16 & Short.MAX_VALUE;
        if ((ai[3] & Integer.MIN_VALUE) != 0) {
            p.dataInt = new int[ai.length - ncovers - 4];
            for (k = 0; k < p.dataInt.length; ++k) {
                p.dataInt[k] = ai[k + ncovers + 4];
            }
        }
        this.parts.clear();
        for (k = 0; k < ncovers; ++k) {
            int i = ai[k + 4];
            this.parts.add(new Part((PartType)CoverSystemProxy.parts.get(i >> 8 & 0xFFFFFF), EnumPosition.values()[i & 0xFF]));
        }
    }

    public void copyPartsTo(CoverImpl other) {
        for (Part p : this.parts) {
            other.addPart(p);
        }
    }
}

