/*
 * Decompiled with CFR 0.152.
 */
package immibis.core;

import forge.Configuration;
import forge.MinecraftForge;
import forge.Property;
import immibis.core.MCVersionProxy;
import immibis.core.NonSharedProxy;
import java.io.File;
import java.util.HashSet;
import java.util.HashSetLjava.lang.Strin;

public class Config {
    private static File configFile;
    private static Configuration config;
    private static boolean autoAssign;
    private static Strin forceAllowReassign;

    public static boolean getBoolean(String name, boolean def) {
        boolean result = Boolean.valueOf(Config.config.getOrCreateBooleanProperty((String)name, (int)0, (boolean)def).value);
        config.save();
        return result;
    }

    public static void save() {
        config.save();
    }

    public static int getBlockID(String name, boolean allowCreation) {
        try {
            if (!allowCreation && !Config.config.blockProperties.containsKey(name + ".id")) {
                return 0;
            }
            return Integer.parseInt(Config.config.getOrCreateBlockIdProperty((String)new StringBuilder().append((String)name).append((String)".id").toString(), (int)194).value);
        }
        catch (Exception e) {
            MCVersionProxy.ML_ThrowException((String)"This shouldn't be possible", (Throwable)e);
            return 0;
        }
    }

    public static int getShiftedItemID(String name, int def) {
        int shift;
        Property prop = config.getOrCreateIntProperty(name, 1, def);
        int id = Integer.valueOf(prop.value);
        if (hg.d[id - (shift = ud.m.length)] != null || id == 0) {
            if (!autoAssign) {
                MinecraftForge.killMinecraft((String)"immibis core", (String)("Item " + name + " conflicts with " + hg.d[id - shift] + " "));
            }
            id = -1;
            for (int k = hg.d.length - 1; k >= 500; --k) {
                if (hg.d[k] != null) continue;
                id = k + shift;
                break;
            }
            if (id == -1) {
                MinecraftForge.killMinecraft((String)"immibis core", (String)"You're out of block IDs! Oh no! Remove some mods or install a block ID extender!");
            }
            prop.value = String.valueOf(id);
            config.save();
        }
        return id;
    }

    public static int getInt(String name, int def) {
        return Integer.valueOf(Config.config.getOrCreateIntProperty((String)name, (int)0, (int)def).value);
    }

    static {
        File configDir = new File(NonSharedProxy.getMinecraftDir(), "config");
        configDir.mkdir();
        File configFile = new File(configDir, "immibis.cfg");
        config = new Configuration(configFile);
        config.load();
        autoAssign = Config.getBoolean("autoAssign", true);
        ((Property)Config.config.generalProperties.get((Object)"autoAssign")).value = "false";
        config.save();
        forceAllowReassign = new HashSet();
    }
}

