package mods.immibis.core;


import java.util.ArrayList;
import java.util.List;

import mods.immibis.core.api.APILocator;
import mods.immibis.core.api.net.IPacket;
import mods.immibis.core.api.porting.PortableTileEntity;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.network.packet.Packet;

public abstract class TileCombined extends PortableTileEntity {
	
	public int redstone_output = 0;
	
	public List<ItemStack> getInventoryDrops() {
		if(this instanceof IInventory) {
			IInventory inv = (IInventory)this;
			List<ItemStack> list = new ArrayList<ItemStack>();
			for(int k = 0; k < inv.getSizeInventory(); k++) {
				ItemStack is = inv.getStackInSlot(k);
				if(is != null && is.stackSize > 0) {
					inv.setInventorySlotContents(k, null);
					list.add(is);
				}
			}
			return list;
		}
		
		return new ArrayList<ItemStack>();
	}

	public void onBlockNeighbourChange() {}
	public boolean onBlockActivated(EntityPlayer player) {return false;}
	public void onBlockRemoval() {}
	
	public void notifyNeighbouringBlocks() {
		worldObj.notifyBlocksOfNeighborChange(xCoord, yCoord, zCoord, worldObj.getBlockId(xCoord, yCoord, zCoord));
	}
	
	public void resendDescriptionPacket() {
		worldObj.markBlockForUpdate(xCoord, yCoord, zCoord);
	}
	
	@Override
	public Packet getDescriptionPacket() {
		IPacket p = getDescriptionPacket2();
		if(p == null)
			return null;
		Packet p2 = APILocator.getNetManager().wrap(p);
		p2.isChunkDataPacket = true;
		return p2;
	}
	
	public IPacket getDescriptionPacket2() {
		return null;
	}
	
	// look = The closest axis to the direction the player is looking towards
	public void onPlaced(EntityLivingBase player, int look) {}
	
	
	private void notifyComparator(int x, int y, int z) {
		if(worldObj.blockExists(x, y, z)) {
			int id = worldObj.getBlockId(x, y, z);
			if(id == Block.redstoneComparatorActive.blockID || id == Block.redstoneComparatorIdle.blockID)
				worldObj.notifyBlockOfNeighborChange(x, y, z, getBlockType().blockID);
		}
	}
	public void notifyComparators() {
		notifyComparator(xCoord-1, yCoord, zCoord);
        notifyComparator(xCoord+1, yCoord, zCoord);
        notifyComparator(xCoord, yCoord, zCoord-1);
        notifyComparator(xCoord, yCoord, zCoord+1);
        notifyComparator(xCoord-2, yCoord, zCoord);
        notifyComparator(xCoord+2, yCoord, zCoord);
        notifyComparator(xCoord, yCoord, zCoord-2);
        notifyComparator(xCoord, yCoord, zCoord+2);
	}
}
