package mods.immibis.chunkloader;


import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class BlockChunkLoader extends BlockContainer {
	
	protected BlockChunkLoader(int id) {
		super(id, Material.iron);
		setUnlocalizedName(R.string.block.chunkloader);
		setTextureName(R.block.chunkloader);
		setHardness(2.0f);
		setCreativeTab(CreativeTabs.tabMisc);
	}
	
	@Override
	public boolean removeBlockByPlayer(World w, EntityPlayer player, int x, int y, int z) {
		TileChunkLoader tcl = (TileChunkLoader)w.getBlockTileEntity(x, y, z);
		if(!super.removeBlockByPlayer(w, player, x, y, z))
			return false;
		if(w.isRemote)
			return true;
		Logging.onRemoved(tcl.getLoader(), player.username);
		return true;
	}
	
	@Override
	public void onBlockPlacedBy(World w, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
		super.onBlockPlacedBy(w, x, y, z, player, stack);
		if(w.isRemote)
			return;
		TileChunkLoader tile = (TileChunkLoader)w.getBlockTileEntity(x, y, z);
		if(player instanceof EntityPlayer)
			tile.onPlaced(Owner.getPlayerOwnerString(((EntityPlayer)player).username));
		else
			tile.onPlaced(Owner.NON_PLAYER_STRING);
	}

	@Override
	public TileEntity createNewTileEntity(World world) {
		return new TileChunkLoader();
	}
	
	@Override
	public boolean onBlockActivated(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer, int par6, float par7, float par8, float par9) {
		if(!par1World.isRemote)
			par5EntityPlayer.openGui(DimensionalAnchors.instance, DimensionalAnchors.requireFuel ? DimensionalAnchors.GUI_CHUNKLOADER_FUELED : DimensionalAnchors.GUI_CHUNKLOADER, par1World, par2, par3, par4);
		return true;
	}
}
