package mods.immibis.connectedglass;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.List;

import javax.imageio.ImageIO;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.item.ItemDye;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;

public class Hooks {
	
	public static class TextureNoEdge extends TextureAtlasSprite {

		private ResourceLocation baseResLoc;
		private int mask;
		private boolean forceTransparent;
		
		public TextureNoEdge(String name, ResourceLocation base, int mask, boolean forceTransparent) {
			super(name);
			
			this.baseResLoc = base;
			this.mask = mask;
			this.forceTransparent = forceTransparent;
		}
		
		@Override
		public boolean hasCustomLoader(IResourceManager manager,ResourceLocation location) {
			return true;
		}

		@Override
		public boolean load(IResourceManager manager, ResourceLocation location) {
			
			try {
				IResource iresource = manager.getResource(baseResLoc);
	            BufferedImage[] abufferedimage = new BufferedImage[1 + Minecraft.getMinecraft().gameSettings.mipmapLevels];
	            abufferedimage[0] = ImageIO.read(iresource.getInputStream());
	            
	            AnimationMetadataSection animationmetadatasection = (AnimationMetadataSection)iresource.getMetadata("animation");
	            loadSprite(abufferedimage, animationmetadatasection, false);
			} catch(IOException e) {
				throw new RuntimeException(e);
			}
            
			for(int[][] frame : (List<int[][]>)framesTextureData) {
				for(int[] mipmap : frame) {
					
					if(mipmap == null) continue;
					
					if((mask & MASK_TOP) != 0)
						for(int k = 1; k < width-1; k++)
							mipmap[k] = forceTransparent ? 0 : mipmap[k+width];
					
					if((mask & MASK_BOTTOM) != 0)
						for(int k = 2; k < width; k++)
							mipmap[mipmap.length-k] = forceTransparent ? 0 : mipmap[mipmap.length-k-width];
					
					if((mask & MASK_LEFT) != 0)
						for(int k = 1; k < height-1; k++)
							mipmap[k*width] = forceTransparent ? 0 : mipmap[k*width+1];
					
					if((mask & MASK_RIGHT) != 0)
						for(int k = 2; k < height; k++)
							mipmap[k*width-1] = forceTransparent ? 0 : mipmap[k*width-2];
					
					if((mask & MASK_TOPRIGHT) == MASK_TOPRIGHT)
						mipmap[width-1] = forceTransparent ? 0 : mipmap[width*2-2];
					
					if((mask & MASK_TOPLEFT) == MASK_TOPLEFT)
						mipmap[0] = forceTransparent ? 0 : mipmap[width+1];
					
					if((mask & MASK_BOTRIGHT) == MASK_BOTRIGHT)
						mipmap[width*height-1] = forceTransparent ? 0 : mipmap[width*height-width-2];
					
					if((mask & MASK_BOTLEFT) == MASK_BOTLEFT)
						mipmap[width*(height-1)] = forceTransparent ? 0 : mipmap[width*(height-2)+1];
				}
			}
			
			return false;
		}

	}

	private static final int MASK_TOP = 1;
	private static final int MASK_LEFT = 2;
	private static final int MASK_RIGHT = 4;
	private static final int MASK_BOTTOM = 8;
	private static final int MASK_TOPLEFT = MASK_TOP | MASK_LEFT;
	private static final int MASK_TOPRIGHT = MASK_TOP | MASK_RIGHT;
	private static final int MASK_BOTLEFT = MASK_BOTTOM | MASK_LEFT;
	private static final int MASK_BOTRIGHT = MASK_BOTTOM | MASK_RIGHT;
	
	private static TextureNoEdge[] i = new TextureNoEdge[16];
	private static TextureNoEdge[][] si = new TextureNoEdge[16][16];
	
	private static IIcon getTexture(TextureNoEdge[] i, boolean top, boolean bottom, boolean left, boolean right) {
		return i[(top ? MASK_TOP : 0) + (bottom ? MASK_BOTTOM : 0) + (left ? MASK_LEFT : 0) + (right ? MASK_RIGHT : 0)];
	}
	
	private static IIcon getSideTexture(TextureNoEdge[] i, IBlockAccess w, int x, int y, int z, int hdx, int hdz) {
		Block id = w.getBlock(x, y, z);
		return getTexture(i, w.getBlock(x,y+1,z) == id, w.getBlock(x,y-1,z) == id, w.getBlock(x+hdx,y,z+hdz) == id, w.getBlock(x-hdx, y, z-hdz) == id);
	}
	
	private static IIcon getSideTextureWithMeta(TextureNoEdge[] i, IBlockAccess w, int x, int y, int z, int hdx, int hdz) {
		Block id = w.getBlock(x, y, z);
		int meta = w.getBlockMetadata(x, y, z);
		return getTexture(i, w.getBlock(x,y+1,z) == id && w.getBlockMetadata(x,y+1,z) == meta, w.getBlock(x,y-1,z) == id && w.getBlockMetadata(x,y-1,z) == meta, w.getBlock(x+hdx,y,z+hdz) == id && w.getBlockMetadata(x+hdx,y,z+hdz) == meta, w.getBlock(x-hdx, y, z-hdz) == id && w.getBlockMetadata(x-hdx,y,z-hdz) == meta);
	}
	
	public static IIcon getBlockTexture(IBlockAccess w, int x, int y, int z, int side) {
		switch(side) {
		case 0:
		case 1:
			Block id = w.getBlock(x, y, z);
			return getTexture(i, w.getBlock(x,y,z-1)==id, w.getBlock(x,y,z+1)==id, w.getBlock(x-1,y,z)==id, w.getBlock(x+1,y,z)==id);
		case 2: return getSideTexture(i, w, x, y, z, 1, 0);
		case 3: return getSideTexture(i, w, x, y, z, -1, 0);
		case 4: return getSideTexture(i, w, x, y, z, 0, -1);
		case 5: return getSideTexture(i, w, x, y, z, 0, 1);
		default: return i[0];
		}
	}
	
	public static IIcon getStainedBlockTexture(IBlockAccess w, int x, int y, int z, int side) {
		TextureNoEdge[] i = si[w.getBlockMetadata(x, y, z)];
		switch(side) {
		case 0:
		case 1:
			Block id = w.getBlock(x, y, z);
			int meta = w.getBlockMetadata(x, y, z);
			return getTexture(i, w.getBlock(x,y,z-1)==id && w.getBlockMetadata(x,y,z-1)==meta, w.getBlock(x,y,z+1)==id && w.getBlockMetadata(x,y,z+1)==meta, w.getBlock(x-1,y,z)==id && w.getBlockMetadata(x-1,y,z)==meta, w.getBlock(x+1,y,z)==id && w.getBlockMetadata(x+1,y,z)==meta);
		case 2: return getSideTextureWithMeta(i, w, x, y, z, 1, 0);
		case 3: return getSideTextureWithMeta(i, w, x, y, z, -1, 0);
		case 4: return getSideTextureWithMeta(i, w, x, y, z, 0, -1);
		case 5: return getSideTextureWithMeta(i, w, x, y, z, 0, 1);
		default: return i[0];
		}
	}
	
	public static void registerIcons(IIconRegister r) {
		ResourceLocation base = new ResourceLocation("textures/blocks/glass.png");
		for(int k = 0; k < 16; k++) {
			String name = "connectedglass:glass"+k;
			((TextureMap)r).setTextureEntry(name, i[k] = new TextureNoEdge(name, base, k, true));
		}
	}
	
	public static void registerStainedIcons(IIconRegister r) {
		for(int colour = 0; colour < 16; colour++) {
			ResourceLocation base = new ResourceLocation("textures/blocks/glass_" + ItemDye.field_150921_b[15 - colour] + ".png");
			for(int k = 0; k < 16; k++) {
				String name = "connectedglass:glass"+colour+"_"+k;
				((TextureMap)r).setTextureEntry(name, si[colour][k] = new TextureNoEdge(name, base, k, false));
			}
		}
	}
}
