package mods.immibis.connectedglass;

import java.util.Map;

import mods.immibis.core.api.CoremodMarker;
import mods.immibis.core.api.FMLModInfo;
import net.minecraft.launchwrapper.IClassTransformer;

import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin.SortingIndex;

@FMLModInfo(
	modid="ConnectedGlass",
	name="Connected Glass",
	url="http://www.minecraftforum.net/topic/1001131-110-immibiss-mods-smp/",
	description="Does what you'd expect from a mod called Connected Glass.",
	authors="immibis"
	)
@CoremodMarker(version="59.0.1")
@SortingIndex(1500)
public class ConnectedGlass implements IFMLLoadingPlugin {

	@Override
	public String getAccessTransformerClass() {
		return null;
	}

	@Override
	public String[] getASMTransformerClass() {
		return new String[] {"mods.immibis.connectedglass.ConnectedGlass$Transformer"};
	}

	@Override
	public String getModContainerClass() {
		return null;
	}

	@Override
	public String getSetupClass() {
		return null;
	}

	@Override
	public void injectData(Map<String, Object> data) {
	}
	
	public static class Transformer implements IClassTransformer {
		
		private static class StainedGlassTransformerVisitor extends ClassVisitor {
			public StainedGlassTransformerVisitor(ClassVisitor parent) {
				super(Opcodes.ASM4, parent);
			}
			
			private void generateGetBlockTexture(MethodVisitor mv) {
				mv.visitCode();
				mv.visitVarInsn(Opcodes.ALOAD, 1);
				mv.visitVarInsn(Opcodes.ILOAD, 2);
				mv.visitVarInsn(Opcodes.ILOAD, 3);
				mv.visitVarInsn(Opcodes.ILOAD, 4);
				mv.visitVarInsn(Opcodes.ILOAD, 5);
				mv.visitMethodInsn(Opcodes.INVOKESTATIC, "mods/immibis/connectedglass/Hooks", "getStainedBlockTexture", "(Lnet/minecraft/world/IBlockAccess;IIII)Lnet/minecraft/util/IIcon;");
				mv.visitInsn(Opcodes.ARETURN);
				mv.visitMaxs(5, 6);
				mv.visitEnd();
			}
			
			@Override
			public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
				if((name.equals("registerBlockIcons") || name.equals("func_149651_a")) && desc.equals("(Lnet/minecraft/client/renderer/texture/IIconRegister;)V")) {
					return new MethodVisitor(Opcodes.ASM4, super.visitMethod(access, name, desc, signature, exceptions)) {
						@Override
						public void visitCode() {
							super.visitCode();
							super.visitVarInsn(Opcodes.ALOAD, 1);
							super.visitMethodInsn(Opcodes.INVOKESTATIC, "mods/immibis/connectedglass/Hooks", "registerStainedIcons", "(Lnet/minecraft/client/renderer/texture/IIconRegister;)V");
						}
						@Override
						public void visitMaxs(int maxStack, int maxLocals) {
							if(maxStack < 1) maxStack = 1;
							super.visitMaxs(maxStack, maxLocals);
						}
					};
				}
				return super.visitMethod(access, name, desc, signature, exceptions);
			}
			
			@Override
			public void visitEnd() {
				generateGetBlockTexture(super.visitMethod(Opcodes.ACC_PUBLIC, "getIcon", "(Lnet/minecraft/world/IBlockAccess;IIII)Lnet/minecraft/util/IIcon;", null, new String[0]));
				generateGetBlockTexture(super.visitMethod(Opcodes.ACC_PUBLIC, "func_149673_e", "(Lnet/minecraft/world/IBlockAccess;IIII)Lnet/minecraft/util/IIcon;", null, new String[0]));
				
				super.visitEnd();
			}
		}
		
		private static class NormalGlassTransformerVisitor extends ClassVisitor {
			public NormalGlassTransformerVisitor(ClassVisitor parent) {
				super(Opcodes.ASM4, parent);
			}
			
			private void generateGetBlockTexture(MethodVisitor mv) {
				mv.visitCode();
				mv.visitVarInsn(Opcodes.ALOAD, 1);
				mv.visitVarInsn(Opcodes.ILOAD, 2);
				mv.visitVarInsn(Opcodes.ILOAD, 3);
				mv.visitVarInsn(Opcodes.ILOAD, 4);
				mv.visitVarInsn(Opcodes.ILOAD, 5);
				mv.visitMethodInsn(Opcodes.INVOKESTATIC, "mods/immibis/connectedglass/Hooks", "getBlockTexture", "(Lnet/minecraft/world/IBlockAccess;IIII)Lnet/minecraft/util/IIcon;");
				mv.visitInsn(Opcodes.ARETURN);
				mv.visitMaxs(5, 6);
				mv.visitEnd();
			}
			
			private void generateRegisterIcons(String methodName, MethodVisitor mv) {
				mv.visitCode();
				mv.visitVarInsn(Opcodes.ALOAD, 1);
				mv.visitMethodInsn(Opcodes.INVOKESTATIC, "mods/immibis/connectedglass/Hooks", "registerIcons", "(Lnet/minecraft/client/renderer/texture/IIconRegister;)V");
				mv.visitVarInsn(Opcodes.ALOAD, 0);
				mv.visitVarInsn(Opcodes.ALOAD, 1);
				mv.visitMethodInsn(Opcodes.INVOKESPECIAL, "net/minecraft/block/BlockBreakable", methodName, "(Lnet/minecraft/client/renderer/texture/IIconRegister;)V");
				mv.visitInsn(Opcodes.RETURN);
				mv.visitMaxs(2, 2);
				mv.visitEnd();
			}
			
			@Override
			public void visitEnd() {
				// obfuscated or not? no idea, so just generate both
				generateGetBlockTexture(super.visitMethod(Opcodes.ACC_PUBLIC, "getIcon", "(Lnet/minecraft/world/IBlockAccess;IIII)Lnet/minecraft/util/IIcon;", null, new String[0]));
				generateGetBlockTexture(super.visitMethod(Opcodes.ACC_PUBLIC, "func_149673_e", "(Lnet/minecraft/world/IBlockAccess;IIII)Lnet/minecraft/util/IIcon;", null, new String[0]));
				
				generateRegisterIcons("registerBlockIcons", super.visitMethod(Opcodes.ACC_PUBLIC, "registerBlockIcons", "(Lnet/minecraft/client/renderer/texture/IIconRegister;)V", null, new String[0]));
				generateRegisterIcons("func_149651_a", super.visitMethod(Opcodes.ACC_PUBLIC, "func_149651_a", "(Lnet/minecraft/client/renderer/texture/IIconRegister;)V", null, new String[0]));
				
				super.visitEnd();
			}
		}
		
		@Override
		public byte[] transform(String arg0, String arg1, byte[] arg2) {
			
			if(arg0.equals("net.minecraft.block.BlockGlass") || arg1.equals("net.minecraft.block.BlockGlass")) {
				ClassWriter cw = new ClassWriter(0);
				new ClassReader(arg2).accept(new NormalGlassTransformerVisitor(cw), 0);
				return cw.toByteArray();
			}
			
			if(arg0.equals("net.minecraft.block.BlockStainedGlass") || arg1.equals("net.minecraft.block.BlockStainedGlass")) {
				ClassWriter cw = new ClassWriter(0);
				new ClassReader(arg2).accept(new StainedGlassTransformerVisitor(cw), 0);
				return cw.toByteArray();
			}
			
			return arg2;
		}
	}

}
