package mods.immibis.am2.arrays;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;

import net.minecraft.block.Block;
import net.minecraft.world.World;

import mods.immibis.am2.AdvancedMachines;
import mods.immibis.core.api.util.XYZ;

class ArrayScanner {

	private ArrayControllerTile rootTile;
	public ArrayScanner(ArrayControllerTile root) {
		this.rootTile = root;
	}
	
	private Set<XYZ> visited = new HashSet<XYZ>();
	private Queue<XYZ> bfsQueue = new LinkedList<XYZ>();
	private World w;
	
	int numCables, numSolars, numControllers, numWaterBlocks, totEffHeight, numBlocksScanned;

	public void tick() {
		if(bfsQueue.isEmpty()) {
			numBlocksScanned = visited.size();
			visited.clear();
			
			rootTile.onScanFinished();
			
			XYZ start = new XYZ(rootTile.xCoord, rootTile.yCoord, rootTile.zCoord);
			visited.add(start);
			for(int dir = 0; dir < 6; dir++)
				bfsQueue.add(start.step(dir));
			
			w = rootTile.worldObj;
			numCables = 0;
			numControllers = 0;
			numSolars = 0;
			numWaterBlocks = 0;
			totEffHeight = 0;
		}
		
		XYZ xyz;
		do {
			xyz = bfsQueue.poll();
			if(xyz == null)
				return;
		} while(!visited.add(xyz));
		
		if(!w.blockExists(xyz.x, xyz.y, xyz.z))
			return;
		
		int id = w.getBlockId(xyz.x, xyz.y, xyz.z);
		if(id == 0)
			return;
		
		if(id == AdvancedMachines.blockArrayCable.blockID) {
			for(int dir = 0; dir < 6; dir++)
				bfsQueue.add(xyz.step(dir));
			numCables++;
			
		} else if(id == AdvancedMachines.blockArrayController.blockID) {
			numControllers++;
			
		} else if(id == AdvancedMachines.blockArrayDevice.blockID) {
			switch(w.getBlockMetadata(xyz.x, xyz.y, xyz.z) & 3) {
			case ArrayGeneratorBlock.META_SOLAR:
				if(checkSolarActive(xyz))
					numSolars++;
				break;
				
			case ArrayGeneratorBlock.META_WATER:
				numWaterBlocks += countWaterBlocks(xyz);
				break;
				
			case ArrayGeneratorBlock.META_WIND:
				int effHeight = getEffectiveHeight(xyz);
				if(effHeight + 64 <= AdvancedMachines.maxArrayWindmillEffectiveHeight)
					totEffHeight += effHeight;
				break;
			}
		}
		
		
		
	}

	private int getEffectiveHeight(XYZ p) {
		int rv = p.y - 64;
		for(int dz = -4; dz <= 4; dz++)
		for(int dx = -4; dx <= 4; dx++)
		for(int dy = -2; dy <= 4; dy++) {
			int x=p.x+dx, y=p.y+dy, z=p.z+dz;
			if(!w.blockExists(x, y, z) || !w.isAirBlock(x, y, z))
				rv--;
		}
		return rv < 0 ? 0 : rv;
	}

	private boolean checkSolarActive(XYZ p) {
		return w.canBlockSeeTheSky(p.x, p.y+1, p.z) && w.getBlockId(p.x, p.y+1, p.z) != Block.snow.blockID;
	}
	
	private int countWaterBlocks(XYZ p) {
		int rv = 0;
		for(int dz = -1; dz <= 1; dz++)
		for(int dx = -1; dx <= 1; dx++)
		for(int dy = -1; dy <= 1; dy++)
			if(w.blockExists(p.x+dx, p.y+dy, p.z+dz)) {
				int id = w.getBlockId(p.x+dx, p.y+dy, p.z+dz);
				if(id == Block.waterStill.blockID || id == Block.waterMoving.blockID)
					rv++;
			}
		return rv;
	}

}
