package mods.immibis.am2.arrays;

import ic2.core.IC2;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.world.IBlockAccess;

public class BlockArrayCable extends Block {
	public static int model;

	public BlockArrayCable(int id) {
		super(id, Material.cloth);
		
		setStepSound(soundClothFootstep);
		setUnlocalizedName("advmachine.arraycable");
		setCreativeTab(IC2.tabIC2);
		setHardness(0.3f);
		setTextureName("adv_machines_immibis:arraycable");
	}
	
	@Override
	public int getRenderType() {
		return model;
	}
	
	@Override
	public int getMobilityFlag() {
		return 2; // unpushable
	}

	public static boolean connects(IBlockAccess world, int x, int y, int z) {
		int id = world.getBlockId(x, y, z);
		return id != 0;
	}
}
