package mods.immibis.am2;

import net.minecraft.client.resources.I18n;
import mods.immibis.core.api.util.BaseGuiContainer;

public class GuiAM2 extends BaseGuiContainer<ContainerAM2> {

	public GuiAM2(ContainerAM2 container) {
		super(container, 176, 166, container.getTile().getGUIResource());
	}

	@Override
	protected void drawGuiContainerBackgroundLayer(float var1, int var2, int var3) {
		super.drawGuiContainerBackgroundLayer(var1, var2, var3);
		
		drawTexturedModalRect(guiLeft + 80, guiTop + 34, 177, 14, container.progressPixels, 17);
		drawTexturedModalRect(guiLeft + 59, guiTop + 50 - container.energyPixels, 179, 14 - container.energyPixels, 7, container.energyPixels);
		
		String name = I18n.getString(container.getTile().getMachineName());
		
		fontRenderer.drawString(name,
			guiLeft + (xSize - fontRenderer.getStringWidth(name)) / 2,
			guiTop + 5,
			0x404040);
		
		int y = 20;
		for(String line : container.getTile().getGUIText(container.speed).split("\n")) {
			fontRenderer.drawString(line, guiLeft + 4, guiTop + y, 0x404040);
			y += 12;
		}
		//drawString(container.getTile().get
	}
}
