package immibis.ars.beams;

import immibis.core.BasicInventory;
import immibis.core.api.porting.PortableContainer;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Slot;

public class ContainerInventoryContentsFilter extends PortableContainer {

	public ContainerInventoryContentsFilter(EntityPlayer player, TileInventoryContentsFilter inv) {
		super(player, inv);
		
		for(int x = 0; x < 9; x++)
			addSlot(new Slot(player.inventory, x, 8 + 18*x, 198));
		
		for(int y = 0; y < 3; y++)
			for(int x = 0; x < 9; x++)
				addSlot(new Slot(player.inventory, x + y*9 + 9, 8 + 18*x, 140 + 18*y));
		
		addSlot(new Slot(inv, 0, 80, 31));
	}

	@Override
	public ItemStack transferStackInSlot(int slot) {
		if(slot == 36)
			BasicInventory.mergeStackIntoRange(inv, player.inventory, 0, 0, 36);
		else
			BasicInventory.mergeStackIntoRange(player.inventory, inv, slot, 0, 1);
		return null;
	}
}
