package immibis.ars.beams;

import java.util.ArrayList;

import net.minecraft.src.*;
import immibis.core.BlockCombined;
import immibis.core.api.Dir;
import immibis.core.api.porting.SidedProxy;
import immibis.core.aspects.ClientOnly;

public class BlockBeamStuff extends BlockCombined {
	
	public static int model;

	public BlockBeamStuff(int id) {
		super(id, Material.iron, "/immibis/ars/textures/tesla.png");
		
		ModLoader.registerBlock(this, ItemBeamStuff.class);
		
		model = SidedProxy.instance.getUniqueBlockModelID("immibis.ars.beams.BlockRenderer", true);
	}
	
	//@Override
	//public int getRenderType() {return model;}
	
	private int getTextureBase(int meta) {
		switch(meta) {
		case 0: return 1 + 16*0; // filter
		case 1: return 0; // tesla coil; special case that doesn't use this method
		case 2: return 8 + 16*0; // upgrade combiner
		case 3: return 1 + 16*3; // range upgrade
		case 4: return 1 + 16*5; // emp upgrade 
		case 5: return 1 + 16*7; // speed upgrade
		case 6: return 8 + 16*3; // loot collector
		case 7: return 1 + 16*11; // field filter
		case 8: return 1 + 16*9; // inventory contents filter
		case 9: return 8 + 16*5; // suppressor upgrade
		case 10: return 8 + 16*7; // remote potion applicator
		default: return 0;
		}
	}
	
	/* $if jclient$ */
	@ClientOnly
	@Override
	public int getBlockTexture(IBlockAccess w, int x, int y, int z, int side) {
		TileEntity te = w.getBlockTileEntity(x, y, z);
		if(te instanceof TileTeslaCoil)
			return 16;
		else if(te instanceof TileBeamEmitter) {
			int tex = getTextureBase(w.getBlockMetadata(x, y, z));
			return tex + (side == ((TileBeamEmitter)te).outputFace ? 16 : 0) + side;
		}
		else
			return 1;
	}
	/* $endif$ */

	@Override
	public int getBlockTextureFromSideAndMetadata(int side, int data) {
		if(data == 1)
			return 16;
		return (side == Dir.PY ? 16 : 0) + getTextureBase(data) + side;
	}

	@Override
	public TileEntity getBlockEntity(int data) {
		switch(data) {
		case 0: return new TileUpgradeUnit();
		case 1: return new TileTeslaCoil();
		case 2: return new TileUpgradeCombiner();
		case 3: return new TileRangeUpgrade();
		case 4: return new TileEMPUpgrade();
		case 5: return new TileSpeedUpgrade();
		case 6: return new TileLootCollector();
		case 7: return new TileFieldFilter();
		case 8: return new TileInventoryContentsFilter();
		case 9: return new TileSuppressorUpgrade();
		case 10: return new TilePotionUpgrade();
		default: return null;
		}
	}

	@Override
	public void addCreativeItems(ArrayList arraylist) {
		for(int k = 0; k < 11; k++)
			arraylist.add(new ItemStack(this, 1, k));
	}

}
