package immibis.ars.beams;

import immibis.ars.mod_AdvancedRepulsionSystems;
import immibis.ars.beams.logictypes.ClassDetector;
import immibis.ars.beams.logictypes.Negate;
import immibis.ars.beams.logictypes.Intersection;
import immibis.ars.beams.logictypes.NothingDetector;
import immibis.ars.beams.logictypes.RedstoneInput;
import immibis.ars.beams.logictypes.Union;
import immibis.core.api.porting.SidedProxy;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import net.minecraft.src.Block;
import net.minecraft.src.EntityAnimal;
import net.minecraft.src.EntityArrow;
import net.minecraft.src.EntityBlaze;
import net.minecraft.src.EntityCaveSpider;
import net.minecraft.src.EntityChicken;
import net.minecraft.src.EntityCow;
import net.minecraft.src.EntityCreeper;
import net.minecraft.src.EntityEnderman;
import net.minecraft.src.EntityGhast;
import net.minecraft.src.EntityIronGolem;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityMagmaCube;
import net.minecraft.src.EntityMooshroom;
import net.minecraft.src.EntityOcelot;
import net.minecraft.src.EntityPig;
import net.minecraft.src.EntityPigZombie;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntitySheep;
import net.minecraft.src.EntitySilverfish;
import net.minecraft.src.EntitySkeleton;
import net.minecraft.src.EntitySlime;
import net.minecraft.src.EntitySnowman;
import net.minecraft.src.EntitySpider;
import net.minecraft.src.EntitySquid;
import net.minecraft.src.EntityThrowable;
import net.minecraft.src.EntityVillager;
import net.minecraft.src.EntityWolf;
import net.minecraft.src.EntityZombie;
import net.minecraft.src.IMob;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;

public abstract class LogicType {
	private static Map<Integer, LogicType> types = new HashMap<Integer, LogicType>();
	private static Map<Item, LogicType> items = new HashMap<Item, LogicType>();
	
	public static LogicType get(int id) {
		return types.get(id);
	}
	
	public static void register(int id, String name, LogicType type, Item item) {
		if(types.containsKey(id))
			throw new IllegalArgumentException("Logic card type "+id+" is already registered.");
		
		if(name != null) {
			types.put(id, type);
			SidedProxy.instance.addLocalization("immibis.ars.logiccard."+id+".name", name);
		}
		
		if(item != null) items.put(item, type);
	}
	
	public static Set<Integer> getAllTypeIDs() {
		return types.keySet();
	}
	
	public abstract EntityFilter createFilter(TileUpgradeUnit container, EntityFilter[] in);
	
	public static final int ID_PLAYER = 0;
	public static final int ID_AND = 1;
	public static final int ID_OR = 2;
	public static final int ID_INVERT = 3;
	public static final int ID_BLANK = 4;
	public static final int ID_LIVING = 5;
	public static final int ID_REDSTONE = 6;
	public static final int ID_ANIMAL = 7;
	public static final int ID_MOB = 8;
	public static final int ID_ITEM = 9;
	
	static void init() {
		register(ID_PLAYER, "Player detector token", new ClassDetector(EntityPlayer.class), null);
		register(ID_AND, "Intersection token", new Intersection(), null);
		register(ID_OR, "Union token", new Union(), null);
		register(ID_INVERT, "Difference token", new Negate(), null);
		register(ID_BLANK, "Blank token", new NothingDetector(), null);
		register(ID_LIVING, "Life detector token", new ClassDetector(EntityLiving.class), null);
		register(ID_REDSTONE, "Redstone input token", new RedstoneInput(), Item.redstone);
		register(ID_ANIMAL, "Animal detector token", new ClassDetector(EntityAnimal.class), null);
		register(ID_MOB, "Mob detector token", new ClassDetector(IMob.class), null);
		register(ID_ITEM, "Item detector token", new ClassDetector(EntityItem.class), Item.itemsList[Block.cobblestone.blockID]);
		register(-1, null, new ClassDetector(EntityCreeper.class), Item.gunpowder);
		register(-1, null, new ClassDetector(EntityChicken.class), Item.egg);
		register(-1, null, new ClassDetector(EntityCow.class), Item.beefRaw);
		register(-1, null, new ClassDetector(EntityOcelot.class), Item.fishRaw);
		register(-1, null, new ClassDetector(EntityPig.class), Item.porkRaw);
		register(-1, null, new ClassDetector(EntitySheep.class), Item.itemsList[Block.cloth.blockID]);
		register(-1, null, new ClassDetector(EntitySquid.class), Item.bucketWater);
		register(-1, null, new ClassDetector(EntityVillager.class), null);
		register(-1, null, new ClassDetector(EntityEnderman.class), Item.enderPearl);
		register(-1, null, new ClassDetector(EntityWolf.class), Item.bone);
		register(-1, null, new ClassDetector(EntityPigZombie.class), Item.goldNugget);
		register(-1, null, new ClassDetector(EntityBlaze.class), Item.blazeRod);
		register(-1, null, new ClassDetector(EntityCaveSpider.class), null);
		register(-1, null, new ClassDetector(EntityZombie.class), Item.rottenFlesh);
		register(-1, null, new ClassDetector(EntityGhast.class), Item.ghastTear);
		register(-1, null, new ClassDetector(EntityMagmaCube.class), Item.magmaCream);
		register(-1, null, new ClassDetector(EntitySilverfish.class), null);
		register(-1, null, new ClassDetector(EntitySkeleton.class), Item.bow);
		register(-1, null, new ClassDetector(EntitySlime.class), Item.slimeBall);
		register(-1, null, new ClassDetector(EntitySnowman.class), Item.snowball);
		register(-1, null, new ClassDetector(EntityIronGolem.class), Item.ingotIron);
		register(-1, null, new ClassDetector(EntityArrow.class), Item.arrow);
		register(-1, null, new ClassDetector(EntityThrowable.class), null);
	}

	public static LogicType getForItem(ItemStack is) {
		if(is == null)
			return null;
		
		if(is.itemID == BeamsMain.itemLogicCard.shiftedIndex)
			return get(is.getItemDamage());
		return items.get(is.getItem());
	}

}
