package immibis.ars.beams;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/* $if mc > 1.3$ */
import cpw.mods.fml.common.ICraftingHandler;
import cpw.mods.fml.common.registry.GameRegistry;
/* $endif$ */

import ic2.api.Items;
import immibis.ars.Functions;
import immibis.ars.ItemComponent;
import immibis.ars.mod_AdvancedRepulsionSystems;
import immibis.core.api.porting.SidedProxy;
import immibis.core.aspects.ClientOnly;
import net.minecraft.src.Block;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IInventory;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.ModLoader;
import net.minecraft.src.forge.*;

public class BeamsMain {
	public static BlockBeam blockBeam;
	public static BlockBeamStuff blockBeamMachines;
	public static ItemLogicCard itemLogicCard;

	public static void init() {
		
		ModLoader.registerTileEntity(TileUpgradeUnit.class, "AdvRepSys TileUpgradeUnit");
		ModLoader.registerTileEntity(TileTeslaCoil.class, "AdvRepSys TileTeslaCoil");
		ModLoader.registerTileEntity(TileUpgradeCombiner.class, "AdvRepSys UpgradeCombiner");
		ModLoader.registerTileEntity(TileRangeUpgrade.class, "AdvRepSys RangeUpgrade");
		ModLoader.registerTileEntity(TileEMPUpgrade.class, "AdvRepSys EMPUpgrade");
		ModLoader.registerTileEntity(TileSpeedUpgrade.class, "AdvRepSys SpeedUpgrade");
		ModLoader.registerTileEntity(TileLootCollector.class, "AdvRepSys LootCollector");
		ModLoader.registerTileEntity(TileFieldFilter.class, "AdvRepSys FieldFilter");
		ModLoader.registerTileEntity(TileInventoryContentsFilter.class, "AdvRepSys InventoryContentsFilter");
		ModLoader.registerTileEntity(TilePotionUpgrade.class, "AdvRepSys PotionUpgrade");
		ModLoader.registerTileEntity(TileSuppressorUpgrade.class, "AdvRepSys SuppressorUpgrade");
		
		SidedProxy.instance.preloadTexture("/immibis/ars/beams/world.png");
		SidedProxy.instance.addLocalization("death.ARSteslacoil", "was zapped");
		
		itemLogicCard = new ItemLogicCard(Functions.getItemIdFor("itemLogicCard", 11120));
		blockBeam = new BlockBeam(Functions.getBlockIdFor("beam", 627));
		blockBeamMachines = new BlockBeamStuff(Functions.getBlockIdFor("teslaMachines", 628));

		try {
			Method m = BeamsMain.class.getDeclaredMethod("initClient");
			m.invoke(null);
		} catch(NoSuchMethodException e) {
		} catch (IllegalAccessException e) {
			throw new RuntimeException(e);
		} catch (InvocationTargetException e) {
			throw new RuntimeException(e);
		}
		
		ItemStack progFilter = new ItemStack(blockBeamMachines, 1, 0);
		ItemStack teslaCoil = new ItemStack(blockBeamMachines, 1, 1);
		ItemStack upgradeCombiner = new ItemStack(blockBeamMachines, 1, 2);
		ItemStack rangeUpgrade = new ItemStack(blockBeamMachines, 1, 3);
		ItemStack empUpgrade = new ItemStack(blockBeamMachines, 1, 4);
		ItemStack speedUpgrade = new ItemStack(blockBeamMachines, 1, 5);
		ItemStack lootCollector = new ItemStack(blockBeamMachines, 1, 6);
		ItemStack fieldFilter = new ItemStack(blockBeamMachines, 1, 7);
		ItemStack invFilter = new ItemStack(blockBeamMachines, 1, 8);
		ItemStack suppressor = new ItemStack(blockBeamMachines, 1, 9);
		ItemStack potionApplicator = new ItemStack(blockBeamMachines, 1, 10);
		
		Object energyModulator = new ItemStack(mod_AdvancedRepulsionSystems.itemComponent, 1, ItemComponent.META_ENERGY_MODULATOR);
		
		Object refinedIron = Items.getItem("refinedIronIngot");
		//Object copper = Items.getItem("copperIngot");
		
		ModLoader.addRecipe(teslaCoil,
			" # ",
			" | ",
			"-H-",
			'#', Block.blockSteel,
			'|', Item.ingotIron,
			'H', Items.getItem("hvTransformer"),
			'-', Items.getItem("glassFiberCableItem")
		);
		
		ModLoader.addRecipe(copyStackWithCount(progFilter, 4),
			"I^I",
			".M.",
			"C.C",
			'M', Items.getItem("machine"),
			'C', Items.getItem("electronicCircuit"),
			'I', refinedIron,
			'.', Block.glass,
			'^', Block.torchRedstoneActive
		);
		
		ModLoader.addRecipe(copyStackWithCount(upgradeCombiner, 4),
			"G^G",
			".M.",
			"G.G",
			'G', Item.ingotGold,
			'M', Items.getItem("machine"),
			'^', Block.torchRedstoneActive,
			'.', Block.glass
		);
		
		ModLoader.addRecipe(rangeUpgrade,
			"I^I",
			"CMC",
			"CCC",
			'I', refinedIron,
			'C', Items.getItem("copperCableItem"),
			'^', Block.torchRedstoneActive,
			'M', Items.getItem("machine")
		);
		
		ModLoader.addRecipe(empUpgrade,
			"I^I",
			"CTC",
			"OCO",
			'I', refinedIron,
			'^', Block.torchRedstoneActive,
			'T', Items.getItem("mvTransformer"),
			'O', Item.enderPearl,
			'C', Items.getItem("glassFiberCableItem")
		);
		
		ModLoader.addRecipe(speedUpgrade,
			"I^I",
			"SMS",
			"SSS",
			'I', refinedIron,
			'^', Block.torchRedstoneActive,
			'M', Items.getItem("machine"),
			'S', Item.sugar
		);
		
		ModLoader.addRecipe(lootCollector,
			"I^I",
			"OMO",
			"OOO",
			'I', refinedIron,
			'^', Block.torchRedstoneActive,
			'M', Items.getItem("machine"),
			'O', Item.eyeOfEnder
		);
		
		ModLoader.addRecipe(potionApplicator,
			"I^I",
			"OMO",
			"BOB",
			'I', refinedIron,
			'^', Block.torchRedstoneActive,
			'O', Item.eyeOfEnder,
			'M', Items.getItem("machine"),
			'B', Item.glassBottle
		);
		
		ModLoader.addRecipe(suppressor,
			"I^I",
			"IMI",
			"ICI",
			'I', refinedIron,
			'^', Block.torchRedstoneActive,
			'M', Items.getItem("machine"),
			'C', Items.getItem("advancedCircuit")
		);
		
		ModLoader.addShapelessRecipe(fieldFilter,
			progFilter,
			energyModulator
		);
		
		ModLoader.addShapelessRecipe(invFilter,
			progFilter,
			Item.enderPearl
		);
		
		ItemStack blankToken = new ItemStack(itemLogicCard, 1, LogicType.ID_BLANK);
		
		ModLoader.addRecipe(copyStackWithCount(blankToken, 16),
			" P ",
			"PRP",
			" P ",
			'P', Item.paper,
			'R', Item.redstone
		);
		
		ModLoader.addShapelessRecipe(new ItemStack(itemLogicCard, 1, LogicType.ID_PLAYER), blankToken, Item.appleRed);
		ModLoader.addShapelessRecipe(new ItemStack(itemLogicCard, 1, LogicType.ID_LIVING), blankToken, Item.sugar);
		ModLoader.addShapelessRecipe(new ItemStack(itemLogicCard, 1, LogicType.ID_REDSTONE), blankToken, Item.redstone);
		ModLoader.addShapelessRecipe(new ItemStack(itemLogicCard, 1, LogicType.ID_ANIMAL), blankToken, Item.porkRaw);
		ModLoader.addShapelessRecipe(new ItemStack(itemLogicCard, 1, LogicType.ID_MOB), blankToken, Item.rottenFlesh);
		ModLoader.addShapelessRecipe(new ItemStack(itemLogicCard, 1, LogicType.ID_ITEM), blankToken, Item.ingotIron);
		
		ModLoader.addRecipe(new ItemStack(itemLogicCard, 1, LogicType.ID_AND),
			"!!!",
			"!C!",
			"! !",
			'C', blankToken,
			'!', Item.redstone
		);
		ModLoader.addRecipe(new ItemStack(itemLogicCard, 1, LogicType.ID_OR),
			"! !",
			"!C!",
			"!!!",
			'C', blankToken,
			'!', Item.redstone
		);
		ModLoader.addRecipe(new ItemStack(itemLogicCard, 1, LogicType.ID_INVERT),
			"!!!",
			" C ",
			'C', blankToken,
			'!', Item.redstone
		);
		
		ModLoader.addRecipe(blankToken, "#", '#', new ItemStack(itemLogicCard, 1, -1));
		
		// Logic card crafting doesn't use the ingredients
		// it just "imprints" the card with them
		/* $if mc < 1.3$
		MinecraftForge.registerCraftingHandler(new ICraftingHandler() {
			@Override public void onTakenFromCrafting(EntityPlayer player, ItemStack item, IInventory craftMatrix) {
		$else$ */
		GameRegistry.registerCraftingHandler(new ICraftingHandler() {
			@Override public void onSmelting(EntityPlayer player, ItemStack item) {}			
			@Override public void onCrafting(EntityPlayer player, ItemStack item, IInventory craftMatrix) {
		/* $endif$ */
				if(item.getItem() == itemLogicCard && item.getItemDamage() != LogicType.ID_BLANK) {
					for(int k = 0; k < craftMatrix.getSizeInventory(); k++) {
						ItemStack is = craftMatrix.getStackInSlot(k);
						if(is != null && is.getItem() != itemLogicCard)
							is.stackSize++;
					}
				}
			}
		});
	}
	
	private static ItemStack copyStackWithCount(ItemStack s, int count) {
		s = s.copy();
		s.stackSize = count;
		return s;
	}
	
	@ClientOnly
	public static void initClient() {
		//EntityRegistry.registerModEntity(EntityBoltFX.class, "boltfx", id, mod, trackingRange, updateFrequency, sendsVelocityUpdates)
		
		/* $if mc >= 1.3$ */
		cpw.mods.fml.client.registry.RenderingRegistry.registerEntityRenderingHandler(EntityBoltFX.class, new EntityBoltFXRenderer());
		/* $endif$ */
	}
}
