package immibis.ars;

import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.World;

public class ItemFrequenzCard extends Item {

	private StringBuffer info = new StringBuffer();

	public ItemFrequenzCard(int i) {
		super(i);
		setIconIndex(17);
		setMaxStackSize(1);

		/* $if mc > 1.3$ */
		setCreativeTab(net.minecraft.src.CreativeTabs.tabMisc);
		/* $endif$ */
	}

	@Override
	public String getTextureFile() {
		return "/immibis/ars/textures/items.png";
	}

	@Override
	public boolean isRepairable() {
		return false;
	}

	@Override
	public ItemStack onItemRightClick(ItemStack itemstack, World world, EntityPlayer entityplayer) {

		if (Functions.getTAGfromItemstack(itemstack).hasKey("Generator_ID")) {
			info.setLength(0);
			info.append("[MFFS Frequency Card] Frequency encoded: ").append(String.valueOf(Functions.getTAGfromItemstack(itemstack).getInteger("Generator_ID")));
		} else {
			info.setLength(0);
			info.append("[MFFS Frequency Card] is empty ");
		}
		Functions.ChattoPlayer(entityplayer, info.toString());
		return itemstack;

	}

}
