package immibis.ars;

import immibis.core.api.porting.SidedProxy;

import java.io.File;

import net.minecraft.src.EntityPlayer;
import net.minecraft.src.ItemStack;
import net.minecraft.src.NBTTagCompound;
import net.minecraftforge.common.*;
import net.minecraft.src.forge.*;

import java.util.logging.Logger;

public class Functions {

	private final static Logger log = Logger.getLogger("Client");

	public static void DisplayInfo(String s) {
		log.info(s);
	}

	public static File getMinecraftDir() {
		return SidedProxy.instance.getMinecraftDir();
	}

	public static int getBlockIdFor(String s, int i) {
		if (mod_AdvancedRepulsionSystems.config == null) {
			return i;
		}
		/* $if mc > 1.4$ */
		return mod_AdvancedRepulsionSystems.config.get("1", s, i).getInt(i);
		/* $else$
		return (new Integer(mod_AdvancedRepulsionSystems.config.getOrCreateIntProperty(s, "1", i).value)).intValue();
		$endif$ */
	}

	public static int getItemIdFor(String s, int i) {
		if (mod_AdvancedRepulsionSystems.config == null) {
			return i;
		}
		/* $if mc > 1.4$ */
		return mod_AdvancedRepulsionSystems.config.get("2", s, i).getInt(i);
		/* $else$
		return (new Integer(mod_AdvancedRepulsionSystems.config.getOrCreateIntProperty(s, "2", i).value)).intValue();
		$endif$ */
	}

	public static void ChattoPlayer(EntityPlayer player, String Message) {
		SidedProxy.instance.sendChat(Message, player);
	}

	public static NBTTagCompound getTAGfromItemstack(ItemStack itemStack) {
		NBTTagCompound tag = itemStack.getTagCompound();
		if (tag == null) {
			tag = new NBTTagCompound();
			itemStack.setTagCompound(tag);
		}
		return tag;
	}

	public static boolean getConfigBoolean(String key, boolean def) {
		/* $if mc > 1.4$ */
		return mod_AdvancedRepulsionSystems.config.get(Configuration.CATEGORY_GENERAL, key, def).getBoolean(def);
		/* $else$
		Property p = mod_AdvancedRepulsionSystems.config.getOrCreateBooleanProperty(key, Configuration.CATEGORY_GENERAL, def);
		return Boolean.valueOf(p.value);
		$endif$ */
	}

	public static int getBalanceOption(String key, int def) {
		/* $if mc > 1.4$ */
		return mod_AdvancedRepulsionSystems.config.get(Configuration.CATEGORY_GENERAL, key, def).getInt(def);
		/* $else$
		return Integer.parseInt(mod_AdvancedRepulsionSystems.config.getOrCreateIntProperty(key, Configuration.CATEGORY_GENERAL, def).value);
		$endif$ */
	}

}
