package immibis.ars.projectors;

import immibis.ars.mod_AdvancedRepulsionSystems;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.ItemStack;
import net.minecraft.server.NBTTagCompound;

public class TileProjectorTube extends TileProjector
{
    private int length = 1;
    private int maxlength;
    private int radius = 2;
    private int maxradius;
    private short mode_designe;
    private boolean inhiitor = true;
    public int offsetX;
    public int offsetY;

    public TileProjectorTube()
    {
        this.maxlength = mod_AdvancedRepulsionSystems.maxSize;
        this.maxradius = mod_AdvancedRepulsionSystems.maxTubeRadius;
        this.mode_designe = 1;
    }

    protected boolean acceptsUpgradeType(int var1)
    {
        return super.acceptsUpgradeType(var1) || var1 == 9 || var1 == 1 || var1 == 2;
    }

    public void handleButton(int var1)
    {
        if (!this.getActive())
        {
            switch (var1)
            {
                case 0:
                    if (!this.getActive() && this.getRadius() < this.getMaxradius())
                    {
                        this.setRadius(this.getRadius() + 1);
                    }

                    break;

                case 1:
                    if (!this.getActive() && this.getRadius() > 2)
                    {
                        this.setRadius(this.getRadius() - 1);
                    }

                    break;

                case 2:
                    if (!this.getActive() && this.getlength() < this.getMaxlength())
                    {
                        this.setlength(this.getlength() + 1);
                    }

                    break;

                case 3:
                    if (!this.getActive() && this.getlength() > 1)
                    {
                        this.setlength(this.getlength() - 1);
                    }

                    break;

                case 4:
                    if (!this.getActive() && this.getmode_designe() < 2)
                    {
                        this.setmode_designe((short)(this.getmode_designe() + 1));
                    }

                    break;

                case 5:
                    if (!this.getActive() && this.getmode_designe() > 1)
                    {
                        this.setmode_designe((short)(this.getmode_designe() - 1));
                    }
            }
        }
    }

    /**
     * Reads a tile entity from NBT.
     */
    public void a(NBTTagCompound var1)
    {
        super.a(var1);
        this.length = var1.getInt("length");
        this.radius = var1.getInt("radius");
        this.mode_designe = var1.getShort("mode_designe");
        this.offsetX = var1.getInt("offsetX");
        this.offsetY = var1.getInt("offsetY");
    }

    /**
     * Writes a tile entity to NBT.
     */
    public void b(NBTTagCompound var1)
    {
        super.b(var1);
        var1.setInt("length", this.length);
        var1.setInt("radius", this.radius);
        var1.setShort("mode_designe", this.mode_designe);
        var1.setInt("offsetX", this.offsetX);
        var1.setInt("offsetY", this.offsetY);
    }

    public int getMaxlength()
    {
        return this.maxlength;
    }

    public int getlength()
    {
        return this.length;
    }

    public int getRadius()
    {
        return this.radius;
    }

    public int getMaxradius()
    {
        return this.maxradius;
    }

    public void setRadius(int var1)
    {
        this.radius = var1;
        ++this.updateCount;
    }

    public void setRadiusinit(int var1)
    {
        this.radius = var1;
        ++this.updateCount;
    }

    public void setlength(int var1)
    {
        this.length = var1;
        ++this.updateCount;
    }

    public void setlengthinit(int var1)
    {
        this.length = var1;
        ++this.updateCount;
    }

    public short getmode_designe()
    {
        return this.mode_designe;
    }

    public void setmode_designe(short var1)
    {
        this.mode_designe = var1;
        ++this.updateCount;
    }

    public void setmode_designeinit(short var1)
    {
        this.mode_designe = var1;
        ++this.updateCount;
    }

    public boolean wrenchCanSetFacing(EntityHuman var1, int var2)
    {
        if (this.getFacing() != var2 && !this.getActive())
        {
            this.setFacing((short)var2);
            this.world.notify(this.x, this.y, this.z);
            return true;
        }
        else
        {
            return false;
        }
    }

    protected FFShape getFieldShape()
    {
        return new FFShapeTube(this, this.getFacing(), this.length, this.radius, this.mode_designe);
    }

    public void onActivateProjector()
    {
        int var1 = 0;
        int var2 = 0;
        int var3 = 0;
        int var4 = 0;
        int var5 = 0;
        int var6 = 0;
        int var7 = 0;
        byte var8 = 0;
        int var9 = 0;

        if (this.getFacing() == 0 || this.getFacing() == 1)
        {
            var2 = this.length;
            var1 = this.radius;
            var3 = this.radius;

            if (this.mode_designe == 2 && this.getFacing() == 0)
            {
                var5 = this.length;
            }

            if (this.mode_designe == 2 && this.getFacing() == 1)
            {
                var5 = this.length - this.length;
            }

            if (this.mode_designe == 2 && this.getFacing() == 0)
            {
                var5 = this.length - this.length;
            }

            if (this.mode_designe == 2 && this.getFacing() == 1)
            {
                var5 = this.length;
            }
        }

        if (this.getFacing() == 2 || this.getFacing() == 3)
        {
            var2 = this.radius;
            var3 = this.length;
            var1 = this.radius;

            if (this.mode_designe == 2 && this.getFacing() == 3)
            {
                var6 = this.length;
            }

            if (this.mode_designe == 2 && this.getFacing() == 2)
            {
                var6 = this.length - this.length;
            }

            if (this.mode_designe == 2 && this.getFacing() == 3)
            {
                var9 = this.length - this.length;
            }

            if (this.mode_designe == 2 && this.getFacing() == 2)
            {
                var9 = this.length;
            }
        }

        if (this.getFacing() == 4 || this.getFacing() == 5)
        {
            var2 = this.radius;
            var3 = this.radius;
            var1 = this.length;

            if (this.mode_designe == 2 && this.getFacing() == 5)
            {
                var4 = this.length;
            }

            if (this.mode_designe == 2 && this.getFacing() == 4)
            {
                var4 = this.length - this.length;
            }

            if (this.mode_designe == 2 && this.getFacing() == 5)
            {
                var7 = this.length - this.length;
            }

            if (this.mode_designe == 2 && this.getFacing() == 4)
            {
                var7 = this.length;
            }
        }

        for (int var10 = 0 - var3 + var6; var10 <= var3 - var9; ++var10)
        {
            for (int var11 = 0 - var1 + var4; var11 <= var1 - var7; ++var11)
            {
                for (int var12 = 0 - var2 + var5; var12 <= var2 - var8; ++var12)
                {
                    if (var12 >= 0 || !this.isDome())
                    {
                        int var13 = var1;
                        int var14 = var2;
                        int var15 = var3;

                        if (var1 == this.length && (this.getFacing() == 4 || this.getFacing() == 5))
                        {
                            var13 = var1 + 1;
                        }

                        if (var2 == this.length && (this.getFacing() == 0 || this.getFacing() == 1))
                        {
                            var14 = var2 + 1;
                        }

                        if (var3 == this.length && (this.getFacing() == 2 || this.getFacing() == 3))
                        {
                            var15 = var3 + 1;
                        }

                        if (var11 != 0 - var13 && var11 != var13 && var12 != 0 - var14 && var12 != var14 && var10 != 0 - var15 && var10 != var15 && this.isSubwater() && this.world.getMaterial(this.x + var11, this.y + var12, this.z + var10).isLiquid())
                        {
                            this.world.setTypeId(this.x + var11, this.y + var12, this.z + var10, 0);
                        }
                    }
                }
            }
        }
    }

    /**
     * When some containers are closed they call this on each slot, then drop whatever it returns as an EntityItem -
     * like when you close a workbench GUI.
     */
    public ItemStack splitWithoutUpdate(int var1)
    {
        return null;
    }

    public int[] getUpdate()
    {
        return new int[] {this.length, this.maxlength, this.radius, this.maxradius, this.mode_designe, this.inhiitor ? 1 : 0};
    }

    public void handleUpdate(int[] var1)
    {
        this.length = var1[0];
        this.maxlength = var1[1];
        this.radius = var1[2];
        this.maxradius = var1[3];
        this.mode_designe = (short)var1[4];
        this.inhiitor = var1[5] != 0;
    }

    public int estimateBlockCount()
    {
        return (this.radius * 2 + 1) * (this.isDome() ? 2 : 4) * this.length * (this.mode_designe == 2 ? 1 : 2);
    }
}
