package immibis.ars.projectors;

import immibis.ars.mod_AdvancedRepulsionSystems;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.ItemStack;
import net.minecraft.server.NBTTagCompound;

public class TileProjectorDeflector extends TileProjector
{
    private int lengthx = 0;
    private int lengthz = 0;
    private int maxlengthx;
    private int maxlengthz;
    private int distance = 0;
    private int maxdistance;

    public int[] getUpdate()
    {
        return new int[] {this.lengthx, this.lengthz, this.maxlengthx, this.maxlengthz, this.distance, this.maxdistance};
    }

    public void handleUpdate(int[] var1)
    {
        this.lengthx = var1[0];
        this.lengthz = var1[1];
        this.maxlengthx = var1[2];
        this.maxlengthz = var1[3];
        this.distance = var1[4];
        this.maxdistance = var1[5];
    }

    public TileProjectorDeflector()
    {
        this.maxlengthx = mod_AdvancedRepulsionSystems.maxSize;
        this.maxlengthz = mod_AdvancedRepulsionSystems.maxSize;
        this.maxdistance = mod_AdvancedRepulsionSystems.maxDeflectorDistance;
    }

    public void handleButton(int var1)
    {
        if (!this.getActive())
        {
            switch (var1)
            {
                case 0:
                    if (this.getlengthx() < this.getMaxlengthx())
                    {
                        this.setlengthx(this.getlengthx() + 1);
                    }

                    break;

                case 1:
                    if (this.getlengthx() > 0)
                    {
                        this.setlengthx(this.getlengthx() - 1);
                    }

                    break;

                case 2:
                    if (this.getlengthz() < this.getMaxlengthz())
                    {
                        this.setlengthz(this.getlengthz() + 1);
                    }

                    break;

                case 3:
                    if (this.getlengthz() > 0)
                    {
                        this.setlengthz(this.getlengthz() - 1);
                    }

                    break;

                case 4:
                    if (this.getDistance() < this.getMaxdistance())
                    {
                        this.setDistance(this.getDistance() + 1);
                    }

                    break;

                case 5:
                    if (this.getDistance() > 0)
                    {
                        this.setDistance(this.getDistance() - 1);
                    }
            }
        }
    }

    /**
     * Reads a tile entity from NBT.
     */
    public void a(NBTTagCompound var1)
    {
        super.a(var1);
        this.lengthx = var1.getInt("lengthx");
        this.lengthz = var1.getInt("lengthz");
        this.distance = var1.getInt("distance");
    }

    /**
     * Writes a tile entity to NBT.
     */
    public void b(NBTTagCompound var1)
    {
        super.b(var1);
        var1.setInt("lengthx", this.lengthx);
        var1.setInt("lengthz", this.lengthz);
        var1.setInt("distance", this.distance);
    }

    public int getMaxlengthx()
    {
        return this.maxlengthx;
    }

    public int getlengthx()
    {
        return this.lengthx;
    }

    public int getMaxlengthz()
    {
        return this.maxlengthz;
    }

    public int getlengthz()
    {
        return this.lengthz;
    }

    public int getDistance()
    {
        return this.distance;
    }

    public int getMaxdistance()
    {
        return this.maxdistance;
    }

    public void setDistance(int var1)
    {
        this.distance = var1;
        ++this.updateCount;
    }

    public void setDistanceinit(int var1)
    {
        this.distance = var1;
        ++this.updateCount;
    }

    public void setlengthx(int var1)
    {
        this.lengthx = var1;
        ++this.updateCount;
    }

    public void setlengthxinit(int var1)
    {
        this.lengthx = var1;
        ++this.updateCount;
    }

    public void setlengthz(int var1)
    {
        this.lengthz = var1;
        ++this.updateCount;
    }

    public void setlengthzinit(int var1)
    {
        this.lengthz = var1;
        ++this.updateCount;
    }

    public boolean wrenchCanSetFacing(EntityHuman var1, int var2)
    {
        if (this.getFacing() != var2 && !this.getActive())
        {
            this.setFacing((short)var2);
            this.world.notify(this.x, this.y, this.z);
            return true;
        }
        else
        {
            return false;
        }
    }

    public int estimateBlockCount()
    {
        return this.lengthx * this.lengthz;
    }

    public FFShape getFieldShape()
    {
        return new FFShapeDeflector(this);
    }

    /**
     * When some containers are closed they call this on each slot, then drop whatever it returns as an EntityItem -
     * like when you close a workbench GUI.
     */
    public ItemStack splitWithoutUpdate(int var1)
    {
        return null;
    }
}
