package immibis.ars.projectors;

import immibis.ars.mod_AdvancedRepulsionSystems;
import net.minecraft.server.ItemStack;
import net.minecraft.server.NBTTagCompound;

public class TileProjectorArea extends TileProjector
{
    private int radius = 4;
    private int maxradius;
    private short mode_designe;
    private short maxmode = 2;

    public TileProjectorArea()
    {
        this.maxradius = mod_AdvancedRepulsionSystems.maxSize;
        this.mode_designe = 1;
    }

    public void handleButton(int var1)
    {
        if (!this.getActive())
        {
            switch (var1)
            {
                case 0:
                    if (this.getRadius() < this.getMaxradius())
                    {
                        this.setRadius(this.getRadius() + 1);
                    }

                    break;

                case 1:
                    if (this.getRadius() > 4)
                    {
                        this.setRadius(this.getRadius() - 1);
                    }

                    break;

                case 2:
                    if (this.getmode_designe() < this.getMaxmode())
                    {
                        this.setmode_designe((short)(this.getmode_designe() + 1));
                    }

                    break;

                case 3:
                    if (this.getmode_designe() > 1)
                    {
                        this.setmode_designe((short)(this.getmode_designe() - 1));
                    }
            }
        }
    }

    /**
     * Reads a tile entity from NBT.
     */
    public void a(NBTTagCompound var1)
    {
        super.a(var1);
        this.radius = var1.getInt("radius");
        this.mode_designe = var1.getShort("mode_designe");
    }

    /**
     * Writes a tile entity to NBT.
     */
    public void b(NBTTagCompound var1)
    {
        super.b(var1);
        var1.setInt("radius", this.radius);
        var1.setShort("mode_designe", this.mode_designe);
    }

    protected boolean acceptsUpgradeType(int var1)
    {
        return super.acceptsUpgradeType(var1) || var1 == 9 || var1 == 1 || var1 == 2;
    }

    public int getMaxradius()
    {
        return this.maxradius;
    }

    public short getMaxmode()
    {
        return this.maxmode;
    }

    public int getRadius()
    {
        return this.radius;
    }

    public void setRadius(int var1)
    {
        this.radius = var1;
        ++this.updateCount;
    }

    public void setRadiusinit(int var1)
    {
        this.radius = var1;
        ++this.updateCount;
    }

    public short getmode_designe()
    {
        return this.mode_designe;
    }

    public void setmode_designe(short var1)
    {
        this.mode_designe = var1;
        ++this.updateCount;
    }

    public void setmode_designeinit(short var1)
    {
        this.mode_designe = var1;
        ++this.updateCount;
    }

    public void onActivateProjector()
    {
        if (this.isSubwater())
        {
            int var1;
            int var2;
            int var3;
            int var4;

            if (this.mode_designe == 1)
            {
                var1 = this.x - this.radius;
                var2 = this.x + this.radius;
                var3 = Math.max(0, this.isDome() ? this.y : this.y - this.radius);
                var4 = Math.min(255, this.y + this.radius);
                int var5 = this.z - this.radius;
                int var6 = this.z + this.radius;

                for (int var7 = var1; var7 <= var2; ++var7)
                {
                    for (int var8 = var5; var8 <= var6; ++var8)
                    {
                        for (int var9 = var3; var9 <= var4; ++var9)
                        {
                            if (this.world.getMaterial(var7, var9, var8).isLiquid())
                            {
                                this.world.setTypeId(var7, var9, var8, 0);
                            }
                        }
                    }
                }
            }
            else if (this.mode_designe == 2)
            {
                var1 = this.isDome() ? 0 : this.radius;

                for (var2 = 0 - var1; var2 <= this.radius; ++var2)
                {
                    for (var3 = 0 - this.radius; var3 <= this.radius; ++var3)
                    {
                        for (var4 = 0 - this.radius; var4 <= this.radius; ++var4)
                        {
                            double var10 = Math.sqrt((double)(var3 * var3 + var2 * var2 + var4 * var4));

                            if (var10 <= (double)(this.radius - 1) && this.world.getMaterial(this.x + var3, this.y + var2, this.z + var4).isLiquid())
                            {
                                this.world.setTypeId(this.x + var3, this.y + var2, this.z + var4, 0);
                            }
                        }
                    }
                }
            }
        }
    }

    protected FFShape getFieldShape()
    {
        return (FFShape)(this.mode_designe == 1 ? new FFShapeCube(this, this.radius) : new FFShapeSphere(this, this.radius));
    }

    /**
     * When some containers are closed they call this on each slot, then drop whatever it returns as an EntityItem -
     * like when you close a workbench GUI.
     */
    public ItemStack splitWithoutUpdate(int var1)
    {
        return null;
    }

    public int[] getUpdate()
    {
        return new int[] {this.radius, this.maxradius, this.mode_designe, this.maxmode, this.offsetX, this.offsetY, this.offsetZ};
    }

    public void handleUpdate(int[] var1)
    {
        this.radius = var1[0];
        this.maxradius = var1[1];
        this.mode_designe = (short)var1[2];
        this.maxmode = (short)var1[3];
        this.offsetX = var1[4];
        this.offsetY = var1[5];
        this.offsetZ = var1[6];
    }

    public int estimateBlockCount()
    {
        return this.radius * this.radius * (this.isDome() ? 12 : 24);
    }
}
