package immibis.ars.projectors;

import immibis.ars.CoordinateList;

public class FFShapeTube extends FFShape
{
    private final short facing;
    private int minx;
    private int miny;
    private int minz;
    private int maxx;
    private int maxy;
    private int maxz;

    public FFShapeTube(TileProjector var1, short var2, int var3, int var4, short var5)
    {
        super(var1);
        this.facing = var2;
        int var6 = var4;
        int var7 = var4;
        int var8 = var4;

        switch (var2)
        {
            case 0:
            case 1:
                var7 = var3;
                break;

            case 2:
            case 3:
                var8 = var3;
                break;

            case 4:
            case 5:
                var6 = var3;
                break;

            default:
                throw new RuntimeException("facing invalid direction " + var2);
        }

        this.minx = this.centX - var6;
        this.miny = this.centY - var7;
        this.minz = this.centZ - var8;
        this.maxx = this.centX + var6;
        this.maxy = this.centY + var7;
        this.maxz = this.centZ + var8;

        if (var5 == 2)
        {
            switch (var2)
            {
                case 0:
                    this.maxy = this.centY;
                    break;

                case 1:
                    this.miny = this.centY;
                    break;

                case 2:
                    this.maxz = this.centZ;
                    break;

                case 3:
                    this.minz = this.centZ;
                    break;

                case 4:
                    this.maxx = this.centX;
                    break;

                case 5:
                    this.minx = this.centX;
            }
        }

        if (this.dome)
        {
            this.miny = this.centY;
        }
    }

    public void getFieldBlocks(CoordinateList var1)
    {
        for (int var2 = this.minx; var2 <= this.maxx; ++var2)
        {
            for (int var3 = this.miny; var3 <= this.maxy; ++var3)
            {
                for (int var4 = this.minz; var4 <= this.maxz; ++var4)
                {
                    int var5 = this.getBlockMode(var2, var3, var4);

                    if (var5 == 1 || var5 == 2)
                    {
                        var1.add(var2, var3, var4, var5);
                    }
                }
            }
        }
    }

    public int getBlockMode(int var1, int var2, int var3)
    {
        return var1 >= this.minx && var1 <= this.maxx && var2 >= this.miny && var2 <= this.maxy && var3 >= this.minz && var3 <= this.maxz ? ((var1 == this.minx || var1 == this.maxx) && this.facing != 4 && this.facing != 5 ? 1 : ((var2 == this.miny && !this.dome || var2 == this.maxy) && this.facing != 0 && this.facing != 1 ? 1 : ((var3 == this.minz || var3 == this.maxz) && this.facing != 2 && this.facing != 3 ? 1 : 2))) : 0;
    }
}
