package immibis.ars.projectors;

import immibis.ars.CoordinateList;
import java.util.HashSet;
import java.util.Set;

public class FFShapeExtender extends FFShape
{
    private final short facing;
    private final short ausrichtungx;
    private final short ausrichtungy;
    private final short ausrichtungz;
    private final int wide;
    private final int length;
    private final int distance;
    private Set blocks = new HashSet();

    public FFShapeExtender(TileProjector var1, short var2, int var3, int var4, int var5, short var6, short var7, short var8)
    {
        super(var1);
        this.facing = var2;
        this.ausrichtungx = var6;
        this.ausrichtungy = var7;
        this.ausrichtungz = var8;
        this.wide = var3;
        this.length = var4;
        this.distance = var5;
    }

    public void getFieldBlocks(CoordinateList var1)
    {
        for (int var2 = 0; var2 <= this.wide; ++var2)
        {
            int var3 = this.ausrichtungx * var2;
            int var4 = this.ausrichtungy * var2;
            int var5 = this.ausrichtungz * var2;

            for (int var6 = 1; var6 <= this.length; ++var6)
            {
                switch (this.facing)
                {
                    case 0:
                        var4 = -var6 - this.distance;
                        break;

                    case 1:
                        var4 = var6 + this.distance;
                        break;

                    case 2:
                        var5 = -var6 - this.distance;
                        break;

                    case 3:
                        var5 = var6 + this.distance;
                        break;

                    case 4:
                        var3 = -var6 - this.distance;
                        break;

                    case 5:
                        var3 = var6 + this.distance;
                }

                var1.add(this.centX + var3, this.centY + var4, this.centZ + var5, 1);
                this.blocks.add(var3 + "/" + var4 + "/" + var5);
            }
        }
    }

    public int getBlockMode(int var1, int var2, int var3)
    {
        var1 -= this.centX;
        var2 -= this.centY;
        var3 -= this.centZ;
        return this.blocks.contains(var1 + "/" + var2 + "/" + var3) ? 1 : 0;
    }
}
