package immibis.ars.projectors;

import immibis.ars.CoordinateList;

public class FFShapeDirectional extends FFShape
{
    private final short facing;
    private final int distance;
    private final int length;

    public FFShapeDirectional(TileProjector var1, short var2, int var3, int var4)
    {
        super(var1);
        this.facing = var2;
        this.distance = var3;
        this.length = var4;
    }

    public void getFieldBlocks(CoordinateList var1)
    {
        for (int var2 = 0; var2 <= this.length; ++var2)
        {
            switch (this.facing)
            {
                case 0:
                    var1.add(this.centX, this.centY - this.distance - var2, this.centZ, 1);
                    break;

                case 1:
                    var1.add(this.centX, this.centY + this.distance + var2, this.centZ, 1);
                    break;

                case 2:
                    var1.add(this.centX, this.centY, this.centZ - this.distance - var2, 1);
                    break;

                case 3:
                    var1.add(this.centX, this.centY, this.centZ + this.distance + var2, 1);
                    break;

                case 4:
                    var1.add(this.centX - this.distance - var2, this.centY, this.centZ, 1);
                    break;

                case 5:
                    var1.add(this.centX + this.distance + var2, this.centY, this.centZ, 1);
            }
        }
    }

    public int getBlockMode(int var1, int var2, int var3)
    {
        int var4;

        switch (this.facing)
        {
            case 0:
                if (var1 != this.centX || var3 != this.centZ)
                {
                    return 0;
                }

                var4 = this.centY - var2;
                break;

            case 1:
                if (var1 != this.centX || var3 != this.centZ)
                {
                    return 0;
                }

                var4 = var2 - this.centY;
                break;

            case 2:
                if (var2 != this.centY || var1 != this.centX)
                {
                    return 0;
                }

                var4 = this.centZ - var3;
                break;

            case 3:
                if (var2 != this.centY || var1 != this.centX)
                {
                    return 0;
                }

                var4 = var3 - this.centZ;
                break;

            case 4:
                if (var2 != this.centY || var3 != this.centZ)
                {
                    return 0;
                }

                var4 = this.centX - var1;
                break;

            case 5:
                if (var2 != this.centY || var3 != this.centZ)
                {
                    return 0;
                }

                var4 = var1 - this.centX;
                break;

            default:
                return 0;
        }

        return var4 >= this.distance && var4 <= this.distance + this.length ? 1 : 0;
    }
}
