package immibis.ars.projectors;

import immibis.ars.CoordinateList;

public class FFShapeDeflector extends FFShape
{
    public int lengthx;
    public int lengthz;
    public int distance;
    public int facing;

    public FFShapeDeflector(TileProjectorDeflector var1)
    {
        super(var1);
        this.lengthx = var1.getlengthx();
        this.lengthz = var1.getlengthz();
        this.distance = var1.getDistance();
        this.facing = var1.getFacing();
    }

    public void getFieldBlocks(CoordinateList var1)
    {
        int var2 = 0;
        int var3 = 0;
        int var4 = 0;

        for (int var5 = -this.lengthx; var5 <= this.lengthx; ++var5)
        {
            for (int var6 = -this.lengthz; var6 <= this.lengthz; ++var6)
            {
                if (this.facing == 0)
                {
                    var3 = 0 - this.distance - 1;
                    var2 = var5;
                    var4 = var6;
                }

                if (this.facing == 1)
                {
                    var3 = 0 + this.distance + 1;
                    var2 = var5;
                    var4 = var6;
                }

                if (this.facing == 2)
                {
                    var4 = 0 - this.distance - 1;
                    var3 = var5;
                    var2 = var6;
                }

                if (this.facing == 3)
                {
                    var4 = 0 + this.distance + 1;
                    var3 = var5;
                    var2 = var6;
                }

                if (this.facing == 4)
                {
                    var2 = 0 - this.distance - 1;
                    var3 = var5;
                    var4 = var6;
                }

                if (this.facing == 5)
                {
                    var2 = 0 + this.distance + 1;
                    var3 = var5;
                    var4 = var6;
                }

                var1.add(this.centX + var2, this.centY + var3, this.centZ + var4, 1);
            }
        }
    }

    public int getBlockMode(int var1, int var2, int var3)
    {
        var1 -= this.centX;
        var2 -= this.centY;
        var3 -= this.centZ;

        switch (this.facing)
        {
            case 0:
                if (var2 != -this.distance - 1)
                {
                    return 0;
                }

                break;

            case 1:
                if (var2 != this.distance + 1)
                {
                    return 0;
                }

                break;

            case 2:
                if (var3 != -this.distance - 1)
                {
                    return 0;
                }

                var3 = var1;
                var1 = var2;
                break;

            case 3:
                if (var3 != this.distance + 1)
                {
                    return 0;
                }

                var3 = var1;
                var1 = var2;
                break;

            case 4:
                if (var1 != -this.distance - 1)
                {
                    return 0;
                }

                var1 = var2;
                break;

            case 5:
                if (var1 != this.distance + 1)
                {
                    return 0;
                }

                var1 = var2;
        }

        return var1 >= -this.lengthx && var1 <= this.lengthx && var3 >= -this.lengthz && var3 <= this.lengthz ? 1 : 0;
    }
}
