package immibis.ars;

import ic2.api.ExplosionWhitelist;
import ic2.api.Items;
import immibis.ars.packet.PacketGenericUpdate;
import immibis.ars.projectors.TileProjector;
import immibis.ars.projectors.TileProjectorArea;
import immibis.ars.projectors.TileProjectorDeflector;
import immibis.ars.projectors.TileProjectorDirectional;
import immibis.ars.projectors.TileProjectorExtender;
import immibis.ars.projectors.TileProjectorReactor;
import immibis.ars.projectors.TileProjectorTube;
import immibis.core.ModInfoReader;
import immibis.core.api.porting.PortableBaseMod;
import immibis.core.api.porting.PortableGuiHandler;
import immibis.core.api.porting.SidedProxy;
import immibis.core.net.IPacket;
import immibis.core.net.IPacketMap;
import immibis.core.net.OneTwoFiveNetworking;

import java.io.File;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

import javax.crypto.NoSuchPaddingException;

import cpw.mods.fml.common.FMLCommonHandler;
//import org.lwjgl.input.Keyboard;
//import net.minecraft.client.Minecraft;
import net.minecraft.server.*;
import forge.*;

public class mod_AdvancedRepulsionSystems extends PortableBaseMod {


	public static Configuration config;
	
	public static Block MFFSMaschines;
	public static Block MFFSUpgrades;
	public static Block MFFSFieldblock;
	
	public static Item MFFSitemMFDReaktorlink;
	public static Item MFFSitemMFDwrench;
	public static Item MFFSitemMFDidtool;
	public static Item MFFSitemMFDoffset;
	public static Item MFFSitemMFDdebugger;
	public static Item MFFSitemcardempty;
	public static Item MFFSitemfc;
	public static Item MFFSitemidc;
	public static Item MFFSitemsclc;
	
	public static final int GUI_ID_GENERATOR = 1;
	public static final int GUI_AREA_PROJECTOR = 2;
	public static final int GUI_DIRECTIONAL_PROJECTOR = 3;
	public static final int GUI_DEFLECTOR_PROJECTOR = 4;
	public static final int GUI_DIRECTIONAL_UPGRADE = 5;
	public static final int GUI_TUBE_PROJECTOR = 6;
	public static final int GUI_CAMOFLAGE_UPGRADE = 7;
	public static final int GUI_REACTOR_FIELD = 8;
	public static final int GUI_REACTOR_COOLER = 9;
	public static final int GUI_REACTOR_MONITOR = 10;
	public static final int GUI_REACTOR_MONITOR_CLIENT = 11;
	public static final int GUI_REACTOR_MONITOR_REMOTE = 12;

	public static final String CHANNEL = "MFFS-immiSMP";

	public static final byte PKT_GENERIC_UPDATE = 0;
	public static final byte PKT_PROJECTOR_DESCRIPTION = 1;

	public static final boolean DEBUG_MODE = Block.class.getName().equals("net.minecraft.server.Block");
	
	public static int forcefieldblockcost;
	public static int forcefieldblockcreatemodifier;
	public static int forcefieldblockzappermodifier;
	
	public static int reaktorheatcontrolice;
	public static int reaktorheatcontrolwater;
	public static int reaktorheatcontrollava;
	
	@Override
	public String getPriorities() {
		return "after:mod_IC2;after:mod_ImmibisCore";
	}

	public static StringBuffer hasher = new StringBuffer();
	public static Map<Integer, int[]> idtotextur = new HashMap<Integer, int[]>();
	
	public static mod_AdvancedRepulsionSystems instance;

	public static int maxCamoBlockId;
	
	public static boolean slowRefresh;
	public static int maxSize, maxDeflectorDistance, maxTubeRadius;
	public static int refreshSpeed;

	public mod_AdvancedRepulsionSystems() {
		instance = this;
	}
	
	@Override
	public void load() {
		try {
			config = new Configuration(new File(Functions.getMinecraftDir(), "/config/ModularForceFieldSystem.cfg"));
			config.load();
		} catch (Exception exception) {
			config = null;
			System.err.print(exception.toString());
		}
		
		BlockForceField.model = SidedProxy.instance.getUniqueBlockModelID("immibis.ars.BlockRenderer", true);
		
		Property oldNamesProp = config.getOrCreateBooleanProperty("useOldNames", Configuration.CATEGORY_GENERAL, false);
		oldNamesProp.comment = "If true, this will use the old names from Thunderdark's version.";
		boolean oldNames = Boolean.valueOf(oldNamesProp.value);
		
		/*Property slowRefreshProp = config.getOrCreateBooleanProperty("slowRefresh", Configuration.CATEGORY_GENERAL, false);
		slowRefreshProp.comment = "If true, forcefields will refresh every second. If false every tick (as before).";		
		slowRefresh = Boolean.valueOf(slowRefreshProp.value);*/
		slowRefresh = false;

		reaktorheatcontrolice = Functions.getBlockIdFor("reaktorheatcontrolice", 100);
		reaktorheatcontrolwater = Functions.getBlockIdFor("reaktorheatcontrolwater", 50);
		reaktorheatcontrollava = Functions.getBlockIdFor("reaktorheatcontrollava", 100);
		
		forcefieldblockcost = Functions.getBlockIdFor("forcefieldblockcost", 1);
		forcefieldblockcreatemodifier = Functions.getBlockIdFor("forcefieldblockcreatemodifier", 10);
		forcefieldblockzappermodifier = Functions.getBlockIdFor("forcefieldblockzappermodifier", 2);
		maxSize = Integer.parseInt(config.getOrCreateIntProperty("maxProjectorSize", Configuration.CATEGORY_GENERAL, 32).value);
		maxDeflectorDistance = Integer.parseInt(config.getOrCreateIntProperty("maxDeflectorDistance", Configuration.CATEGORY_GENERAL, 10).value);
		maxTubeRadius = Integer.parseInt(config.getOrCreateIntProperty("maxTubeRadius", Configuration.CATEGORY_GENERAL, 5).value);
		refreshSpeed = Integer.parseInt(config.getOrCreateIntProperty("refreshSpeed", Configuration.CATEGORY_GENERAL, 100).value);
		int maxOffset = Integer.parseInt(config.getOrCreateIntProperty("maxOffset", Configuration.CATEGORY_GENERAL, 48).value);
		int cooldownBlocksPerTick = Integer.parseInt(config.getOrCreateIntProperty("cooldownBlocksPerTick", Configuration.CATEGORY_GENERAL, 40).value);
		
		TileProjector.maxOffset = maxOffset;
		TileProjector.cooldownBlocksPerTick = cooldownBlocksPerTick;

		MFFSFieldblock = new BlockForceField(Functions.getBlockIdFor("HFFPFieldblock", 255));
		MFFSMaschines = new BlockMachine(Functions.getBlockIdFor("HFFPMaschines", 253));
		MFFSUpgrades = new BlockUpgrades(Functions.getBlockIdFor("HFFSUpgrades", 254));

		MFFSitemMFDReaktorlink = new ItemMFD_Reaktorlink(Functions.getItemIdFor("itemMFDReaktorlink", 11110)).a("itemMFDReaktorlink");
		MFFSitemMFDdebugger = new ItemMFD_debuger(Functions.getItemIdFor("itemMFDdebugger", 11111)).a("itemMFDdebugger");
		MFFSitemMFDidtool = new ItemMFD_IDwriter(Functions.getItemIdFor("itemMFDidtool", 11112)).a("itemMFDidtool");
		MFFSitemMFDwrench = new ItemMFD_wrench(Functions.getItemIdFor("itemMFDwrench", 11114)).a("itemMFDwrench");
		MFFSitemcardempty = new ItemCardempty(Functions.getItemIdFor("itemcardempty", 11115)).a("itemcardempty");
		MFFSitemfc = new ItemFrequenzCard(Functions.getItemIdFor("itemfc", 11116)).a("itemfc");
		MFFSitemidc = new ItemIDCard(Functions.getItemIdFor("itemidc", 11117)).a("itemidc");
		MFFSitemsclc = new ItemSecLinkCard(Functions.getItemIdFor("itemsclc", 11118)).a("itemsclc");
		MFFSitemMFDoffset = new ItemMFD_offset(Functions.getItemIdFor("itemMFDoffset", 11119)).a("itemMFDoffset");
		
		BukkitInterface.load();
    	
	    if (config != null) {
			config.save();
		}
		
		ModLoader.registerBlock(MFFSMaschines, ItemMachines.class);
		ModLoader.registerBlock(MFFSUpgrades, ItemUpgrades.class);
		ModLoader.registerBlock(MFFSFieldblock);

		ModLoader.registerTileEntity(TileEntityMaschines.class, "Maschines_Multi");
		ModLoader.registerTileEntity(TileEntityGeneratorCore.class, "Generator_Core");
		ModLoader.registerTileEntity(TileProjectorArea.class, "Area_Projektor");
		ModLoader.registerTileEntity(TileUpgradePassive.class, "Generator_Upgrade");
		ModLoader.registerTileEntity(TileEntityGeneratorEUInjector.class, "Generator_EU_Injektor");
		ModLoader.registerTileEntity(TileProjectorDirectional.class, "Directional_Projektor");
		ModLoader.registerTileEntity(TileProjectorDeflector.class, "Deflector_Projektor");
		ModLoader.registerTileEntity(TileProjectorExtender.class, "Directional_Extender");
		ModLoader.registerTileEntity(TileProjectorTube.class, "Tube_Projektor");
		ModLoader.registerTileEntity(TileUpgradeCamouflage.class, "Projektor_camouflage");
		ModLoader.registerTileEntity(TileProjectorReactor.class, "Reaktor_Field");
		ModLoader.registerTileEntity(TileEntityReaktorConnector.class, "Reactor_Connector");
		ModLoader.registerTileEntity(TileEntityReaktorCooler.class, "Reaktor_Cooler");
		ModLoader.registerTileEntity(TileEntityReaktorMonitor.class, "Reaktor_Monitor");
		ModLoader.registerTileEntity(TileEntityReaktorMonitorClient.class, "Reaktor_Monitor_Client");
		ModLoader.registerTileEntity(TileCamouflagedField.class, "MFFS camo");
		
		ModLoader.addName(MFFSitemMFDidtool, "MFDevice <ID-Tool>");
		ModLoader.addName(MFFSitemMFDwrench, "MFDevice <Wrench>");
		ModLoader.addName(MFFSitemcardempty, oldNames ? "MFFS Card blank " : "Blank MFFS card");
		ModLoader.addName(MFFSitemfc, oldNames ? "MFFS Frequency Card" : "MFFS frequency card");
		ModLoader.addName(MFFSitemidc, oldNames ? "MFFS ID Card" : "MFFS ID card");
		ModLoader.addName(MFFSitemMFDdebugger, "MFDevice <Debugger>");
		ModLoader.addName(MFFSitemsclc, oldNames ? "MFFS  Link Card" : "MFFS link card");
		ModLoader.addName(MFFSitemMFDReaktorlink, oldNames ? "MFFS Remote Reaktor Link" : "MFFS remote reactor link");
		ModLoader.addName(MFFSitemMFDoffset, "MFDevice <Offset>");

		ModLoader.addLocalization("Tube_Projektor.name", oldNames ? "MFFS Tube Projector" : "Tube forcefield projector");
		ModLoader.addLocalization("Directional_Extender.name", "MFFS directional extender");
		ModLoader.addLocalization("Deflector_Projektor.name", "MFFS deflector");
		ModLoader.addLocalization("Generator_Core.name", oldNames ? "MFFS generator core" : "Forcefield core");
		ModLoader.addLocalization("Area_Projektor.name", oldNames ? "MFFS Area Projector" : "Area forcefield projector");
		ModLoader.addLocalization("Generator_Storage.name", oldNames ? "MFFS generator storage upgrade" : "Forcefield core storage upgrade");
		ModLoader.addLocalization("Generator_Linkex.name", oldNames ? "MFFS generator range upgrade" : "Forcefield core range upgrade");
		ModLoader.addLocalization("Generator_EU_Injektor.name", oldNames ? "MFFS generator EU-injector" : "Forcefield EU injector");
		ModLoader.addLocalization("Directional_Projektor.name", oldNames ? "MFFS directional projektor" : "Directional forcefield projector");
		ModLoader.addLocalization("Projektor_Subwater.name", oldNames ? "MFFS Projector underwater upgrade" : "Forcefield underwater upgrade");
		ModLoader.addLocalization("Projektor_Dome.name", oldNames ? "MFFS Projector dome upgrade" : "Forcefield dome upgrade");
		ModLoader.addLocalization("Projektor_Hardner.name", oldNames ? "MFFS Projector block cutter upgrade" : "Forcefield block cutter upgrade");
		ModLoader.addLocalization("Projektor_Zapper.name", oldNames ? "MFFS Projector ZAPPER upgrade" : "Forcefield zapper upgrade");
		ModLoader.addLocalization("Projektor_camouflage.name", oldNames ? "MFFS Projector camouflage upgrade" : "Forcefield camouflage upgrade");
		ModLoader.addLocalization("Reaktor_Field.name", oldNames ? "MFFS nuclear reactor containment " : "Reactor containment field projector");
		ModLoader.addLocalization("Reactor_Connector.name", "MFFS reactor connector");
		ModLoader.addLocalization("Reaktor_Cooler.name", "MFFS reactor heat control");
		ModLoader.addLocalization("Reaktor_Monitor.name", "MFFS reactor heat monitor server");
		ModLoader.addLocalization("Reaktor_Monitor_Client.name", "MFFS reactor heat monitor client");
		ModLoader.addLocalization("MFFS_Inhibitor.name", "Forcefield inhibitor upgrade");
		
		SidedProxy.instance.preloadTexture("/mffs_grafik/upgrades.png");
		SidedProxy.instance.preloadTexture("/mffs_grafik/machines.png");
		SidedProxy.instance.preloadTexture("/mffs_grafik/blocks.png");
		SidedProxy.instance.preloadTexture("/mffs_grafik/items.png");
		
		addCamoBlock(Block.STONE, 0);
		addCamoBlock(Block.GRASS, 0);
		addCamoBlock(Block.DIRT, 0);
		addCamoBlock(Block.COBBLESTONE, 0);
		addCamoBlock(Block.WOOD, 0);
		addCamoBlock(Block.WOOD, 1);
		addCamoBlock(Block.WOOD, 2);
		addCamoBlock(Block.WOOD, 3);
		addCamoBlock(Block.BEDROCK, 0);
		addCamoBlock(Block.SAND, 0);
		addCamoBlock(Block.GRAVEL, 0);
		addCamoBlock(Block.GOLD_ORE, 0);
		addCamoBlock(Block.IRON_ORE, 0);
		addCamoBlock(Block.COAL_ORE, 0);
		addCamoBlock(Block.LOG, 0);
		addCamoBlock(Block.LOG, 1);
		addCamoBlock(Block.LOG, 2);
		addCamoBlock(Block.LOG, 3);
		addCamoBlock(Block.LEAVES, 0);
		addCamoBlock(Block.LEAVES, 1);
		addCamoBlock(Block.LEAVES, 2);
		addCamoBlock(Block.LEAVES, 3);
		addCamoBlock(Block.SPONGE, 0);
		addCamoBlock(Block.GLASS, 0);
		addCamoBlock(Block.LAPIS_ORE, 0);
		addCamoBlock(Block.LAPIS_BLOCK, 0);
		addCamoBlock(Block.SANDSTONE, 0);
		addCamoBlock(Block.SANDSTONE, 1);
		addCamoBlock(Block.SANDSTONE, 2);
		addCamoBlock(Block.NOTE_BLOCK, 0);
		for(int k = 0; k < 16; k++)
			addCamoBlock(Block.WOOL, k);
		addCamoBlock(Block.GOLD_BLOCK, 0);
		addCamoBlock(Block.IRON_BLOCK, 0);
		addCamoBlock(Block.BRICK, 0);
		addCamoBlock(Block.TNT, 0);
		addCamoBlock(Block.BOOKSHELF, 0);
		addCamoBlock(Block.MOSSY_COBBLESTONE, 0);
		addCamoBlock(Block.OBSIDIAN, 0);
		addCamoBlock(Block.DIAMOND_ORE, 0);
		addCamoBlock(Block.DIAMOND_BLOCK, 0);
		addCamoBlock(Block.WORKBENCH, 0);
		addCamoBlock(Block.REDSTONE_ORE, 0);
		addCamoBlock(Block.ICE, 0);
		addCamoBlock(Block.SNOW_BLOCK, 0);
		addCamoBlock(Block.CLAY, 0);
		addCamoBlock(Block.JUKEBOX, 0);
		addCamoBlock(Block.NETHERRACK, 0);
		addCamoBlock(Block.SOUL_SAND, 0);
		addCamoBlock(Block.GLOWSTONE, 0);
		addCamoBlock(Block.SMOOTH_BRICK, 0);
		addCamoBlock(Block.SMOOTH_BRICK, 1);
		addCamoBlock(Block.SMOOTH_BRICK, 2);
		for(int k = 0; k < 11; k++) {
			addCamoBlock(Block.BROWN_MUSHROOM, k);
			addCamoBlock(Block.RED_MUSHROOM, k);
		}
		addCamoBlock(Block.MELON, 0);
		addCamoBlock(Block.MYCEL, 0);
		addCamoBlock(Block.NETHER_BRICK, 0);
		addCamoBlock(Block.WHITESTONE, 0);
		addCamoBlock(Block.WHITESTONE, 1);
		addCamoBlock(Block.REDSTONE_LAMP_OFF, 0);
		
		maxCamoBlockId = Block.REDSTONE_LAMP_OFF.id;
		
		enableClockTicks(true);
		SidedProxy.instance.setGuiHandler(this, new PortableGuiHandler() {
			
			@Override
			public Object getServerGuiElement(int ID, EntityHuman player, World world, int x, int y, int z) {
				TileEntity te = world.getTileEntity(x, y, z);
				if(te == null)
					return null;
				int meta = te.world.getData(te.x, te.y, te.z);
				int blockid = te.world.getTypeId(te.x, te.y, te.z);
				if ((meta == 4 || meta == 5) && blockid == MFFSUpgrades.id) {
					// TODO WTF?
					ID = GUI_ID_GENERATOR;
				}
				
				switch(ID) {
				case GUI_ID_GENERATOR:
					return new ContainerGenerator(player, te == null ? new TileEntityGeneratorCore() : ((TileEntityGeneratorCore) te));
				case GUI_AREA_PROJECTOR:
					return new ContainerProjektor(player, te == null ? new TileProjectorArea() : ((TileProjectorArea) te));
				case GUI_DIRECTIONAL_PROJECTOR:
					return new ContainerProjektor(player, te == null ? new TileProjectorDirectional() : ((TileProjectorDirectional) te));
				case GUI_DEFLECTOR_PROJECTOR:
					return new ContainerProjektor(player, te == null ? new TileProjectorDeflector() : ((TileProjectorDeflector) te));
				case GUI_DIRECTIONAL_UPGRADE:
					return new ContainerProjektor(player, te == null ? new TileProjectorExtender() : ((TileProjectorExtender) te));
				case GUI_TUBE_PROJECTOR:
					return new ContainerProjektor(player, te == null ? new TileProjectorTube() : ((TileProjectorTube) te));
				case GUI_CAMOFLAGE_UPGRADE:
					return new ContainerCamoflage(player, te == null ? new TileUpgradeCamouflage() : ((TileUpgradeCamouflage) te));
				case GUI_REACTOR_FIELD:
					return new ContainerProjektor(player, te == null ? new TileProjectorReactor() : ((TileProjectorReactor) te));
				case GUI_REACTOR_COOLER:
					return new ContainerReactorCooler(player, te == null ? new TileEntityReaktorCooler() : ((TileEntityReaktorCooler) te));
				case GUI_REACTOR_MONITOR:
					return new ContainerReaktorMonitor(player, te == null ? new TileEntityReaktorMonitor() : ((TileEntityReaktorMonitor) te));
				case GUI_REACTOR_MONITOR_CLIENT:
					return new ContainerReaktorMonitorClient(player, te == null ? new TileEntityReaktorMonitorClient() : ((TileEntityReaktorMonitorClient) te));
				}
				return null;
			}
			
			/* $if jclient$
			@Override
			public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
				TileEntity te = world.getBlockTileEntity(x, y, z);
				if(te == null)
					return null;
				int meta = te.worldObj.getBlockMetadata(te.xCoord, te.yCoord, te.zCoord);
				int blockid = te.worldObj.getBlockId(te.xCoord, te.yCoord, te.zCoord);
				if ((meta == 4 || meta == 5) && blockid == MFFSUpgrades.blockID) {
					// TODO WTF?
					ID = GUI_ID_GENERATOR;
				}
				
				switch(ID) {
				case GUI_ID_GENERATOR:
					return new GuiGenerator(player, te == null ? new TileEntityGeneratorCore() : ((TileEntityGeneratorCore) te));
				case GUI_AREA_PROJECTOR:
					return new GuiProjektorArea(player, te == null ? new TileProjectorArea() : ((TileProjectorArea) te));
				case GUI_DIRECTIONAL_PROJECTOR:
					return new GuiProjektorDirectional(player, te == null ? new TileProjectorDirectional() : ((TileProjectorDirectional) te));
				case GUI_DEFLECTOR_PROJECTOR:
					return new GuiDeflectorDirectional(player, te == null ? new TileProjectorDeflector() : ((TileProjectorDeflector) te));
				case GUI_DIRECTIONAL_UPGRADE:
					return new GuiDirectionalUpgrade(player, te == null ? new TileProjectorExtender() : ((TileProjectorExtender) te));
				case GUI_TUBE_PROJECTOR:
					return new GuiProjTube(player, te == null ? new TileProjectorTube() : ((TileProjectorTube) te));
				case GUI_CAMOFLAGE_UPGRADE:
					return new GuiCamouflageUpgrade(player, te == null ? new TileUpgradeCamouflage() : ((TileUpgradeCamouflage) te));
				case GUI_REACTOR_FIELD:
					return new GuiReaktorField(player, te == null ? new TileProjectorReactor() : ((TileProjectorReactor) te));
				case GUI_REACTOR_COOLER:
					return new GuiReaktorCooler(player, te == null ? new TileEntityReaktorCooler() : ((TileEntityReaktorCooler) te));
				case GUI_REACTOR_MONITOR:
					return new GuiReaktorMonitor(player, te == null ? new TileEntityReaktorMonitor() : ((TileEntityReaktorMonitor) te));
				case GUI_REACTOR_MONITOR_CLIENT:
					return new GuiReaktorMonitorClient(player, te == null ? new TileEntityReaktorMonitorClient() : ((TileEntityReaktorMonitorClient) te));
				}
				return null;
			}
			$endif$ */
		});
		
		OneTwoFiveNetworking.initReceiveClient(new PacketMap(), CHANNEL);
	}
	
	@Override
	public boolean onTickInGame() {
		FFWorld.tickAll();
		return true;
	}
	
	private void addCamoBlock(Block block, int meta)
	{
		int[] t = new int[6];
		idtotextur.put(block.id + meta*1000, t);
	}
	
	@Override
    public void modsLoaded()
    {
    	ExplosionWhitelist.addWhitelistedBlock(MFFSFieldblock);
    	ExplosionWhitelist.addWhitelistedBlock(MFFSUpgrades);
    	ExplosionWhitelist.addWhitelistedBlock(MFFSMaschines);
    	
    	if(Items.getItem("advancedAlloy") != null) {
	    	// No recipes if IC2 isn't loaded
	    	
			ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, 5), new Object[] { " B ", "ACA", " A ", Character.valueOf('A'), Items.getItem("advancedAlloy"), Character.valueOf('B'), Item.DIAMOND, Character.valueOf('D'), Items.getItem("frequencyTransmitter") });
			ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, 4), new Object[] { "ABA", "BCB", "DED", Character.valueOf('A'), Items.getItem("advancedAlloy"), Character.valueOf('B'), Item.DIAMOND, Character.valueOf('D'), Items.getItem("electronicCircuit"), Character.valueOf('C'), Items.getItem("frequencyTransmitter"), Character.valueOf('E'), Items.getItem("electrolyzedWaterCell") });
			ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, 1), new Object[] { "BBB", "BCB", "DED", Character.valueOf('A'), Items.getItem("advancedAlloy"), Character.valueOf('B'), Item.DIAMOND, Character.valueOf('D'), Items.getItem("electronicCircuit"), Character.valueOf('C'), Items.getItem("frequencyTransmitter"), Character.valueOf('E'), Items.getItem("electrolyzedWaterCell") });
			ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, 3), new Object[] { "BAB", "ACA", "DED", Character.valueOf('A'), Items.getItem("advancedAlloy"), Character.valueOf('B'), Item.DIAMOND, Character.valueOf('D'), Items.getItem("electronicCircuit"), Character.valueOf('C'), Items.getItem("frequencyTransmitter"), Character.valueOf('E'), Items.getItem("electrolyzedWaterCell") });
			ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, 2), new Object[] { "ABA", "ACA", "DED", Character.valueOf('A'), Items.getItem("advancedAlloy"), Character.valueOf('B'), Item.DIAMOND, Character.valueOf('D'), Items.getItem("electronicCircuit"), Character.valueOf('C'), Items.getItem("frequencyTransmitter"), Character.valueOf('E'), Items.getItem("electrolyzedWaterCell") });
			//ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, 6), new Object[] { "ABA", "CDC", "ABA", Character.valueOf('A'), Items.getItem("refinedIronIngot"), Character.valueOf('B'), Items.getItem("insulatedCopperCableItem"), Character.valueOf('C'), Items.getItem("electrolyzedWaterCell"), Character.valueOf('D'), Items.getItem("batBox") }); // EU injector recipe disabled
			ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, 0), new Object[] { "ABA", "CDC", "AEA", Character.valueOf('A'), Items.getItem("electrolyzedWaterCell"), Character.valueOf('B'), Items.getItem("advancedAlloy"), Character.valueOf('C'), Items.getItem("electronicCircuit"), Character.valueOf('D'), Items.getItem("frequencyTransmitter"), Character.valueOf('E'), Items.getItem("electrolyzer") });
			ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, 4), new Object[] { " A ", "ABA", " A ", Character.valueOf('A'), Items.getItem("advancedAlloy"), Character.valueOf('B'), Items.getItem("electrolyzedWaterCell") });
			ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, 2), new Object[] { " A ", "ABA", " A ", Character.valueOf('A'), Items.getItem("advancedAlloy"), Character.valueOf('B'), Items.getItem("electronicCircuit") });
			ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, 3), new Object[] { " A ", "ABA", " A ", Character.valueOf('A'), Items.getItem("advancedAlloy"), Character.valueOf('B'), Items.getItem("carbonPlate") });
			ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, 5), new Object[] { " A ", "ABA", " A ", Character.valueOf('A'), Items.getItem("advancedAlloy"), Character.valueOf('B'), Items.getItem("frequencyTransmitter") });
			ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, BlockUpgrades.META_INHIBITOR), new Object[] { " A ", "ABA", " A ", Character.valueOf('A'), Items.getItem("advancedAlloy"), Character.valueOf('B'), Items.getItem("machine") });
			ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, 1), new Object[] { " A ", "ABA", " A ", Character.valueOf('A'), Items.getItem("advancedAlloy"), Character.valueOf('B'), Item.BUCKET });
			ModLoader.addRecipe(new ItemStack(MFFSitemMFDwrench), new Object[] { "BCB", "DAD", "DDD", Character.valueOf('A'), Item.DIAMOND, Character.valueOf('B') ,Items.getItem("insulatedCopperCableItem")  , Character.valueOf('C') ,Item.REDSTONE , Character.valueOf('D') ,Items.getItem("refinedIronIngot")  });
			ModLoader.addRecipe(new ItemStack(MFFSitemcardempty), new Object[] { "AAA", "ABA", "AAA", Character.valueOf('A'), Item.PAPER, Character.valueOf('B'), Items.getItem("electronicCircuit") });
			ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, 6), new Object[] { " A ", "ABA", " A ", Character.valueOf('A'), Items.getItem("advancedAlloy"), Character.valueOf('B'), Items.getItem("teslaCoil") });
	        ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, 7), new Object[] { "BAB", "ACA", "BAB", Character.valueOf('A'), Items.getItem("advancedAlloy"), Character.valueOf('B'), Item.DIAMOND, Character.valueOf('C'), Items.getItem("frequencyTransmitter") });
			ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, 8), new Object[] { "ACA", "BDB", "ACA", Character.valueOf('A'), Items.getItem("advancedAlloy"), Character.valueOf('B'), Item.REDSTONE, Character.valueOf('C'), Items.getItem("trippleInsulatedIronCableItem"), Character.valueOf('D'), Items.getItem("frequencyTransmitter") });
	        ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, 7), new Object[] { "ADA", "BCB", "ABA", Character.valueOf('A'), Items.getItem("carbonPlate"), Character.valueOf('B'), Items.getItem("advancedAlloy"), Character.valueOf('C'), new ItemStack(MFFSMaschines, 1, 1), Character.valueOf('D'), Items.getItem("advancedCircuit") });    	
	        //ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, 8), new Object[] { "DCD", "CAC", "DBD", Character.valueOf('A'), Items.getItem("advancedMachine"),Character.valueOf('B'), Block.chest,Character.valueOf('C'), Items.getItem("integratedHeatDisperser") , Character.valueOf('D'), Items.getItem("advancedAlloy")});    
	        //ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, 9), new Object[] { "ECE", "DBD", "EAE", Character.valueOf('A'), Items.getItem("advancedMachine"),Character.valueOf('B'), Items.getItem("frequencyTransmitter") , Character.valueOf('C'), Items.getItem("detectorCableItem"), Character.valueOf('D'), Items.getItem("electronicCircuit"), Character.valueOf('E'), Items.getItem("refinedIronIngot")});
	        //ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, 0), new Object[] { "ECE", "DBD", "EAE", Character.valueOf('A'), Items.getItem("machine"),Character.valueOf('B'), Items.getItem("frequencyTransmitter") , Character.valueOf('C'), Item.redstone, Character.valueOf('D'), Items.getItem("electronicCircuit"), Character.valueOf('E'), Items.getItem("refinedIronIngot")});
	    	
	        //ModLoader.addRecipe(new ItemStack(MFFSitemMFDReaktorlink), new Object[] { "DCD", "BAB", "CBC", Character.valueOf('A'), Items.getItem("frequencyTransmitter"), Character.valueOf('B'), Items.getItem("electronicCircuit") , Character.valueOf('C'), Items.getItem("carbonPlate"), Character.valueOf('D'), Item.redstone});
	 
	        ModLoader.addShapelessRecipe(new ItemStack(MFFSitemMFDwrench), new Object[]{new ItemStack(MFFSitemMFDoffset)});
	        ModLoader.addShapelessRecipe(new ItemStack(MFFSitemMFDoffset), new Object[]{new ItemStack(MFFSitemMFDwrench)});
	        ModLoader.addShapelessRecipe(new ItemStack(MFFSitemMFDwrench), new Object[]{new ItemStack(MFFSitemMFDidtool)});
	        
	        ModLoader.addShapelessRecipe(new ItemStack(MFFSitemcardempty), new Object[] {MFFSitemfc});
	        ModLoader.addShapelessRecipe(new ItemStack(MFFSitemcardempty), new Object[] {MFFSitemidc});
	        ModLoader.addShapelessRecipe(new ItemStack(MFFSitemcardempty), new Object[] {MFFSitemsclc});
	    }
         
    }

	public String getVersion() {
		return ModInfoReader.getModInfoField("/immibis/ars/mod_AdvancedRepulsionSystems.info.txt", "version");
	}

	private static class PacketMap implements IPacketMap {
		@Override
		public IPacket createPacket(byte id) {
			if(id == PKT_GENERIC_UPDATE)
				return new PacketGenericUpdate();
			return null;
		}
	}

	public static World getClientWorld() {
		/* $if jclient$
		return SidedProxy.instance.getThePlayer().worldObj;
		$else$ */
		return null;
		/* $endif$ */
	}

}
