package immibis.ars;

import net.minecraft.server.EntityHuman;
import net.minecraft.server.IInventory;
import net.minecraft.server.ItemStack;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.NBTTagList;

public class TileUpgradeCamouflage extends TileUpgradePassive implements IInventory
{
    private ItemStack[] CamoflageItemStacks = new ItemStack[1];
    private int ItemID = -1;

    public int[] getUpdate()
    {
        return new int[] {this.ItemID};
    }

    public void handleUpdate(int[] var1)
    {
        this.ItemID = var1[0];
    }

    public void setItem_ID(int var1)
    {
        if (this.ItemID != var1)
        {
            ++this.updateCount;
        }

        this.ItemID = var1;
    }

    public int getItem_ID()
    {
        return this.ItemID;
    }

    /**
     * Allows the entity to update its state. Overridden in most subclasses, e.g. the mob spawner uses this to count
     * ticks and creates a new spawn inside its implementation.
     */
    public void q_()
    {
        if (!this.world.isStatic && this.getconectet_ID() != 0)
        {
            if (this.getItem(0) != null)
            {
                if (this.getItem(0).id <= mod_AdvancedRepulsionSystems.maxCamoBlockId)
                {
                    if (this.getItem(0).usesData())
                    {
                        this.setItem_ID(this.getItem(0).id + this.getItem(0).getData() * 1000);
                    }
                    else
                    {
                        this.setItem_ID(this.getItem(0).id);
                    }
                }
                else
                {
                    this.setItem_ID(-1);
                }
            }
            else
            {
                this.setItem_ID(-1);
            }
        }
    }

    /**
     * Reads a tile entity from NBT.
     */
    public void a(NBTTagCompound var1)
    {
        super.a(var1);
        this.ItemID = var1.getInt("ItemID");
        NBTTagList var2 = var1.getList("Items");
        this.CamoflageItemStacks = new ItemStack[this.getSize()];

        for (int var3 = 0; var3 < var2.size(); ++var3)
        {
            NBTTagCompound var4 = (NBTTagCompound)var2.get(var3);
            byte var5 = var4.getByte("Slot");

            if (var5 >= 0 && var5 < this.CamoflageItemStacks.length)
            {
                this.CamoflageItemStacks[var5] = ItemStack.a(var4);
            }
        }
    }

    /**
     * Writes a tile entity to NBT.
     */
    public void b(NBTTagCompound var1)
    {
        super.b(var1);
        var1.setInt("ItemID", this.ItemID);
        NBTTagList var2 = new NBTTagList();

        for (int var3 = 0; var3 < this.CamoflageItemStacks.length; ++var3)
        {
            if (this.CamoflageItemStacks[var3] != null)
            {
                NBTTagCompound var4 = new NBTTagCompound();
                var4.setByte("Slot", (byte)var3);
                this.CamoflageItemStacks[var3].save(var4);
                var2.add(var4);
            }
        }

        var1.set("Items", var2);
    }

    /**
     * Decrease the size of the stack in slot (first int arg) by the amount of the second int arg. Returns the new
     * stack.
     */
    public ItemStack splitStack(int var1, int var2)
    {
        if (this.CamoflageItemStacks[var1] != null)
        {
            ItemStack var3;

            if (this.CamoflageItemStacks[var1].count <= var2)
            {
                var3 = this.CamoflageItemStacks[var1];
                this.CamoflageItemStacks[var1] = null;
                return var3;
            }
            else
            {
                var3 = this.CamoflageItemStacks[var1].a(var2);

                if (this.CamoflageItemStacks[var1].count == 0)
                {
                    this.CamoflageItemStacks[var1] = null;
                }

                return var3;
            }
        }
        else
        {
            return null;
        }
    }

    /**
     * Sets the given item stack to the specified slot in the inventory (can be crafting or armor sections).
     */
    public void setItem(int var1, ItemStack var2)
    {
        this.CamoflageItemStacks[var1] = var2;

        if (var2 != null && var2.count > this.getMaxStackSize())
        {
            var2.count = this.getMaxStackSize();
        }
    }

    public boolean canInteractWith(EntityHuman var1)
    {
        return this.world.getTileEntity(this.x, this.y, this.z) != this ? false : var1.e((double)this.x + 0.5D, (double)this.y + 0.5D, (double)this.z + 0.5D) <= 64.0D;
    }

    /**
     * Returns the stack in slot i
     */
    public ItemStack getItem(int var1)
    {
        return this.CamoflageItemStacks[var1];
    }

    /**
     * Returns the name of the inventory.
     */
    public String getName()
    {
        return "Camoflageupgrade";
    }

    /**
     * Returns the maximum stack size for a inventory slot. Seems to always be 64, possibly will be extended. *Isn't
     * this more of a set than a get?*
     */
    public int getMaxStackSize()
    {
        return 1;
    }

    /**
     * Returns the number of slots in the inventory.
     */
    public int getSize()
    {
        return this.CamoflageItemStacks.length;
    }

    /**
     * Do not make give this method the name canInteractWith because it clashes with Container
     */
    public boolean a(EntityHuman var1)
    {
        return this.world.getTileEntity(this.x, this.y, this.z) != this ? false : var1.f((double)this.x + 0.5D, (double)this.y + 0.5D, (double)this.z + 0.5D) <= 64.0D;
    }

    public void f() {}

    public void g() {}

    /**
     * When some containers are closed they call this on each slot, then drop whatever it returns as an EntityItem -
     * like when you close a workbench GUI.
     */
    public ItemStack splitWithoutUpdate(int var1)
    {
        return null;
    }
}
