package immibis.ars;

import ic2.api.Items;
import ic2.common.TileEntityNuclearReactor;
import net.minecraft.server.Block;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.IInventory;
import net.minecraft.server.ItemStack;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.NBTTagList;
import net.minecraft.server.TileEntity;

public class TileEntityReaktorCooler extends TileUpgradePassive implements IInventory
{
    private boolean isreaktor;
    private ItemStack[] inventory = new ItemStack[9];
    private int reaktorx;
    private int reaktory;
    private int reaktorz;
    private int maxheat;
    private int heat;
    private int mode = 0;
    private int targetheat = 0;

    public int[] getUpdate()
    {
        return new int[] {this.maxheat, this.heat, this.mode, this.targetheat};
    }

    public void handleUpdate(int[] var1)
    {
        this.maxheat = var1[0];
        this.heat = var1[1];
        this.mode = var1[2];
        this.targetheat = var1[3];
    }

    public void handleButton(int var1)
    {
        switch (var1)
        {
            case 1:
                if (this.getTargetheat() <= this.getMaxheat())
                {
                    this.setTargetheat(this.getTargetheat() + 100);

                    if (this.getTargetheat() > this.getMaxheat())
                    {
                        this.setTargetheat(this.getMaxheat());
                    }
                }

                break;

            case 2:
                if (this.getTargetheat() >= 0)
                {
                    this.setTargetheat(this.getTargetheat() - 100);

                    if (this.getTargetheat() < 0)
                    {
                        this.setTargetheat(0);
                    }
                }

                break;

            case 3:
                this.setMode(0);
                break;

            case 4:
                this.setMode(1);
                break;

            case 5:
                this.setMode(2);
                break;

            case 6:
                this.setMode(3);
        }
    }

    public int getMode()
    {
        return this.mode;
    }

    public void setMode(int var1)
    {
        this.mode = var1;
        ++this.updateCount;
    }

    /**
     * Allows the entity to update its state. Overridden in most subclasses, e.g. the mob spawner uses this to count
     * ticks and creates a new spawn inside its implementation.
     */
    public void q_()
    {
        super.q_();

        if (!this.world.isStatic)
        {
            this.updatecheck();

            if (this.isIsreaktor())
            {
                TileEntity var1 = this.world.getTileEntity(this.reaktorx, this.reaktory, this.reaktorz);

                if (var1 == null)
                {
                    this.setIsreaktor(false);
                }

                if (var1 instanceof TileEntityNuclearReactor)
                {
                    this.heat = ((TileEntityNuclearReactor)var1).heat;
                    ++this.updateCount;

                    if (this.getMode() != 0 && this.getActive())
                    {
                        switch (this.getMode())
                        {
                            case 1:
                                if (this.getTargetheat() + 50 < this.heat)
                                {
                                    this.reactorcooler((TileEntityNuclearReactor)var1);
                                }

                                break;

                            case 2:
                                if (this.getTargetheat() - 50 > this.heat)
                                {
                                    this.reactorheater((TileEntityNuclearReactor)var1);
                                }

                                break;

                            case 3:
                                if (this.getTargetheat() + 100 < this.heat)
                                {
                                    this.reactorcooler((TileEntityNuclearReactor)var1);
                                }
                                else if (this.getTargetheat() - 100 > this.heat)
                                {
                                    this.reactorheater((TileEntityNuclearReactor)var1);
                                }
                        }
                    }
                }
            }
        }
    }

    private void reactorheater(TileEntityNuclearReactor var1)
    {
        for (int var2 = 0; var2 < this.inventory.length; ++var2)
        {
            if (this.getItem(var2) != null && this.getItem(var2).getItem() == Items.getItem("lavaCell").getItem())
            {
                if (this.getItem(var2).count == 1)
                {
                    this.inventory[var2] = null;
                }
                else
                {
                    --this.getItem(var2).count;
                }

                var1.heat += 100;
                break;
            }
        }
    }

    private void reactorcooler(TileEntityNuclearReactor var1)
    {
        for (int var2 = 0; var2 < this.inventory.length; ++var2)
        {
            if (this.getItem(var2) != null)
            {
                if (this.getItem(var2).getItem() == Items.getItem("waterCell").getItem())
                {
                    if (this.getItem(var2).count == 1)
                    {
                        this.inventory[var2] = null;
                    }
                    else
                    {
                        --this.getItem(var2).count;
                    }

                    var1.heat -= 50;

                    if (var1.heat < 0)
                    {
                        var1.heat = 0;
                    }

                    break;
                }

                if (this.getItem(var2).id == Block.ICE.id)
                {
                    if (this.getItem(var2).count == 1)
                    {
                        this.inventory[var2] = null;
                    }
                    else
                    {
                        --this.getItem(var2).count;
                    }

                    var1.heat -= 100;

                    if (var1.heat < 0)
                    {
                        var1.heat = 0;
                    }

                    break;
                }
            }
        }
    }

    /**
     * Reads a tile entity from NBT.
     */
    public void a(NBTTagCompound var1)
    {
        super.a(var1);
        this.targetheat = var1.getInt("targetheat");
        this.mode = var1.getInt("mode");
        NBTTagList var2 = var1.getList("Items");
        this.inventory = new ItemStack[this.getSize()];

        for (int var3 = 0; var3 < var2.size(); ++var3)
        {
            NBTTagCompound var4 = (NBTTagCompound)var2.get(var3);
            byte var5 = var4.getByte("Slot");

            if (var5 >= 0 && var5 < this.inventory.length)
            {
                this.inventory[var5] = ItemStack.a(var4);
            }
        }
    }

    /**
     * Writes a tile entity to NBT.
     */
    public void b(NBTTagCompound var1)
    {
        super.b(var1);
        var1.setInt("targetheat", this.targetheat);
        var1.setInt("mode", this.mode);
        NBTTagList var2 = new NBTTagList();

        for (int var3 = 0; var3 < this.inventory.length; ++var3)
        {
            if (this.inventory[var3] != null)
            {
                NBTTagCompound var4 = new NBTTagCompound();
                var4.setByte("Slot", (byte)var3);
                this.inventory[var3].save(var4);
                var2.add(var4);
            }
        }

        var1.set("Items", var2);
    }

    public int getTargetheat()
    {
        return this.targetheat;
    }

    public void setTargetheat(int var1)
    {
        this.targetheat = var1;
        ++this.updateCount;
    }

    public void setMaxheat(int var1)
    {
        this.maxheat = var1;
        ++this.updateCount;
    }

    public int getHeat()
    {
        return this.heat;
    }

    public void setHeat(int var1)
    {
        this.heat = var1;
        ++this.updateCount;
    }

    public boolean isIsreaktor()
    {
        return this.isreaktor;
    }

    public void setIsreaktor(boolean var1)
    {
        this.isreaktor = var1;
        ++this.updateCount;
    }

    public int getReaktorx()
    {
        return this.reaktorx;
    }

    public void setReaktorx(int var1)
    {
        this.reaktorx = var1;
    }

    public int getReaktory()
    {
        return this.reaktory;
    }

    public void setReaktory(int var1)
    {
        this.reaktory = var1;
    }

    public int getReaktorz()
    {
        return this.reaktorz;
    }

    public void setReaktorz(int var1)
    {
        this.reaktorz = var1;
    }

    public int getMaxheat()
    {
        return this.maxheat;
    }

    /**
     * Returns the number of slots in the inventory.
     */
    public int getSize()
    {
        return this.inventory.length;
    }

    /**
     * Decrease the size of the stack in slot (first int arg) by the amount of the second int arg. Returns the new
     * stack.
     */
    public ItemStack splitStack(int var1, int var2)
    {
        if (this.inventory[var1] != null)
        {
            ItemStack var3;

            if (this.inventory[var1].count <= var2)
            {
                var3 = this.inventory[var1];
                this.inventory[var1] = null;
                return var3;
            }
            else
            {
                var3 = this.inventory[var1].a(var2);

                if (this.inventory[var1].count == 0)
                {
                    this.inventory[var1] = null;
                }

                return var3;
            }
        }
        else
        {
            return null;
        }
    }

    /**
     * Sets the given item stack to the specified slot in the inventory (can be crafting or armor sections).
     */
    public void setItem(int var1, ItemStack var2)
    {
        this.inventory[var1] = var2;

        if (var2 != null && var2.count > this.getMaxStackSize())
        {
            var2.count = this.getMaxStackSize();
        }
    }

    /**
     * Returns the stack in slot i
     */
    public ItemStack getItem(int var1)
    {
        return this.inventory[var1];
    }

    /**
     * Returns the name of the inventory.
     */
    public String getName()
    {
        return "Reactor Cooler";
    }

    /**
     * Returns the maximum stack size for a inventory slot. Seems to always be 64, possibly will be extended. *Isn't
     * this more of a set than a get?*
     */
    public int getMaxStackSize()
    {
        return 64;
    }

    /**
     * Do not make give this method the name canInteractWith because it clashes with Container
     */
    public boolean a(EntityHuman var1)
    {
        return this.world.getTileEntity(this.x, this.y, this.z) != this ? false : var1.f((double)this.x + 0.5D, (double)this.y + 0.5D, (double)this.z + 0.5D) <= 64.0D;
    }

    public void f() {}

    public void g() {}

    /**
     * When some containers are closed they call this on each slot, then drop whatever it returns as an EntityItem -
     * like when you close a workbench GUI.
     */
    public ItemStack splitWithoutUpdate(int var1)
    {
        return null;
    }
}
