package immibis.ars;

import ic2.api.Direction;
import ic2.api.EnergyNet;
import ic2.api.IEnergyConductor;
import net.minecraft.server.ItemStack;
import net.minecraft.server.TileEntity;
import net.minecraft.server.World;

public class TileEntityReaktorConnector extends TileUpgradePassive implements IEnergyConductor
{
    private boolean addedToEnergyNet = false;
    private boolean redpowert = false;
    private short ticker = 0;

    /**
     * Allows the entity to update its state. Overridden in most subclasses, e.g. the mob spawner uses this to count
     * ticks and creates a new spawn inside its implementation.
     */
    public void q_()
    {
        if (!this.world.isStatic)
        {
            super.q_();
            this.updatecheck();

            if (!this.addedToEnergyNet)
            {
                EnergyNet.getForWorld(this.world).addTileEntity(this);
                this.addedToEnergyNet = true;
            }

            if (this.getTicker() == 10)
            {
                if (this.world.isBlockPowered(this.x, this.y, this.z))
                {
                    if (!this.redpowert)
                    {
                        this.redpowert = true;
                        this.world.k(this.x, this.y, this.y);
                        notifyNeighbors(this.world, this.x, this.y, this.z);
                    }
                }
                else if (this.redpowert)
                {
                    this.redpowert = false;
                    this.world.k(this.x, this.y, this.y);
                    notifyNeighbors(this.world, this.x, this.y, this.z);
                }

                this.setTicker((short)0);
            }

            this.setTicker((short)(this.getTicker() + 1));
        }
    }

    public static void notifyNeighbors(World var0, int var1, int var2, int var3)
    {
        var0.applyPhysics(var1, var2, var3, 0);
        var0.applyPhysics(var1 - 1, var2, var3, 0);
        var0.applyPhysics(var1 + 1, var2, var3, 0);
        var0.applyPhysics(var1, var2 - 1, var3, 0);
        var0.applyPhysics(var1, var2 + 1, var3, 0);
        var0.applyPhysics(var1, var2, var3 - 1, 0);
        var0.applyPhysics(var1, var2, var3 + 1, 0);
    }

    public boolean isredpowert()
    {
        return this.redpowert;
    }

    public short getTicker()
    {
        return this.ticker;
    }

    public void setTicker(short var1)
    {
        this.ticker = var1;
    }

    public boolean isAddedToEnergyNet()
    {
        return this.addedToEnergyNet;
    }

    /**
     * invalidates a tile entity
     */
    public void j()
    {
        if (!this.world.isStatic && this.addedToEnergyNet)
        {
            EnergyNet.getForWorld(this.world).removeTileEntity(this);
            this.addedToEnergyNet = false;
        }

        super.j();
    }

    public boolean acceptsEnergyFrom(TileEntity var1, Direction var2)
    {
        return true;
    }

    public boolean emitsEnergyTo(TileEntity var1, Direction var2)
    {
        return true;
    }

    public double getConductionLoss()
    {
        return 0.0D;
    }

    public int getInsulationEnergyAbsorption()
    {
        return 9001;
    }

    public int getInsulationBreakdownEnergy()
    {
        return 9001;
    }

    public int getConductorBreakdownEnergy()
    {
        return 0;
    }

    public void removeInsulation() {}

    public void removeConductor() {}
    
    @Override
    public ItemStack[] getContents() {return new ItemStack[0];}
}
