package immibis.ars;

import ic2.api.Direction;
import ic2.api.EnergyNet;
import ic2.api.IEnergySink;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.IInventory;
import net.minecraft.server.ItemStack;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.NBTTagList;
import net.minecraft.server.TileEntity;

public class TileEntityGeneratorCore extends TileEntityMaschines implements IInventory, IEnergySink
{
    public static int FP_PER_EU = 10;
    private ItemStack[] inventory = new ItemStack[1];
    private int forcepower = 0;
    private int maxforcepower = 10000000;
    private short transmitrange = 8;
    private int Generator_ID = 0;
    private boolean create = true;
    private short linketprojektor = 0;
    private byte delayupdate = 0;
    private boolean addedToEnergyNet = false;
    private int excessEU = 0;

    public void freqencoding()
    {
        if (!this.world.isStatic && this.getItem(0) != null && this.getItem(0).getItem() == mod_AdvancedRepulsionSystems.MFFSitemcardempty)
        {
            this.setItem(0, new ItemStack(mod_AdvancedRepulsionSystems.MFFSitemfc));
            Functions.getTAGfromItemstack(this.getItem(0)).setInt("Generator_ID", this.Generator_ID);
            this.update();
        }
    }

    public void setMaxforcepower(int var1)
    {
        this.maxforcepower = var1;
        ++this.updateCount;
    }

    public int getMaxforcepower()
    {
        return this.maxforcepower;
    }

    public Short getLinketprojektor()
    {
        return Short.valueOf(this.linketprojektor);
    }

    public void setLinketprojektor(Short var1)
    {
        this.linketprojektor = var1.shortValue();
        ++this.updateCount;
    }

    public void addtogrid()
    {
        boolean var10000 = this.world.isStatic;
    }

    public void removefromgrid()
    {
        if (!this.world.isStatic)
        {
            Linkgrid.getWorldMap(this.world).getGenerator().remove(Integer.valueOf(this.getGenerator_ID()));
        }
    }

    public int gaugeFuelScaled(int var1)
    {
        return var1 * this.getForcepower() / this.maxforcepower;
    }

    /**
     * Reads a tile entity from NBT.
     */
    public void a(NBTTagCompound var1)
    {
        super.a(var1);
        this.forcepower = var1.getInt("forcepower");
        this.maxforcepower = var1.getInt("maxforcepower");
        this.transmitrange = var1.getShort("transmitrange");
        this.Generator_ID = var1.getInt("Generator_ID");
        NBTTagList var2 = var1.getList("Items");
        this.inventory = new ItemStack[this.getSize()];

        for (int var3 = 0; var3 < var2.size(); ++var3)
        {
            NBTTagCompound var4 = (NBTTagCompound)var2.get(var3);
            byte var5 = var4.getByte("Slot");

            if (var5 >= 0 && var5 < this.inventory.length)
            {
                this.inventory[var5] = ItemStack.a(var4);
            }
        }
    }

    /**
     * Writes a tile entity to NBT.
     */
    public void b(NBTTagCompound var1)
    {
        super.b(var1);
        var1.setInt("forcepower", this.forcepower);
        var1.setInt("maxforcepower", this.maxforcepower);
        var1.setShort("transmitrange", this.transmitrange);
        var1.setInt("Generator_ID", this.Generator_ID);
        NBTTagList var2 = new NBTTagList();

        for (int var3 = 0; var3 < this.inventory.length; ++var3)
        {
            if (this.inventory[var3] != null)
            {
                NBTTagCompound var4 = new NBTTagCompound();
                var4.setByte("Slot", (byte)var3);
                this.inventory[var3].save(var4);
                var2.add(var4);
            }
        }

        var1.set("Items", var2);
    }

    public void CheckconInjektor()
    {
        TileEntity var1 = this.world.getTileEntity(this.x, this.y - 1, this.z);

        if (var1 instanceof TileEntityGeneratorInjector && ((TileEntityGeneratorInjector)var1).getRemGenerator_ID() == 0)
        {
            ((TileEntityGeneratorInjector)var1).setRemGenerator_ID(this.Generator_ID);
        }
    }

    public void Energylost(int var1)
    {
        if (this.getForcepower() >= 0)
        {
            this.setForcepower(this.getForcepower() - var1);
        }

        if (this.getForcepower() < 0)
        {
            this.setForcepower(0);
        }
    }

    public void CheckconUprades()
    {
        short var1 = 8;
        int var2 = 10000000;

        for (int var3 = -1; var3 <= 1; ++var3)
        {
            for (int var4 = -1; var4 <= 1; ++var4)
            {
                if (var3 != 0 || var4 != 0)
                {
                    TileEntity var5 = this.world.getTileEntity(this.x + var3, this.y, this.z + var4);

                    if (var5 instanceof TileUpgradePassive && var5 != null)
                    {
                        int var6 = this.world.getData(this.x + var3, this.y, this.z + var4);

                        if (((TileUpgradePassive)var5).getconectet_ID() == 0 && (var6 == 4 || var6 == 5))
                        {
                            ((TileUpgradePassive)var5).setconectet_ID(this.Generator_ID);
                            ((TileUpgradePassive)var5).setConnectet_typID((short)1);
                            this.world.k(var5.x, var5.y, var5.z);
                        }

                        if (((TileUpgradePassive)var5).getconectet_ID() == this.Generator_ID)
                        {
                            if (((TileUpgradePassive)var5).getActive() != this.getActive())
                            {
                                ((TileUpgradePassive)var5).setActive(this.getActive());
                            }

                            switch (var6)
                            {
                                case 4:
                                    var2 += 2000000;
                                    break;

                                case 5:
                                    var1 = (short)(var1 * 2);
                            }
                        }
                    }
                }
            }
        }

        if (this.getTransmitrange() != var1)
        {
            this.setTransmitrange(var1);
        }

        if (this.getMaxforcepower() != var2)
        {
            this.setMaxforcepower(var2);
        }

        if (this.getForcepower() > this.maxforcepower)
        {
            this.setForcepower(this.maxforcepower);
        }
    }

    /**
     * Allows the entity to update its state. Overridden in most subclasses, e.g. the mob spawner uses this to count
     * ticks and creates a new spawn inside its implementation.
     */
    public void q_()
    {
        if (!this.world.isStatic)
        {
            if (!this.addedToEnergyNet)
            {
                EnergyNet.getForWorld(this.world).addTileEntity(this);
                this.addedToEnergyNet = true;
            }

            if (this.excessEU > 0)
            {
                int var1 = (this.maxforcepower - this.forcepower) / FP_PER_EU;
                var1 = Math.min(var1, this.excessEU);
                this.excessEU -= var1;
                this.forcepower += var1 * FP_PER_EU;
            }

            if (this.create)
            {
                if (this.Generator_ID == 0)
                {
                    this.Generator_ID = Linkgrid.getWorldMap(this.world).newGenerator_ID(this);
                    Linkgrid.getWorldMap(this.world).getGenerator().put(Integer.valueOf(this.getGenerator_ID()), this);
                }
                else
                {
                    Linkgrid.getWorldMap(this.world).getGenerator().put(Integer.valueOf(this.getGenerator_ID()), this);
                }

                this.create = false;
            }

            if (this.delayupdate == 10)
            {
                this.CheckconInjektor();
                this.CheckconUprades();
                this.delayupdate = 0;
            }
            else
            {
                ++this.delayupdate;
            }

            this.setLinketprojektor(Short.valueOf((short)Linkgrid.getWorldMap(this.world).conProjektors(this.getGenerator_ID(), this.x, this.y, this.z, this.getTransmitrange())));
            boolean var3 = this.world.isBlockPowered(this.x, this.y, this.z);
            boolean var2 = this.world.isBlockIndirectlyPowered(this.x, this.y, this.z);

            if (!var3 && !var2)
            {
                if (this.getActive())
                {
                    this.setActive(false);
                }
            }
            else if (!this.getActive())
            {
                this.setActive(true);
            }

            this.freqencoding();
        }

        if (this.getActive() && this.getWrenchDropRate() != -1.0F)
        {
            this.setWrenchRate(-1.0F);
        }

        if (!this.getActive() && this.getWrenchDropRate() != 1.0F)
        {
            this.setWrenchRate(1.0F);
        }
    }

    public int getForcepower()
    {
        return this.forcepower;
    }

    public void setForcepower(int var1)
    {
        this.forcepower = var1;
        ++this.updateCount;
    }

    public void setTransmitrange(short var1)
    {
        this.transmitrange = var1;
        ++this.updateCount;
    }

    public short getTransmitrange()
    {
        return this.transmitrange;
    }

    public int getGenerator_ID()
    {
        return this.Generator_ID;
    }

    /**
     * Returns the number of slots in the inventory.
     */
    public int getSize()
    {
        return this.inventory.length;
    }

    /**
     * Returns the stack in slot i
     */
    public ItemStack getItem(int var1)
    {
        return this.inventory[var1];
    }

    /**
     * Returns the maximum stack size for a inventory slot. Seems to always be 64, possibly will be extended. *Isn't
     * this more of a set than a get?*
     */
    public int getMaxStackSize()
    {
        return 1;
    }

    /**
     * Do not make give this method the name canInteractWith because it clashes with Container
     */
    public boolean a(EntityHuman var1)
    {
        return this.world.getTileEntity(this.x, this.y, this.z) != this ? false : var1.f((double)this.x + 0.5D, (double)this.y + 0.5D, (double)this.z + 0.5D) <= 64.0D;
    }

    /**
     * Decrease the size of the stack in slot (first int arg) by the amount of the second int arg. Returns the new
     * stack.
     */
    public ItemStack splitStack(int var1, int var2)
    {
        if (this.inventory[var1] != null)
        {
            ItemStack var3;

            if (this.inventory[var1].count <= var2)
            {
                var3 = this.inventory[var1];
                this.inventory[var1] = null;
                return var3;
            }
            else
            {
                var3 = this.inventory[var1].a(var2);

                if (this.inventory[var1].count == 0)
                {
                    this.inventory[var1] = null;
                }

                return var3;
            }
        }
        else
        {
            return null;
        }
    }

    /**
     * Sets the given item stack to the specified slot in the inventory (can be crafting or armor sections).
     */
    public void setItem(int var1, ItemStack var2)
    {
        this.inventory[var1] = var2;

        if (var2 != null && var2.count > this.getMaxStackSize())
        {
            var2.count = this.getMaxStackSize();
        }
    }

    public void f() {}

    /**
     * Returns the name of the inventory.
     */
    public String getName()
    {
        return "GeneratorCore";
    }

    public void g() {}

    /**
     * When some containers are closed they call this on each slot, then drop whatever it returns as an EntityItem -
     * like when you close a workbench GUI.
     */
    public ItemStack splitWithoutUpdate(int var1)
    {
        return null;
    }

    public int[] getUpdate()
    {
        return new int[] {this.forcepower, this.maxforcepower, this.transmitrange & 65535 | this.linketprojektor << 16};
    }

    public void handleUpdate(int[] var1)
    {
        this.forcepower = var1[0];
        this.maxforcepower = var1[1];
        this.transmitrange = (short)var1[2];
        this.linketprojektor = (short)(var1[2] >> 16);
    }

    public boolean acceptsEnergyFrom(TileEntity var1, Direction var2)
    {
        return true;
    }

    public boolean isAddedToEnergyNet()
    {
        return this.addedToEnergyNet;
    }

    public boolean demandsEnergy()
    {
        return this.excessEU == 0;
    }

    public int injectEnergy(Direction var1, int var2)
    {
        if (this.excessEU == 0)
        {
            this.excessEU = var2;
            return 0;
        }
        else
        {
            return var2;
        }
    }

    /**
     * invalidates a tile entity
     */
    public void j()
    {
        super.j();

        if (this.addedToEnergyNet)
        {
            EnergyNet.getForWorld(this.world).removeTileEntity(this);
            this.addedToEnergyNet = false;
        }
    }
    
    @Override
    public ItemStack[] getContents() {return inventory;}
}
