package immibis.ars;

import immibis.core.net.TESync;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.NetworkManager;
import net.minecraft.server.Packet;
import net.minecraft.server.Packet132TileEntityData;
import net.minecraft.server.TileEntity;

public class TileCamouflagedField extends TileEntity
{
    public int camoBlockId = -1;

    /**
     * Overriden in a sign to provide the text
     */
    public Packet d()
    {
        return TESync.make132(this.x, this.y, this.z, this.camoBlockId, 0, 0);
    }

    public void onDataPacket(NetworkManager var1, Packet132TileEntityData var2)
    {
        this.camoBlockId = TESync.getFirst(var2);
    }

    /**
     * Writes a tile entity to NBT.
     */
    public void b(NBTTagCompound var1)
    {
        super.b(var1);
        var1.setInt("camo", this.camoBlockId);
    }

    /**
     * Reads a tile entity from NBT.
     */
    public void a(NBTTagCompound var1)
    {
        super.a(var1);
        this.camoBlockId = var1.getInt("camo");
    }
}
