package immibis.ars;

import forge.DimensionManager;
import immibis.ars.projectors.FFShape;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.server.World;

public class FFWorld
{
    private static Map worlds = new HashMap();
    private World w;
    private Map blocks = new HashMap();
    private StringBuilder hasher = new StringBuilder();
    private CoordinateList refreshQueue = null;
    private Map shapes = new HashMap();

    private static void removeOldWorlds()
    {
        HashSet var0 = new HashSet();
        World[] var4;
        int var3 = (var4 = DimensionManager.getWorlds()).length;
        World var1;

        for (int var2 = 0; var2 < var3; ++var2)
        {
            var1 = var4[var2];
            var0.add(var1);
        }

        Iterator var5 = (new ArrayList(worlds.keySet())).iterator();

        while (var5.hasNext())
        {
            var1 = (World)var5.next();

            if (!var0.contains(var1))
            {
                worlds.remove(var1);
            }
        }
    }

    public static FFWorld get(World var0)
    {
        if (var0 == null)
        {
            return null;
        }
        else
        {
            FFWorld var1 = (FFWorld)worlds.get(var0);

            if (var1 == null)
            {
                worlds.put(var0, var1 = new FFWorld(var0));
            }

            return var1;
        }
    }

    private FFWorld(World var1)
    {
        this.w = var1;
    }

    private String hash(int var1, int var2, int var3)
    {
        this.hasher.setLength(0);
        this.hasher.append(var1).append('/').append(var2).append('/').append(var3);
        return this.hasher.toString();
    }

    public FFBlock addOrGet(int var1, int var2, int var3)
    {
        String var4 = this.hash(var1, var2, var3);
        FFBlock var5 = (FFBlock)this.blocks.get(var4);

        if (var5 == null)
        {
            this.blocks.put(var4, var5 = new FFBlock(var1, var2, var3, this.w));
        }

        return var5;
    }

    public FFBlock get(int var1, int var2, int var3)
    {
        return (FFBlock)this.blocks.get(this.hash(var1, var2, var3));
    }

    public void remove(int var1, int var2, int var3)
    {
        this.blocks.remove(this.hash(var1, var2, var3));
    }

    public void queueRefresh(int var1, int var2, int var3)
    {
        if (this.refreshQueue == null)
        {
            this.refreshQueue = new CoordinateList(8);
        }

        this.refreshQueue.add(var1, var2, var3, 0);
    }

    public void tick()
    {
        if (this.refreshQueue != null)
        {
            CoordinateList.CoordIterator var1 = this.refreshQueue.iterate();

            while (var1.hasNext())
            {
                var1.next();
                FFBlock var2 = this.get(var1.x, var1.y, var1.z);

                if (var2 != null)
                {
                    var2.refresh();
                    var2.refreshCamo();
                }
            }

            if (this.refreshQueue.getAllocatedSize() > 100)
            {
                this.refreshQueue = null;
            }
            else
            {
                this.refreshQueue.clear();
            }
        }
    }

    public Collection getShapesOverlapping(int var1, int var2, int var3)
    {
        return this.shapes.values();
    }

    public static void tickAll()
    {
        removeOldWorlds();
        Iterator var1 = worlds.values().iterator();

        while (var1.hasNext())
        {
            FFWorld var0 = (FFWorld)var1.next();
            var0.tick();
        }
    }

    public void removeShape(FFShape var1)
    {
        String var2 = this.hash(var1.projX, var1.projY, var1.projZ);
        this.shapes.remove(var2);
    }

    public void addShape(FFShape var1)
    {
        String var2 = this.hash(var1.projX, var1.projY, var1.projZ);
        this.shapes.put(var2, var1);
    }
}
