package immibis.ars;

import immibis.ars.projectors.FFShape;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.server.Block;
import net.minecraft.server.EntityItem;
import net.minecraft.server.ItemStack;
import net.minecraft.server.TileEntity;
import net.minecraft.server.World;

public class FFBlock
{
    public FFBlock.Entry activeEntry;
    public List entries = new ArrayList(2);
    public final int x;
    public final int y;
    public final int z;
    public final World w;

    public FFBlock(int var1, int var2, int var3, World var4)
    {
        this.x = var1;
        this.y = var2;
        this.z = var3;
        this.w = var4;
    }

    public int getFieldType()
    {
        return this.activeEntry == null ? 0 : this.activeEntry.ffmeta;
    }

    public boolean shouldBeActive()
    {
        return this.activeEntry != null && this.activeEntry.mode == 1;
    }

    public void usePower(int var1)
    {
        if (this.activeEntry != null)
        {
            TileEntity var2 = (TileEntity)Linkgrid.getWorldMap(this.w).getGenerator().get(Integer.valueOf(this.activeEntry.genID));

            if (var2 instanceof TileEntityGeneratorCore)
            {
                TileEntityGeneratorCore var3 = (TileEntityGeneratorCore)var2;
                int var4 = mod_AdvancedRepulsionSystems.forcefieldblockcost * var1;

                if (BlockForceField.isZapper(this.getFieldType()))
                {
                    var4 *= mod_AdvancedRepulsionSystems.forcefieldblockzappermodifier;
                }

                var3.Energylost(var4);
            }
        }
    }

    public boolean refresh()
    {
        boolean var1 = false;

        if (!this.shouldBeActive())
        {
            if (this.w.getTypeId(this.x, this.y, this.z) == mod_AdvancedRepulsionSystems.MFFSFieldblock.id)
            {
                this.w.setTypeId(this.x, this.y, this.z, 0);
                var1 = true;
            }
        }
        else
        {
            int var2 = this.w.getTypeId(this.x, this.y, this.z);

            if (var2 != 7 && (var2 != mod_AdvancedRepulsionSystems.MFFSFieldblock.id || this.w.getData(this.x, this.y, this.z) != this.getFieldType()) && (var2 == 0 || var2 == mod_AdvancedRepulsionSystems.MFFSFieldblock.id || this.activeEntry.blockBreaker || !Block.byId[var2].material.isBuildable()))
            {
                int var3 = this.w.getData(this.x, this.y, this.z);

                if (var2 != 0 && var2 != mod_AdvancedRepulsionSystems.MFFSFieldblock.id)
                {
                    if (this.w.getTileEntity(this.x, this.y, this.z) != null)
                    {
                        return false;
                    }

                    Block var4 = Block.byId[var2];
                    this.w.setTypeId(this.x, this.y, this.z, 0);
                    ArrayList var5 = var4.getBlockDropped(this.w, this.x, this.y, this.z, var3, 0);
                    Iterator var7 = var5.iterator();

                    while (var7.hasNext())
                    {
                        ItemStack var6 = (ItemStack)var7.next();
                        this.w.addEntity(new EntityItem(this.w, (double)this.x + 0.5D, (double)this.y + 0.5D, (double)this.z + 0.5D, var6));
                    }
                }

                if (var2 != mod_AdvancedRepulsionSystems.MFFSFieldblock.id || var3 != this.getFieldType())
                {
                    this.w.setTypeId(this.x, this.y, this.z, 0);
                    this.w.setTypeIdAndData(this.x, this.y, this.z, mod_AdvancedRepulsionSystems.MFFSFieldblock.id, this.getFieldType());
                }

                this.refreshCamo();
                this.usePower(mod_AdvancedRepulsionSystems.forcefieldblockcreatemodifier);
                var1 = true;
            }
        }

        if (this.activeEntry == null)
        {
            this.refreshActiveEntry();

            if (this.activeEntry == null)
            {
                FFWorld.get(this.w).remove(this.x, this.y, this.z);
            }

            var1 = true;
        }

        return var1;
    }

    public void removeEntry(int var1)
    {
        Iterator var2 = this.entries.iterator();

        while (var2.hasNext())
        {
            if (((FFBlock.Entry)var2.next()).projID == var1)
            {
                var2.remove();
                this.refreshActiveEntry();
                return;
            }
        }
    }

    public void addEntry(FFBlock.Entry var1)
    {
        Iterator var2 = this.entries.iterator();

        while (var2.hasNext())
        {
            if (((FFBlock.Entry)var2.next()).projID == var1.projID)
            {
                var2.remove();
                break;
            }
        }

        for (int var3 = 0; var3 < this.entries.size(); ++var3)
        {
            if (((FFBlock.Entry)this.entries.get(var3)).time > var1.time)
            {
                this.entries.add(var3, var1);
                this.refreshActiveEntry();
                return;
            }
        }

        this.entries.add(var1);
        this.refreshActiveEntry();
    }

    private void refreshActiveEntry()
    {
        ArrayList var1 = new ArrayList(this.entries);
        Iterator var3 = FFWorld.get(this.w).getShapesOverlapping(this.x, this.y, this.z).iterator();

        while (var3.hasNext())
        {
            FFShape var2 = (FFShape)var3.next();
            int var4 = var2.getBlockMode(this.x, this.y, this.z);

            if (var4 != 0 && var4 != 4)
            {
                var1.add(new FFBlock.Entry(var2.ffmeta, var2.genID, var2.projID, var4, var2.breaker, var2.camoBlock, var2.activeTime));
            }
        }

        if (var1.size() < 2)
        {
            FFBlock.Entry var10 = var1.size() == 0 ? null : (FFBlock.Entry)var1.get(0);

            if (this.activeEntry != var10)
            {
                this.activeEntry = var10;
                this.refresh();
                this.refreshCamo();
            }
        }
        else
        {
            long var9 = Long.MIN_VALUE;
            FFBlock.Entry var11 = null;
            HashMap var5 = new HashMap();
            Iterator var7 = var1.iterator();
            FFBlock.Entry var6;

            while (var7.hasNext())
            {
                var6 = (FFBlock.Entry)var7.next();

                if (var6.mode == 3)
                {
                    if (var6.time > var9)
                    {
                        var11 = var6;
                        var9 = var6.time;
                    }
                }
                else
                {
                    FFBlock.Entry var8 = (FFBlock.Entry)var5.get(Integer.valueOf(var6.genID));

                    if (var8 == null)
                    {
                        var5.put(Integer.valueOf(var6.genID), var6);
                    }
                    else if (var8.mode == 1 && var6.mode == 2)
                    {
                        var5.put(Integer.valueOf(var6.genID), var6);
                    }
                }
            }

            var6 = this.activeEntry;
            this.activeEntry = null;
            Iterator var13 = var5.values().iterator();

            while (var13.hasNext())
            {
                FFBlock.Entry var12 = (FFBlock.Entry)var13.next();

                if (var11 == null || var11.genID == var12.genID || var9 >= var12.time)
                {
                    if (this.activeEntry == null)
                    {
                        this.activeEntry = var12;
                    }
                    else if (var12.mode == 1 && this.activeEntry.mode == 2)
                    {
                        this.activeEntry = var12;
                    }
                }
            }

            if (var6 != this.activeEntry)
            {
                this.refresh();
                this.refreshCamo();
            }
        }
    }

    public void useEnergyFor(int var1)
    {
        if (this.shouldBeActive() && this.activeEntry.projID == var1)
        {
            this.usePower(1);
        }
    }

    public void refreshCamo()
    {
        if (this.shouldBeActive() && BlockForceField.isCamo(this.getFieldType()) && this.w.getTypeId(this.x, this.y, this.z) == mod_AdvancedRepulsionSystems.MFFSFieldblock.id)
        {
            TileCamouflagedField var1 = (TileCamouflagedField)this.w.getTileEntity(this.x, this.y, this.z);

            if (var1 == null)
            {
                return;
            }

            if (var1.camoBlockId == this.activeEntry.camoBlock)
            {
                return;
            }

            var1.camoBlockId = this.activeEntry.camoBlock;
            this.w.notify(this.x, this.y, this.z);
        }
    }

    public String getDebugInfo()
    {
        String var1 = "";
        var1 = var1 + "entries.size: " + this.entries.size();
        var1 = var1 + "\nactive mode: " + (this.activeEntry == null ? -1 : this.activeEntry.mode);
        return var1;
    }

    public static class Entry
    {
        public int genID;
        public int projID;
        public byte mode;
        public byte ffmeta;
        public boolean blockBreaker;
        public int camoBlock;
        public long time;

        public Entry(int var1, int var2, int var3, int var4, boolean var5, int var6, long var7)
        {
            this.ffmeta = (byte)var1;
            this.genID = var2;
            this.projID = var3;
            this.mode = (byte)var4;
            this.blockBreaker = var5;
            this.camoBlock = var6;
            this.time = var7;
        }
    }
}
