package immibis.ars;

import immibis.ars.packet.PacketGenericUpdate;
import immibis.core.net.AbstractSyncedContainer;
import immibis.core.net.IPacket;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.ItemStack;

public class ContainerMFFS extends AbstractSyncedContainer
{
    private TileEntityMFFS entity;
    private int updateCount = -1;
    private int baseUpdateCount = -1;

    public ContainerMFFS(EntityHuman var1, TileEntityMFFS var2)
    {
        super(var1, var2);
        this.entity = var2;
    }

    public void onButtonPressed(int var1)
    {
        this.entity.handleButton(var1);
    }

    /**
     * Called to transfer a stack from one inventory to the other eg. when shift clicking.
     */
    public ItemStack a(int var1)
    {
        return null;
    }

    public String getChannel()
    {
        return "MFFS-immiSMP";
    }

    public void onUpdatePacket(IPacket var1)
    {
        if (var1 instanceof PacketGenericUpdate)
        {
            PacketGenericUpdate var2 = (PacketGenericUpdate)var1;

            try
            {
                if (var2.data.length > 0)
                {
                    this.entity.handleUpdate(var2.data);
                }
            }
            catch (ArrayIndexOutOfBoundsException var4)
            {
                ;
            }

            try
            {
                if (var2.baseData.length > 0)
                {
                    this.entity.handleBaseUpdate(var2.baseData);
                }
            }
            catch (ArrayIndexOutOfBoundsException var3)
            {
                ;
            }
        }
    }

    /**
     * Updates crafting matrix; called from onCraftMatrixChanged. Args: none
     */
    public void a()
    {
        super.a();

        if (this.entity.updateCount != this.updateCount || this.entity.baseUpdateCount != this.baseUpdateCount)
        {
            PacketGenericUpdate var1 = new PacketGenericUpdate();

            if (this.entity.updateCount != this.updateCount)
            {
                var1.data = this.entity.getUpdate();
            }

            if (this.entity.baseUpdateCount != this.baseUpdateCount)
            {
                var1.baseData = this.entity.getBaseUpdate();
            }

            this.sendUpdatePacket(var1);
            this.updateCount = this.entity.updateCount;
            this.baseUpdateCount = this.entity.baseUpdateCount;
        }
    }
}
