package immibis.ars;

import immibis.ars.projectors.FFShape;
import immibis.core.api.porting.SidedProxy;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;

import net.minecraft.server.EntityPlayer;
import net.minecraft.server.EnumMovingObjectType;
import net.minecraft.server.MovingObjectPosition;
import net.minecraft.server.Vec3D;
import net.minecraft.server.World;

import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockCanBuildEvent;
import org.bukkit.event.block.BlockEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginLoader;

import com.avaje.ebean.EbeanServer;

public class BukkitPlugin implements Plugin, Listener {
	
	public File dataFolder = new File("config/AdvancedRepulsionSystems");
	public BukkitFakePluginLoader loader;
	public Server server;
	
	public boolean naggable = true;
	public boolean enabled = false;
	
	public BukkitPlugin(BukkitFakePluginLoader loader, Server server) {
		this.loader = loader;
		this.server = server;
	}

	@Override
	public boolean onCommand(CommandSender arg0, Command arg1, String arg2, String[] arg3) {
		return false;
	}

	@Override
	public FileConfiguration getConfig() {
		return null;
	}

	@Override
	public File getDataFolder() {
		return dataFolder;
	}

	@Override
	public EbeanServer getDatabase() {
		return null;
	}

	@Override
	public ChunkGenerator getDefaultWorldGenerator(String arg0, String arg1) {
		return null;
	}

	@Override
	public PluginDescriptionFile getDescription() {
		return BukkitFakePluginLoader.pdf;
	}

	@Override
	public Logger getLogger() {
		return null;
	}

	@Override
	public String getName() {
		return mod_AdvancedRepulsionSystems.instance.getName();
	}

	@Override
	public PluginLoader getPluginLoader() {
		return loader;
	}

	@Override
	public InputStream getResource(String arg0) {
		return BukkitPlugin.class.getResourceAsStream(arg0);
	}

	@Override
	public Server getServer() {
		return server;
	}

	@Override
	public boolean isEnabled() {
		return enabled;
	}

	@Override
	public boolean isNaggable() {
		return naggable;
	}

	@Override
	public void onDisable() {
		System.out.println("Advanced Repulsion Systems plugin disabled");
	}

	@Override
	public void onEnable() {
		server.getPluginManager().registerEvents(this, this);
		System.out.println("Advanced Repulsion Systems plugin enabled");
	}

	@Override
	public void onLoad() {
	}

	@Override
	public void reloadConfig() {
	}

	@Override
	public void saveConfig() {
	}

	@Override
	public void saveDefaultConfig() {
	}

	@Override
	public void saveResource(String arg0, boolean arg1) {
	}

	@Override
	public void setNaggable(boolean arg0) {
		naggable = arg0;
	}

	public void setEnabled(boolean b) {
		if(enabled != b) {
			enabled = b;
			
			if(enabled)
				onEnable();
			else
				onDisable();
		}
	}
	
	private Collection<FFShape> filterShapes(Collection<FFShape> in, int x, int y, int z) {
		ArrayList<FFShape> ret = new ArrayList<FFShape>();
		for(FFShape s : in)
		{
			int mode = s.getBlockMode(x, y, z);
			if(mode != 0)
				ret.add(s);
		}
		return ret;
	}
	
	// returns false if the player cannot affect the block
	@SuppressWarnings("unchecked")
	private boolean test(Player player_, Block block) {
		if(player_.getName().startsWith("["))
			return true; // allow fake players as they might not have a valid position anyway
		
		World world = ((CraftWorld)player_.getWorld()).getHandle();
		FFWorld w = FFWorld.get(world);
		if(w == null)
		{
			//player_.sendMessage("No world");
			return true;
			
		}
		
		Location ploc = player_.getLocation();

		Collection<FFShape> playerFields = filterShapes((Collection<FFShape>)w.getShapesOverlapping(ploc.getBlockX(), ploc.getBlockY(), ploc.getBlockZ()), ploc.getBlockX(), ploc.getBlockY(), ploc.getBlockZ());
		Collection<FFShape> blockFields = filterShapes((Collection<FFShape>)w.getShapesOverlapping(block.getX(), block.getY(), block.getZ()), block.getX(), block.getY(), block.getZ());
		
		if(playerFields.containsAll(blockFields) && blockFields.containsAll(playerFields))
		{
			//player_.sendMessage("Fields are equal (length "+blockFields.size()+")");
			return true;
		}
		
		/*Vec3D start = Vec3D.create(ploc.getX(), ploc.getY() + player_.getEyeHeight(), ploc.getZ());
		Vec3D end = Vec3D.create(block.getX() + 0.5, block.getY() + 0.5, block.getZ() + 0.5);
		
		MovingObjectPosition result = world.rayTrace(start, end, false, false);
		if(result.type == EnumMovingObjectType.TILE && result.b == block.getX() && result.c == block.getY() && result.d == block.getZ())
			return true;
		
		player_.sendMessage("Block "+block.getX()+","+block.getY()+","+block.getZ());
		player_.sendMessage("hit "+result.b+","+result.c+","+result.d);*/
		
		if(player_.getTargetBlock(null, 6).equals(block))
			return true;
		
		player_.sendMessage("Don't do that.");
		
		return false;
	}
	
	@EventHandler
	public void onBreak(BlockBreakEvent evt) {
		if(!evt.isCancelled() && !test(evt.getPlayer(), evt.getBlock()))
			evt.setCancelled(true);
	}
	
	@EventHandler
	public void onPlace(BlockPlaceEvent evt) {
		if(!evt.isCancelled() && !test(evt.getPlayer(), evt.getBlock()))
			evt.setCancelled(true);
	}
	
	@EventHandler
	public void onIgnite(BlockIgniteEvent evt) {
		if(!evt.isCancelled() && !test(evt.getPlayer(), evt.getBlock()))
			evt.setCancelled(true);
	}
	
	@EventHandler
	public void onSignChange(SignChangeEvent evt) {
		if(!evt.isCancelled() && !test(evt.getPlayer(), evt.getBlock()))
			evt.setCancelled(true);
	}
	
	@EventHandler
	public void onInteract(PlayerInteractEvent evt) {
		if(!evt.isCancelled() && !test(evt.getPlayer(), evt.getClickedBlock()))
			evt.setCancelled(true);
	}

}
