package immibis.ars;

import java.io.File;

import net.minecraft.server.Chunk;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.World;

import org.bukkit.Bukkit;
import org.bukkit.plugin.InvalidDescriptionException;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.UnknownDependencyException;

import forge.Configuration;
import forge.ISaveEventHandler;
import forge.MinecraftForge;
import forge.Property;


public class BukkitInterface {
	public static File fakePluginFile = new File("advanced_repulsion_systems_fake_plugin_file_{ffbf60df-1029-4f21-94ad-ace96ed4c38f}");
	
	private static void reallyLoad() {
		Bukkit.getPluginManager().registerInterface(BukkitFakePluginLoader.class);
		try {
			Bukkit.getPluginManager().loadPlugin(fakePluginFile);
		} catch (InvalidDescriptionException e) {
			throw new RuntimeException(e);
		} catch (UnknownDependencyException e) {
			throw new RuntimeException(e);
		} catch (InvalidPluginException e) {
			throw new RuntimeException(e);
		}
	}
	
	public static void load() {
		Property usePluginProp = mod_AdvancedRepulsionSystems.config.getOrCreateBooleanProperty("useBukkitPlugin", Configuration.CATEGORY_GENERAL, false);
		usePluginProp.comment = "If true, ARS will attempt to use a Bukkit plugin to stop people from lagging through forcefields. Still has some glitches.";
		if(!Boolean.valueOf(usePluginProp.value))
			return;
		
		MinecraftForge.registerSaveHandler(new ISaveEventHandler() {
			
			boolean loaded = false;
			
			@Override
			public void onWorldSave(World arg0) {
			}
			
			@Override
			public void onWorldLoad(World arg0) {
				if(!loaded && Bukkit.getServer() != null) {
					reallyLoad();
					loaded = true;
				}
			}
			
			@Override
			public void onChunkUnload(World arg0, Chunk arg1) {
			}
			
			@Override
			public void onChunkSaveData(World arg0, Chunk arg1, NBTTagCompound arg2) {
			}
			
			@Override
			public void onChunkLoadData(World arg0, Chunk arg1, NBTTagCompound arg2) {
			}
			
			@Override
			public void onChunkLoad(World arg0, Chunk arg1) {
			}
		});
	}
}
