package immibis.ars;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

import org.bukkit.Server;
import org.bukkit.event.Event;
import org.bukkit.event.EventException;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.InvalidDescriptionException;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginLoader;
import org.bukkit.plugin.RegisteredListener;
import org.bukkit.plugin.UnknownDependencyException;

public class BukkitFakePluginLoader implements PluginLoader {
	
	public static PluginDescriptionFile pdf = new PluginDescriptionFile(mod_AdvancedRepulsionSystems.instance.getName(), mod_AdvancedRepulsionSystems.instance.getVersion(), "immibis.ars.BukkitPlugin");
	
	public Server server;
	
	public BukkitFakePluginLoader(Server s) {
		server = s;
	}

	@Override
	public Map<Class<? extends Event>, Set<RegisteredListener>> createRegisteredListeners(Listener arg0, Plugin arg1) {
		Map<Class<? extends Event>, Set<RegisteredListener>> ret = new HashMap<Class<? extends Event>, Set<RegisteredListener>>();
		
		for(final Method m : arg0.getClass().getDeclaredMethods()) {
			if(m.isAnnotationPresent(EventHandler.class)) {
				final Class<? extends Event> eclass = m.getParameterTypes()[0].asSubclass(Event.class);
				Set<RegisteredListener> s = ret.get(eclass);
				if(s == null) {
					s = new HashSet<RegisteredListener>();
					ret.put(eclass, s);
				}
				
				s.add(new RegisteredListener(arg0, new EventExecutor() {
					@Override
					public void execute(Listener arg0, Event arg1) throws EventException {
						try {
							if(eclass.isAssignableFrom(arg1.getClass()))
								m.invoke(arg0, arg1);
						} catch(InvocationTargetException e) {
							throw new EventException(e.getCause());
						} catch(Exception e) {
							throw new EventException(e);
						}
					}
				}, EventPriority.LOWEST, arg1, false));
			}
		}

		return ret;
	}

	@Override
	public void disablePlugin(Plugin arg0) {
		((BukkitPlugin)arg0).setEnabled(false);
	}

	@Override
	public void enablePlugin(Plugin arg0) {
		((BukkitPlugin)arg0).setEnabled(true);
	}

	@Override
	public PluginDescriptionFile getPluginDescription(File arg0) throws InvalidDescriptionException {
		return pdf;
	}

	@Override
	public Pattern[] getPluginFileFilters() {
		return new Pattern[] {
			Pattern.compile(Pattern.quote(BukkitInterface.fakePluginFile.getName()))
		};
	}

	@Override
	public Plugin loadPlugin(File arg0) throws InvalidPluginException, UnknownDependencyException {
		return new BukkitPlugin(this, server);
	}

}
