package mods.immibis.ars.beams;


import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import mods.immibis.ars.beams.logictypes.ClassDetector;
import mods.immibis.ars.beams.logictypes.Intersection;
import mods.immibis.ars.beams.logictypes.Negate;
import mods.immibis.ars.beams.logictypes.NothingDetector;
import mods.immibis.ars.beams.logictypes.RedstoneInput;
import mods.immibis.ars.beams.logictypes.Union;
import mods.immibis.core.api.porting.SidedProxy;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.*;
import net.minecraft.entity.passive.*;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public abstract class LogicType {
	private static Map<Integer, LogicType> types = new HashMap<Integer, LogicType>();
	private static Map<Item, LogicType> items = new HashMap<Item, LogicType>();
	private static Map<Integer, String> icons = new HashMap<Integer, String>();
	
	public static LogicType get(int id) {
		return types.get(id);
	}
	
	public static void register(int id, String icon, String name, LogicType type, Item item) {
		if(types.containsKey(id))
			throw new IllegalArgumentException("Logic card type "+id+" is already registered.");
		
		if(name != null) {
			types.put(id, type);
			SidedProxy.instance.addLocalization("immibis.ars.logiccard."+id+".name", name);
		}
		
		if(item != null) items.put(item, type);
		if(icon != null) icons.put(id, icon);
	}
	
	public static void register(LogicType type, Item item) {
		if(item != null)
			items.put(item, type);
	}
	
	public static Set<Integer> getAllTypeIDs() {
		return types.keySet();
	}
	
	public abstract EntityFilter createFilter(TileUpgradeUnit container, EntityFilter[] in);
	
	public static final int ID_PLAYER = 0;
	public static final int ID_AND = 1;
	public static final int ID_OR = 2;
	public static final int ID_INVERT = 3;
	public static final int ID_BLANK = 4;
	public static final int ID_LIVING = 5;
	public static final int ID_REDSTONE = 6;
	public static final int ID_ANIMAL = 7;
	public static final int ID_MOB = 8;
	public static final int ID_ITEM = 9;
	
	static void init() {
		register(ID_PLAYER, "immibis/ars:card/player", "Player detector token", new ClassDetector(EntityPlayer.class), null);
		register(ID_AND, "immibis/ars:card/and", "AND token", new Intersection(), null);
		register(ID_OR, "immibis/ars:card/or", "OR token", new Union(), null);
		register(ID_INVERT, "immibis/ars:card/not", "NOT token", new Negate(), null);
		register(ID_BLANK, "immibis/ars:card/blank", "Blank token", new NothingDetector(), null);
		register(ID_LIVING, "immibis/ars:card/life", "Life detector token", new ClassDetector(EntityLiving.class), null);
		register(ID_REDSTONE, "immibis/ars:card/redstone", "Redstone input token", new RedstoneInput(), Item.redstone);
		register(ID_ANIMAL, "immibis/ars:card/animal", "Animal detector token", new ClassDetector(EntityAnimal.class), null);
		register(ID_MOB, "immibis/ars:card/mob", "Mob detector token", new ClassDetector(IMob.class), null);
		register(ID_ITEM, "immibis/ars:card/item", "Item detector token", new ClassDetector(EntityItem.class), Item.itemsList[Block.cobblestone.blockID]);
		register(new ClassDetector(EntityCreeper.class), Item.gunpowder);
		register(new ClassDetector(EntityChicken.class), Item.egg);
		register(new ClassDetector(EntityCow.class), Item.beefRaw);
		register(new ClassDetector(EntityOcelot.class), Item.fishRaw);
		register(new ClassDetector(EntityPig.class), Item.porkRaw);
		register(new ClassDetector(EntitySheep.class), Item.itemsList[Block.cloth.blockID]);
		register(new ClassDetector(EntitySquid.class), Item.bucketWater);
		register(new ClassDetector(EntityVillager.class), null);
		register(new ClassDetector(EntityEnderman.class), Item.enderPearl);
		register(new ClassDetector(EntityWolf.class), Item.bone);
		register(new ClassDetector(EntityPigZombie.class), Item.goldNugget);
		register(new ClassDetector(EntityBlaze.class), Item.blazeRod);
		register(new ClassDetector(EntityCaveSpider.class), null);
		register(new ClassDetector(EntityZombie.class), Item.rottenFlesh);
		register(new ClassDetector(EntityGhast.class), Item.ghastTear);
		register(new ClassDetector(EntityMagmaCube.class), Item.magmaCream);
		register(new ClassDetector(EntitySilverfish.class), null);
		register(new ClassDetector(EntitySkeleton.class), Item.bow);
		register(new ClassDetector(EntitySlime.class), Item.slimeBall);
		register(new ClassDetector(EntitySnowman.class), Item.snowball);
		register(new ClassDetector(EntityIronGolem.class), Item.ingotIron);
		register(new ClassDetector(EntityArrow.class), Item.arrow);
		register(new ClassDetector(EntityThrowable.class), null);
	}

	public static LogicType getForItem(ItemStack is) {
		if(is == null)
			return null;
		
		if(is.itemID == BeamsMain.itemLogicCard.itemID)
			return get(is.getItemDamage());
		return items.get(is.getItem());
	}

	public static String getIconName(int meta) {
		return icons.get(meta);
	}

}
