package mods.immibis.ars.beams;


import java.util.ArrayList;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

import mods.immibis.core.BlockCombined;
import mods.immibis.core.RenderUtilsIC;
import mods.immibis.core.api.util.Dir;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.src.ModLoader;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;

public class BlockBeamStuff extends BlockCombined {

	public BlockBeamStuff(int id) {
		super(id, Material.iron, "/immibis/ars/textures/tesla.png", new String[0]);
		
		ModLoader.registerBlock(this, ItemBeamStuff.class);
	}
	
	//@Override
	//public int getRenderType() {return model;}
	
	private Icon[][] iFilter, iMultiplexer, iRange, iEMP, iSpeed, iLoot, iFieldFilter;
	private Icon[][] iInvFilter, iSuppressor, iApplicator;
	private Icon iTeslaOff, iTeslaOn;
	
	private Icon[][] iLoad(IconRegister r, String prefix) {
		return new Icon[][] {RenderUtilsIC.loadIconArray(r, "immibis/ars:tesla>"+prefix+"0", 6), RenderUtilsIC.loadIconArray(r, "immibis/ars:tesla>"+prefix+"1", 6)};
	}
	
	@Override
	@SideOnly(Side.CLIENT)
	public void registerIcons(IconRegister r) {
		iFilter = iLoad(r, "filter");
		iMultiplexer = iLoad(r, "multiplexer");
		iRange = iLoad(r, "range");
		iEMP = iLoad(r, "emp");
		iSpeed = iLoad(r, "speed");
		iLoot = iLoad(r, "loot");
		iFieldFilter = iLoad(r, "field");
		iInvFilter = iLoad(r, "inv");
		iSuppressor = iLoad(r, "suppressor");
		iApplicator = iLoad(r, "potion");
		iTeslaOff = RenderUtilsIC.loadIcon(r, "immibis/ars:tesla>tesla-off");
		iTeslaOn = RenderUtilsIC.loadIcon(r, "immibis/ars:tesla>tesla-on");
	}
	
	private Icon[][] getTextureBase(int meta) {
		switch(meta) {
		case 0: return iFilter; // filter
		case 1: return null; // tesla coil; special case that doesn't use this method
		case 2: return iMultiplexer; // upgrade combiner
		case 3: return iRange; // range upgrade
		case 4: return iEMP; // emp upgrade 
		case 5: return iSpeed; // speed upgrade
		case 6: return iLoot; // loot collector
		case 7: return iFieldFilter; // field filter
		case 8: return iInvFilter; // inventory contents filter
		case 9: return iSuppressor; // suppressor upgrade
		case 10: return iApplicator; // remote potion applicator
		default: return null;
		}
	}
	
	@Override
	public Icon getBlockTexture(IBlockAccess w, int x, int y, int z, int side) {
		TileEntity te = w.getBlockTileEntity(x, y, z);
		if(te instanceof TileTeslaCoil)
			return iTeslaOff;
		else if(te instanceof TileBeamEmitter) {
			Icon[][] tex = getTextureBase(w.getBlockMetadata(x, y, z));
			if(tex == null)
				return null;
			return tex[side == ((TileBeamEmitter)te).outputFace ? 1 : 0][side];
		}
		else
			return null;
	}

	@Override
	public Icon getIcon(int side, int data) {
		if(data == 1)
			return iTeslaOff;
		Icon[][] tex = getTextureBase(data);
		if(tex == null)
			return null;
		return tex[side == Dir.PY ? 1 : 0][side];
	}

	@Override
	public TileEntity getBlockEntity(int data) {
		switch(data) {
		case 0: return new TileUpgradeUnit();
		case 1: return new TileTeslaCoil();
		case 2: return new TileUpgradeCombiner();
		case 3: return new TileRangeUpgrade();
		case 4: return new TileEMPUpgrade();
		case 5: return new TileSpeedUpgrade();
		case 6: return new TileLootCollector();
		case 7: return new TileFieldFilter();
		case 8: return new TileInventoryContentsFilter();
		case 9: return new TileSuppressorUpgrade();
		case 10: return new TilePotionUpgrade();
		default: return null;
		}
	}

	@Override
	public void addCreativeItems(ArrayList arraylist) {
		for(int k = 0; k < 11; k++)
			arraylist.add(new ItemStack(this, 1, k));
	}

}
