package mods.immibis.ars;

import mods.immibis.core.api.porting.PortableTileEntity;
import mods.immibis.core.net.TESync;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;

public class TileCamouflagedField extends PortableTileEntity {
	public int camoBlockId = -1;
	
	public static int getBlockID(int camoID) {
		return camoID & 4095;
	}
	
	public static int getMetadata(int camoID) {
		return camoID >> 16;
	}
	
	public static int getCamoID(int blockID, int meta) {
		return blockID | (meta << 16);
	}
	
	@Override
	public Packet getDescriptionPacket() {
		return TESync.make132(xCoord, yCoord, zCoord, camoBlockId, 0, 0);
	}
	
	@Override
	public void onDataPacket(Packet132TileEntityData p) {
		camoBlockId = TESync.getFirst(p);
	}
	
	@Override
	public void writeToNBT(NBTTagCompound nbt) {
		super.writeToNBT(nbt);
		nbt.setInteger("camo", camoBlockId);
	}
	
	@Override
	public void readFromNBT(NBTTagCompound nbt) {
		super.readFromNBT(nbt);
		camoBlockId = nbt.getInteger("camo");
	}
}
