package mods.immibis.ars;

import ic2.api.item.Items;
import ic2.api.tile.ExplosionWhitelist;

import java.io.File;
import mods.immibis.ars.beams.*;
import mods.immibis.ars.packet.PacketGenericUpdate;
import mods.immibis.ars.projectors.TileProjector;
import mods.immibis.ars.projectors.TileProjectorArea;
import mods.immibis.ars.projectors.TileProjectorDeflector;
import mods.immibis.ars.projectors.TileProjectorDirectional;
import mods.immibis.ars.projectors.TileProjectorExtender;
import mods.immibis.ars.projectors.TileProjectorReactor;
import mods.immibis.ars.projectors.TileProjectorTube;
import mods.immibis.core.api.APILocator;
import mods.immibis.core.api.FMLModInfo;
import mods.immibis.core.api.net.IPacket;
import mods.immibis.core.api.net.IPacketMap;
import mods.immibis.core.api.porting.PortableBaseMod;
import mods.immibis.core.api.porting.SidedProxy;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.src.ModLoader;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.Configuration;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.PostInit;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
//import org.lwjgl.input.Keyboard;
//import net.minecraft.client.Minecraft;
import cpw.mods.fml.common.registry.GameRegistry;

@Mod(version = "55.0.1", name = "Advanced Repulsion Systems", modid = "AdvancedRepulsionSystems", dependencies = "required-after:ImmibisCore;required-after:IC2")
@NetworkMod(clientSideRequired = false, serverSideRequired = true)
@FMLModInfo(
	url="http://www.minecraftforum.net/topic/1001131-110-immibiss-mods-smp/",
	description="Adds FORCEFIELDS!",
	credits="Originally by Thunderdark, updated by immibis. Some textures by kaj_ and IvySaur1996.",
	authors="Thunderdark;immibis;kaj_;IvySaur1996"
	)
public class ARSMod extends PortableBaseMod implements IPacketMap {

	@cpw.mods.fml.common.SidedProxy(clientSide="mods.immibis.ars.ClientProxy", serverSide="mods.immibis.ars.BaseProxy")
	public static BaseProxy proxy;

	public static Configuration config;

	public static Block MFFSMaschines;
	public static Block MFFSUpgrades;
	public static Block MFFSFieldblock;

	public static Item MFFSitemMFDoffset;
	public static Item MFFSitemMFDdebugger;
	public static Item MFFSitemcardempty;
	public static Item MFFSitemfc;
	public static Item itemComponent;

	public static final int GUI_ID_GENERATOR = 1;
	public static final int GUI_AREA_PROJECTOR = 2;
	public static final int GUI_DIRECTIONAL_PROJECTOR = 3;
	public static final int GUI_DEFLECTOR_PROJECTOR = 4;
	public static final int GUI_DIRECTIONAL_UPGRADE = 5;
	public static final int GUI_TUBE_PROJECTOR = 6;
	public static final int GUI_CAMOFLAGE_UPGRADE = 7;
	public static final int GUI_REACTOR_FIELD = 8;
	public static final int GUI_UPGRADE_UNIT = 13;
	public static final int GUI_LOOT_COLLECTOR = 14;
	public static final int GUI_INVENTORY_CONTENTS_FILTER = 15;
	public static final int GUI_POTION_UPGRADE = 16;

	public static final String CHANNEL = "AdvRepSys";

	public static final byte PKT_GENERIC_UPDATE = 0;
	public static final byte PKT_PROJECTOR_DESCRIPTION = 1; // unused
	public static final byte PKT_BOLT_FX = 2;

	public static final boolean DEBUG_MODE = Block.class.getName().equals("net.minecraft.src.Block");

	// begin config options
	public static int forcefieldblockcost;
	public static int forcefieldblockcreatemodifier;
	public static int forcefieldblockzappermodifier;

	public static int reaktorheatcontrolice;
	public static int reaktorheatcontrolwater;
	public static int reaktorheatcontrollava;

	public static int core_storage_default;
	public static int core_storage_upgrade_amount;
	public static int core_range_default;
	//public static int core_range_upgrade_amount;

	public static boolean enableReactorBlocks, enableTeslaCoil;
	public static boolean useOldRecipes;
	// end config options

	public static StringBuffer hasher = new StringBuffer();
	
	public static ARSMod instance;

	public static boolean slowRefresh;
	public static int maxSize, maxDeflectorDistance, maxTubeRadius;
	public static int refreshSpeed;

	public ARSMod() {
		instance = this;
	}

	@Init
	public void load(FMLInitializationEvent evt) {
		config = new Configuration(new File(Functions.getMinecraftDir(), "config/AdvancedRepulsionSystems.cfg"));
		config.load();

		BlockForceField.model = SidedProxy.instance.getUniqueBlockModelID("mods.immibis.ars.BlockRendererField", true);

		/*Property slowRefreshProp = config.getOrCreateBooleanProperty("slowRefresh", Configuration.CATEGORY_GENERAL, false);
		slowRefreshProp.comment = "If true, forcefields will refresh every second. If false every tick (as before).";
		slowRefresh = Boolean.valueOf(slowRefreshProp.value);*/
		slowRefresh = false;

		Functions.removeIntFromBlockSection("reaktorheatcontrolice");
		Functions.removeIntFromBlockSection("reaktorheatcontrolwater");
		Functions.removeIntFromBlockSection("reaktorheatcontrollava");

		forcefieldblockcost = Functions.getIntFromBlockSection("forcefieldblockcost", "fieldCostBase", 1);
		forcefieldblockcreatemodifier = Functions.getIntFromBlockSection("forcefieldblockcreatemodifier", "fieldCostCreateMultiplier", 10);
		forcefieldblockzappermodifier = Functions.getIntFromBlockSection("forcefieldblockzappermodifier", "fieldCostZapperMultiplier", 2);
		maxSize = Functions.getBalanceOption("maxProjectorSize", 32);
		maxDeflectorDistance = Functions.getBalanceOption("maxDeflectorDistance", 10);
		maxTubeRadius = Functions.getBalanceOption("maxTubeRadius", 5);
		refreshSpeed = Functions.getBalanceOption("refreshSpeed", 100);
		TileProjector.maxOffset = Functions.getBalanceOption("maxOffset", 48);
		TileProjector.cooldownBlocksPerTick = Functions.getBalanceOption("cooldownBlocksPerTick", 40);

		enableReactorBlocks = Functions.getConfigBoolean("enableReactorBlocks", true);
		enableTeslaCoil = Functions.getConfigBoolean("enableTeslaCoil", true);
		useOldRecipes = Functions.getConfigBoolean("useOldRecipes", false);

		core_range_default = Functions.getBalanceOption("coreRangeDefault", 16);
		core_storage_default = Functions.getBalanceOption("coreStorageDefault", 1000000);
		//core_range_upgrade_amount = Functions.getBalanceOption("coreRangeUpgradeAmount", )
		core_storage_upgrade_amount = Functions.getBalanceOption("coreStorageUpgradeAmount", 2000000);

		int fieldBlockID = Functions.getActualBlockIdFor("HFFPFieldblock", "blockField", 255);
		int machineID = Functions.getActualBlockIdFor("HFFPMaschines", "blockMachine", 253);
		int upgradeID = Functions.getActualBlockIdFor("HFFSUpgrades", "blockUpgrade", 254);
		int debuggerID = Functions.getItemIdFor("itemMFDdebugger", "itemDebuggerMFD", 11111);
		int emptyCardID = Functions.getItemIdFor("itemcardempty", "itemCardEmpty", 11115);
		int freqCardID = Functions.getItemIdFor("itemfc", "itemCardCoreLink", 11116);
		int reactorCardID = Functions.getItemIdFor("itemsclc", "itemCardReactorLink", 11118);
		int offsetID = Functions.getItemIdFor("itemMFDoffset", "itemOffsetMFD", 11119);
		int componentID = Functions.getItemIdFor("itemComponent", "itemCraftingComponent", 11121);

		if(enableTeslaCoil)
			BeamsMain.readConfig();

		config.save();

		MFFSFieldblock = new BlockForceField(fieldBlockID);
		MFFSMaschines = new BlockMachine(machineID);
		MFFSUpgrades = new BlockUpgrades(upgradeID);

		MFFSitemMFDdebugger = new ItemMFDDebugger(debuggerID - 256);
		MFFSitemcardempty = new ItemCardempty(emptyCardID - 256);
		MFFSitemfc = new ItemFrequenzCard(freqCardID - 256);
		MFFSitemMFDoffset = new ItemMFDOffset(offsetID - 256);
		// 11120 is logic cards
		itemComponent = new ItemComponent(componentID - 256);

		if(enableTeslaCoil)
			BeamsMain.init();

		if (config != null) {
			config.save();
		}

		ModLoader.registerBlock(MFFSMaschines, ItemMachines.class);
		ModLoader.registerBlock(MFFSUpgrades, ItemUpgrades.class);
		ModLoader.registerBlock(MFFSFieldblock);

		ModLoader.registerTileEntity(TileEntityMaschines.class, "Maschines_Multi");
		ModLoader.registerTileEntity(TileEntityGeneratorCore.class, "Generator_Core");
		ModLoader.registerTileEntity(TileProjectorArea.class, "Area_Projektor");
		ModLoader.registerTileEntity(TileUpgradePassive.class, "Generator_Upgrade");
		ModLoader.registerTileEntity(TileEntityGeneratorEUInjector.class, "Generator_EU_Injektor");
		ModLoader.registerTileEntity(TileProjectorDirectional.class, "Directional_Projektor");
		ModLoader.registerTileEntity(TileProjectorDeflector.class, "Deflector_Projektor");
		ModLoader.registerTileEntity(TileProjectorExtender.class, "Directional_Extender");
		ModLoader.registerTileEntity(TileProjectorTube.class, "Tube_Projektor");
		ModLoader.registerTileEntity(TileUpgradeCamouflage.class, "Projektor_camouflage");
		ModLoader.registerTileEntity(TileProjectorReactor.class, "Reaktor_Field");
		ModLoader.registerTileEntity(TileEntityReaktorConnector.class, "Reactor_Connector");
		ModLoader.registerTileEntity(TileCamouflagedField.class, "MFFS camo");

		ModLoader.addName(MFFSitemcardempty, "Blank ARS card");
		ModLoader.addName(MFFSitemfc, "Forcefield frequency card");
		ModLoader.addName(MFFSitemMFDdebugger, "MFDevice <Debugger>");
		ModLoader.addName(MFFSitemMFDoffset, "MFDevice <Offset>");

		ModLoader.addLocalization("Tube_Projektor.name", "Tube forcefield projector");
		ModLoader.addLocalization("Directional_Extender.name", "Line projector extender");
		ModLoader.addLocalization("Deflector_Projektor.name", "Plate forcefield projector");
		ModLoader.addLocalization("Generator_Core.name", "Forcefield core");
		ModLoader.addLocalization("Area_Projektor.name", "Area forcefield projector");
		ModLoader.addLocalization("Generator_Storage.name", "Forcefield core storage upgrade");
		ModLoader.addLocalization("Generator_Linkex.name", "Forcefield core range upgrade");
		ModLoader.addLocalization("Generator_EU_Injektor.name", "Forcefield EU injector");
		ModLoader.addLocalization("Directional_Projektor.name", "Directional forcefield projector");
		ModLoader.addLocalization("Projektor_Subwater.name", "Forcefield underwater upgrade");
		ModLoader.addLocalization("Projektor_Dome.name", "Forcefield dome upgrade");
		ModLoader.addLocalization("Projektor_Hardner.name", "Forcefield block cutter upgrade");
		ModLoader.addLocalization("Projektor_Zapper.name", "Forcefield zapper upgrade");
		ModLoader.addLocalization("Projektor_camouflage.name", "Forcefield camouflage upgrade");
		ModLoader.addLocalization("Reaktor_Field.name", "Reactor containment field projector");
		ModLoader.addLocalization("Reactor_Connector.name", "Reactor connector");
		ModLoader.addLocalization("Reaktor_Cooler.name", "Reactor coolant injector");
		ModLoader.addLocalization("Reaktor_Monitor.name", "Reactor heat monitor server");
		ModLoader.addLocalization("Reaktor_Monitor_Client.name", "Reactor heat monitor client");
		ModLoader.addLocalization("MFFS_Inhibitor.name", "Forcefield inhibitor upgrade");

		SidedProxy.instance.preloadTexture("/immibis/ars/textures/upgrades.png");
		SidedProxy.instance.preloadTexture("/immibis/ars/textures/machines.png");
		SidedProxy.instance.preloadTexture("/immibis/ars/textures/blocks.png");
		SidedProxy.instance.preloadTexture("/immibis/ars/textures/items.png");
		SidedProxy.instance.preloadTexture("/immibis/ars/textures/world-kaj.png");

		enableClockTicks(true);
		NetworkRegistry.instance().registerGuiHandler(this, new IGuiHandler() {

			@Override
			public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
				TileEntity te = world.getBlockTileEntity(x, y, z);
				if(te == null)
					return null;
				int meta = te.worldObj.getBlockMetadata(te.xCoord, te.yCoord, te.zCoord);
				int blockid = te.worldObj.getBlockId(te.xCoord, te.yCoord, te.zCoord);
				if ((meta == 4 || meta == 5) && blockid == MFFSUpgrades.blockID) {
					// TODO WTF?
					ID = GUI_ID_GENERATOR;
				}

				switch(ID) {
				case GUI_ID_GENERATOR:
					return new ContainerGenerator(player, ((TileEntityGeneratorCore) te));
				case GUI_AREA_PROJECTOR:
					return new ContainerProjektor(player, ((TileProjectorArea) te));
				case GUI_DIRECTIONAL_PROJECTOR:
					return new ContainerProjektor(player, ((TileProjectorDirectional) te));
				case GUI_DEFLECTOR_PROJECTOR:
					return new ContainerProjektor(player, ((TileProjectorDeflector) te));
				case GUI_DIRECTIONAL_UPGRADE:
					return new Containerdummy(player, ((TileProjectorExtender) te));
				case GUI_TUBE_PROJECTOR:
					return new ContainerProjektor(player, ((TileProjectorTube) te));
				case GUI_CAMOFLAGE_UPGRADE:
					return new ContainerCamoflage(player, ((TileUpgradeCamouflage) te));
				case GUI_REACTOR_FIELD:
					return new ContainerProjektor(player, ((TileProjectorReactor) te));
				case GUI_UPGRADE_UNIT:
					return new ContainerUpgradeUnit(player, (TileUpgradeUnit)te);
				case GUI_LOOT_COLLECTOR:
					return new ContainerLootCollector(player, (TileLootCollector)te);
				case GUI_INVENTORY_CONTENTS_FILTER:
					return new ContainerInventoryContentsFilter(player, (TileInventoryContentsFilter)te);
				case GUI_POTION_UPGRADE:
					return new ContainerPotionUpgrade(player, (TilePotionUpgrade)te);
				}
				return null;
			}

			@Override
			public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
				TileEntity te = world.getBlockTileEntity(x, y, z);
				if(te == null)
					return null;
				int meta = te.worldObj.getBlockMetadata(te.xCoord, te.yCoord, te.zCoord);
				int blockid = te.worldObj.getBlockId(te.xCoord, te.yCoord, te.zCoord);
				if ((meta == 4 || meta == 5) && blockid == MFFSUpgrades.blockID) {
					// TODO WTF?
					ID = GUI_ID_GENERATOR;
				}

				switch(ID) {
				case GUI_ID_GENERATOR:
					return new GuiGenerator(player, ((TileEntityGeneratorCore) te));
				case GUI_AREA_PROJECTOR:
					return new GuiProjektorArea(player, ((TileProjectorArea) te));
				case GUI_DIRECTIONAL_PROJECTOR:
					return new GuiProjektorDirectional(player, ((TileProjectorDirectional) te));
				case GUI_DEFLECTOR_PROJECTOR:
					return new GuiDeflectorDirectional(player, ((TileProjectorDeflector) te));
				case GUI_DIRECTIONAL_UPGRADE:
					return new GuiDirectionalUpgrade(player, ((TileProjectorExtender) te));
				case GUI_TUBE_PROJECTOR:
					return new GuiProjTube(player, ((TileProjectorTube) te));
				case GUI_CAMOFLAGE_UPGRADE:
					return new GuiCamouflageUpgrade(player, ((TileUpgradeCamouflage) te));
				case GUI_REACTOR_FIELD:
					return new GuiReaktorField(player, ((TileProjectorReactor) te));
				case GUI_UPGRADE_UNIT:
					return new GuiUpgradeUnit(new ContainerUpgradeUnit(player, (TileUpgradeUnit)te));
				case GUI_LOOT_COLLECTOR:
					return new GuiLootCollector(new ContainerLootCollector(player, (TileLootCollector)te));
				case GUI_INVENTORY_CONTENTS_FILTER:
					return new GuiInventoryContentsFilter(new ContainerInventoryContentsFilter(player, (TileInventoryContentsFilter)te));
				case GUI_POTION_UPGRADE:
					return new GuiPotionUpgrade(new ContainerPotionUpgrade(player, (TilePotionUpgrade)te));
				}
				return null;
			}
		});

		APILocator.getNetManager().listen(this);
	}

	@Override
	public boolean onTickInGame() {
		FFWorld.tickAll();
		return true;
	}

	@PostInit
	public void modsLoaded(FMLPostInitializationEvent evt)
	{
		ExplosionWhitelist.addWhitelistedBlock(MFFSFieldblock);
		ExplosionWhitelist.addWhitelistedBlock(MFFSUpgrades);
		ExplosionWhitelist.addWhitelistedBlock(MFFSMaschines);

		if(Items.getItem("advancedAlloy") != null) {
			// No recipes if IC2 isn't loaded but some other mod has the IC2 API
			// TODO: why bother? 100% of this mod is useless without IC2

			if(enableReactorBlocks) {
				ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, BlockMachine.META_PROJ_REACTOR),
						"ADA",
						"BCB",
						"ABA",
						'A', Items.getItem("carbonPlate"),
						'B', Items.getItem("advancedAlloy"),
						'C', new ItemStack(MFFSMaschines, 1, BlockMachine.META_PROJ_AREA),
						'D', Items.getItem("advancedCircuit")
						);
			}

			ModLoader.addRecipe(new ItemStack(MFFSitemMFDoffset),
					"BCB",
					"DAD",
					"DDD",
					'A', Item.diamond,
					'B', Items.getItem("insulatedCopperCableItem"),
					'C', Item.redstone,
					'D', Items.getItem("refinedIronIngot")
					);

			if(!useOldRecipes) {
				
				// reverse crafting
				GameRegistry.addShapelessRecipe(new ItemStack(itemComponent, 1, ItemComponent.META_PROJECTOR_BASE), new ItemStack(MFFSMaschines, 1, BlockMachine.META_PROJ_AREA));
				GameRegistry.addShapelessRecipe(new ItemStack(itemComponent, 1, ItemComponent.META_PROJECTOR_BASE), new ItemStack(MFFSMaschines, 1, BlockMachine.META_PROJ_DEFLECTOR));
				GameRegistry.addShapelessRecipe(new ItemStack(itemComponent, 1, ItemComponent.META_PROJECTOR_BASE), new ItemStack(MFFSMaschines, 1, BlockMachine.META_PROJ_DIR));
				GameRegistry.addShapelessRecipe(new ItemStack(itemComponent, 1, ItemComponent.META_PROJECTOR_BASE), new ItemStack(MFFSMaschines, 1, BlockMachine.META_PROJ_EXTENDER));
				GameRegistry.addShapelessRecipe(new ItemStack(itemComponent, 1, ItemComponent.META_PROJECTOR_BASE), new ItemStack(MFFSMaschines, 1, BlockMachine.META_PROJ_TUBE));
				GameRegistry.addShapelessRecipe(new ItemStack(MFFSMaschines, 1, BlockMachine.META_PROJ_AREA), new ItemStack(MFFSMaschines, 1, BlockMachine.META_PROJ_REACTOR));
				
				ModLoader.addRecipe(new ItemStack(MFFSitemcardempty, 8),
						"RAR",
						"ABA",
						"RAR",
						Character.valueOf('A'), Item.paper,
						Character.valueOf('B'), Items.getItem("electronicCircuit"),
						'R', Item.redstone
						);

				ModLoader.addRecipe(new ItemStack(itemComponent, 1, ItemComponent.META_ENERGY_MODULATOR),
						" ^ ",
						" | ",
						"-M-",

						'^', Items.getItem("frequencyTransmitter"),
						'M', Items.getItem("electronicCircuit"),
						'-', Items.getItem("glassFiberCableItem"),
						'|', Items.getItem("glassFiberCableItem") // was goldCableItem
						);

				/*ModLoader.addRecipe(new ItemStack(itemComponent, 1, ItemComponent.META_CONTROL_PANEL),
					"...",
					"...",
					"#C#",
					'.', Block.button,
					'#', Items.getItem("reinforcedStone"),
					'C', Items.getItem("electronicCircuit")
				);*/

				ModLoader.addRecipe(new ItemStack(itemComponent, 4, ItemComponent.META_DIAMOND_LENS),
						"X-X",
						"|*|",
						"X-X",
						'-', Block.glass,
						'|', Block.glass,
						'*', Item.diamond,
						'X', Items.getItem("advancedAlloy")
						);

				ModLoader.addRecipe(new ItemStack(itemComponent, 1, ItemComponent.META_PROJECTOR_BASE),
						"#^#",
						"$O$",
						"/E/",
						'#', Items.getItem("reinforcedStone"),
						'$', Items.getItem("carbonPlate"),
						'O', new ItemStack(itemComponent, 1, ItemComponent.META_DIAMOND_LENS),
						'/', Item.redstoneRepeater,
						'E', Items.getItem("electrolyzer"),
						'^', new ItemStack(itemComponent, 1, ItemComponent.META_ENERGY_MODULATOR)
						);

				// core
				ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, BlockMachine.META_CORE),
						"#^#",
						"OMO",
						"CEC",

						'M', Items.getItem("mfeUnit"),
						'^', new ItemStack(itemComponent, 1, ItemComponent.META_ENERGY_MODULATOR),
						'E', Items.getItem("electrolyzer"),
						'#', Items.getItem("advancedAlloy"),
						'O', Items.getItem("electrolyzedWaterCell"),
						'C', Items.getItem("advancedCircuit")
						);

				// area
				ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, BlockMachine.META_PROJ_AREA),
						"###",
						"#P#",
						"###",
						'#', Items.getItem("reinforcedStone"),
						'P', new ItemStack(itemComponent, 1, ItemComponent.META_PROJECTOR_BASE)
						);

				// dir
				ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, BlockMachine.META_PROJ_DIR),
						"#",
						"#",
						"P",
						'#', Items.getItem("reinforcedStone"),
						'P', new ItemStack(itemComponent, 1, ItemComponent.META_PROJECTOR_BASE)
						);

				// defl
				ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, BlockMachine.META_PROJ_DEFLECTOR),
						"###",
						" P ",
						'#', Items.getItem("reinforcedStone"),
						'P', new ItemStack(itemComponent, 1, ItemComponent.META_PROJECTOR_BASE)
						);

				// tube
				ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, BlockMachine.META_PROJ_TUBE),
						"###",
						" P ",
						"###",
						'#', Items.getItem("reinforcedStone"),
						'P', new ItemStack(itemComponent, 1, ItemComponent.META_PROJECTOR_BASE)
						);
				ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, BlockMachine.META_PROJ_TUBE),
						"# #",
						"#P#",
						"# #",
						'#', Items.getItem("reinforcedStone"),
						'P', new ItemStack(itemComponent, 1, ItemComponent.META_PROJECTOR_BASE)
						);

				// extender
				ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, BlockMachine.META_PROJ_EXTENDER),
						" O ",
						"# #",
						" # ",
						'#', Items.getItem("reinforcedStone"),
						'O', new ItemStack(itemComponent, 1, ItemComponent.META_DIAMOND_LENS)
						);

				// subwater
				ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, BlockUpgrades.META_SUBWATER),
						" A ",
						"ABA",
						" A ",
						Character.valueOf('A'), Items.getItem("advancedAlloy"),
						Character.valueOf('B'), Item.bucketEmpty
						);

				// dome
				ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, BlockUpgrades.META_DOME),
						" A ",
						"ABA",
						" A ",
						Character.valueOf('A'), Items.getItem("advancedAlloy"),
						Character.valueOf('B'), Items.getItem("electronicCircuit")
						);

				// hardner
				ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, BlockUpgrades.META_HARDNER),
						" A ",
						"ABA",
						" A ",
						Character.valueOf('A'), Items.getItem("advancedAlloy"),
						Character.valueOf('B'), Items.getItem("carbonPlate")
						);

				// core storage
				ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, BlockUpgrades.META_CORE_STORAGE),
						" A ",
						"ABA",
						" A ",
						Character.valueOf('A'), Items.getItem("advancedAlloy"),
						Character.valueOf('B'), Items.getItem("electrolyzedWaterCell")
						);

				// core range
				ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, BlockUpgrades.META_CORE_RANGE),
						" A ",
						"ABA",
						" A ",
						Character.valueOf('A'), Items.getItem("advancedAlloy"),
						Character.valueOf('B'), Items.getItem("frequencyTransmitter")
						);

				// zapper
				ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, BlockUpgrades.META_ZAPPER),
						" A ",
						"ABA",
						" A ",
						Character.valueOf('A'), Items.getItem("advancedAlloy"),
						Character.valueOf('B'), Items.getItem("teslaCoil")
						);

				// camo
				ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, BlockUpgrades.META_CAMO),
						"BAB",
						"ACA",
						"BAB",
						Character.valueOf('A'), Items.getItem("advancedAlloy"),
						Character.valueOf('B'), Item.diamond,
						Character.valueOf('C'), Items.getItem("frequencyTransmitter")
						);

				// reactor connector
				ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, BlockUpgrades.META_REACTOR_CONNECTOR),
						"ACA",
						"BDB",
						"ACA",
						Character.valueOf('A'), Items.getItem("advancedAlloy"),
						Character.valueOf('B'), Item.redstone,
						Character.valueOf('C'), Items.getItem("trippleInsulatedIronCableItem"),
						Character.valueOf('D'), Items.getItem("frequencyTransmitter")
						);

				// inhibitor
				ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, BlockUpgrades.META_INHIBITOR),
						" A ",
						"ABA",
						" A ",
						Character.valueOf('A'), Items.getItem("advancedAlloy"),
						Character.valueOf('B'), Items.getItem("machine")
						);
			}
			else
			{

				ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, BlockMachine.META_PROJ_EXTENDER),
						" * ",
						"#C#",
						" # ",
						'#', Items.getItem("advancedAlloy"),
						'*', Item.diamond,
						'D', Items.getItem("frequencyTransmitter")
						);
				ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, BlockMachine.META_PROJ_TUBE),
						"#*#",
						"*C*",
						"DED",
						'#', Items.getItem("advancedAlloy"),
						'*', Item.diamond,
						'D', Items.getItem("electronicCircuit"),
						'C', Items.getItem("frequencyTransmitter"),
						'E', Items.getItem("electrolyzedWaterCell")
						);
				ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, BlockMachine.META_PROJ_AREA),
						"BBB",
						"BCB",
						"DED",
						'A', Items.getItem("advancedAlloy"),
						'B', Item.diamond,
						'D', Items.getItem("electronicCircuit"),
						'C', Items.getItem("frequencyTransmitter"),
						'E', Items.getItem("electrolyzedWaterCell")
						);
				ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, BlockMachine.META_PROJ_DEFLECTOR),
						"BAB",
						"ACA",
						"DED",
						'A', Items.getItem("advancedAlloy"),
						'B', Item.diamond,
						'D', Items.getItem("electronicCircuit"),
						'C', Items.getItem("frequencyTransmitter"),
						'E', Items.getItem("electrolyzedWaterCell")
						);
				ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, BlockMachine.META_PROJ_DIR),
						"ABA",
						"ACA",
						"DED",
						'A', Items.getItem("advancedAlloy"),
						'B', Item.diamond,
						'D', Items.getItem("electronicCircuit"),
						'C', Items.getItem("frequencyTransmitter"),
						'E', Items.getItem("electrolyzedWaterCell")
						);
				/*ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, BlockMachine.META_EU_INJECTOR),
					"ABA",
					"CDC",
					"ABA",
					'A', Items.getItem("refinedIronIngot"),
					'B', Items.getItem("insulatedCopperCableItem"),
					'C', Items.getItem("electrolyzedWaterCell"),
					'D', Items.getItem("batBox")
				);*/ // EU injector recipe disabled
				ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, BlockMachine.META_CORE),
						"ABA",
						"CDC",
						"AEA",
						Character.valueOf('A'), Items.getItem("electrolyzedWaterCell"),
						Character.valueOf('B'), Items.getItem("advancedAlloy"),
						Character.valueOf('C'), Items.getItem("electronicCircuit"),
						Character.valueOf('D'), Items.getItem("frequencyTransmitter"),
						Character.valueOf('E'), Items.getItem("electrolyzer")
						);
				ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, BlockUpgrades.META_CORE_STORAGE),
						" A ",
						"ABA",
						" A ",
						Character.valueOf('A'), Items.getItem("advancedAlloy"),
						Character.valueOf('B'), Items.getItem("electrolyzedWaterCell")
						);
				ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, BlockUpgrades.META_DOME),
						" A ",
						"ABA",
						" A ",
						Character.valueOf('A'), Items.getItem("advancedAlloy"),
						Character.valueOf('B'), Items.getItem("electronicCircuit")
						);
				ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, BlockUpgrades.META_HARDNER),
						" A ",
						"ABA",
						" A ",
						Character.valueOf('A'), Items.getItem("advancedAlloy"),
						Character.valueOf('B'), Items.getItem("carbonPlate")
						);
				ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, BlockUpgrades.META_CORE_RANGE),
						" A ",
						"ABA",
						" A ",
						Character.valueOf('A'), Items.getItem("advancedAlloy"),
						Character.valueOf('B'), Items.getItem("frequencyTransmitter")
						);
				ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, BlockUpgrades.META_INHIBITOR),
						" A ",
						"ABA",
						" A ",
						Character.valueOf('A'), Items.getItem("advancedAlloy"),
						Character.valueOf('B'), Items.getItem("machine")
						);
				ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, BlockUpgrades.META_SUBWATER),
						" A ",
						"ABA",
						" A ",
						Character.valueOf('A'), Items.getItem("advancedAlloy"),
						Character.valueOf('B'), Item.bucketEmpty
						);
				ModLoader.addRecipe(new ItemStack(MFFSitemcardempty),
						"AAA",
						"ABA",
						"AAA",
						Character.valueOf('A'), Item.paper,
						Character.valueOf('B'), Items.getItem("electronicCircuit")
						);
				ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, BlockUpgrades.META_ZAPPER),
						" A ",
						"ABA",
						" A ",
						Character.valueOf('A'), Items.getItem("advancedAlloy"),
						Character.valueOf('B'), Items.getItem("teslaCoil")
						);
				ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, BlockUpgrades.META_CAMO),
						"BAB",
						"ACA",
						"BAB",
						Character.valueOf('A'), Items.getItem("advancedAlloy"),
						Character.valueOf('B'), Item.diamond,
						Character.valueOf('C'), Items.getItem("frequencyTransmitter")
						);
				ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, BlockUpgrades.META_REACTOR_CONNECTOR),
						"ACA",
						"BDB",
						"ACA",
						Character.valueOf('A'), Items.getItem("advancedAlloy"),
						Character.valueOf('B'), Item.redstone,
						Character.valueOf('C'), Items.getItem("trippleInsulatedIronCableItem"),
						Character.valueOf('D'), Items.getItem("frequencyTransmitter")
						);
			}

			//ModLoader.addRecipe(new ItemStack(MFFSitemMFDReaktorlink), new Object[] { "DCD", "BAB", "CBC", Character.valueOf('A'), Items.getItem("frequencyTransmitter"), Character.valueOf('B'), Items.getItem("electronicCircuit") , Character.valueOf('C'), Items.getItem("carbonPlate"), Character.valueOf('D'), Item.redstone});

			ModLoader.addShapelessRecipe(new ItemStack(MFFSitemcardempty), new Object[] {MFFSitemfc});
		}

	}

	public static boolean areItemsEqual(ItemStack a, ItemStack b) {
		if(a == null && b == null)
			return true;
		if(a == null || b == null)
			return false;
		if(a.itemID != b.itemID)
			return false;
		if(a.getHasSubtypes() && a.getItemDamage() != b.getItemDamage())
			return false;
		if(a.stackTagCompound == null && b.stackTagCompound == null)
			return true;
		if(a.stackTagCompound != null || b.stackTagCompound != null)
			return false;
		return a.stackTagCompound.equals(b.stackTagCompound);
	}

	@Override
	public String getChannel() {
		return CHANNEL;
	}

	@Override
	public IPacket createS2CPacket(byte id) {
		if(id == PKT_GENERIC_UPDATE)
			return new PacketGenericUpdate();
		if(id == PKT_BOLT_FX)
			return new PacketBoltFX();
		return null;
	}

	@Override
	public IPacket createC2SPacket(byte id) {
		return null;
	}
}