package mods.immibis.ars.beams;

import ic2.api.Direction;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.tile.IEnergySink;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class TileEMPUpgrade extends TileBeamEmitter implements IEnergySink {
	public static final int MAX_STORAGE = 1000000;
	
	public int storage;
	
	private boolean added_to_enet;
	
	private UpgradeData upg_data;
	public TileEMPUpgrade() {
		upg_data = new UpgradeData();
		upg_data.emp = this;
	}
	
	@Override
	public void readFromNBT(NBTTagCompound tag) {
		super.readFromNBT(tag);
		storage = tag.getInteger("eu");
	}
	
	@Override
	public void writeToNBT(NBTTagCompound tag) {
		super.writeToNBT(tag);
		tag.setInteger("eu", storage);
	}
	
	@Override
	public void invalidate() {
		if(added_to_enet) {
			EnergyNet.getForWorld(worldObj).removeTileEntity(this);
			added_to_enet = false;
		}
		super.invalidate();
	}
	
	@Override
	public Object getOutput() {
		return upg_data;
	}
	
	@Override
	public void updateEntity() {
		if(worldObj.isRemote)
			return;
		
		if(!added_to_enet) {
			EnergyNet.getForWorld(worldObj).addTileEntity(this);
			added_to_enet = true;
		}
	}

	@Override
	public boolean acceptsEnergyFrom(TileEntity arg0, Direction arg1) {
		return true;
	}

	@Override
	public boolean isAddedToEnergyNet() {
		return added_to_enet;
	}

	@Override
	public int demandsEnergy() {
		return MAX_STORAGE - storage;
	}

	@Override
	public int injectEnergy(Direction arg0, int arg1) {
		if(storage >= MAX_STORAGE)
			return arg1;
		else {
			storage += arg1;
			return 0;
		}
	}
	
	@Override
	public int getBeamColour() {return 1;}
	
	@Override
	public int getMaxSafeInput() {
		return Integer.MAX_VALUE;
	}
}
