package mods.immibis.ars.beams;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;

public class ItemLogicCard extends Item {
	public ItemLogicCard(int id_minus_256) {
		super(id_minus_256);
		
		setHasSubtypes(true);
		
		LogicType.init();
		
		setCreativeTab(CreativeTabs.tabMisc);
	}
	
	@Override
	public String getUnlocalizedName(ItemStack is) {
		return "immibis.ars.logiccard."+is.getItemDamage();
	}
	
	private Map<Integer, Icon> icons;
	
	@Override
	@SideOnly(Side.CLIENT)
	public void registerIcons(IconRegister r) {
		icons = new HashMap<Integer, Icon>();
		for(int meta : LogicType.getAllTypeIDs()) {
			String iconName = LogicType.getIconName(meta);
			if(iconName != null)
				icons.put(meta, r.registerIcon(iconName));
		}
	}
	
	@Override
	public Icon getIconFromDamage(int meta) {
		return icons.get(meta);
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public void getSubItems(int id, CreativeTabs tab, @SuppressWarnings("rawtypes") List list) {
		for(int meta : LogicType.getAllTypeIDs())
			list.add(new ItemStack(this, 1, meta));
	}
}
