package mods.immibis.ars;


import ic2.core.block.generator.tileentity.TileEntityReactorChamber;

import java.util.List;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

import mods.immibis.core.RenderUtilsIC;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockUpgrades extends BlockContainer
{

	private int blockid;
	
	//public static final int META_REACTOR_MONITOR_CLIENT = 0;
	public static final int META_SUBWATER = 1;
	public static final int META_DOME = 2;
	public static final int META_HARDNER = 3;
	public static final int META_CORE_STORAGE = 4;
	public static final int META_CORE_RANGE = 5;
	public static final int META_ZAPPER = 6;
	public static final int META_CAMO = 7;
	public static final int META_REACTOR_CONNECTOR = 8;
	public static final int META_INHIBITOR = 9;
	
	public static final int MAX_META = 10;

	public BlockUpgrades(int i) {

		super(i, Material.iron);
		blockid = i;
		setHardness(3F);
		setResistance(50F);
		setStepSound(soundMetalFootstep);
		
		setCreativeTab(CreativeTabs.tabMisc);

	}

	public int getBlockid() {
		return blockid;
	}

	public int getGuiPro(World world, int i, int j, int k, EntityPlayer entityplayer) {
		switch (world.getBlockMetadata(i, j, k)) {
		case 0:
			return ARSMod.GUI_ID_GENERATOR;
		case 1:
			return ARSMod.GUI_AREA_PROJECTOR;
		case 2:
			return ARSMod.GUI_DIRECTIONAL_PROJECTOR;
		case 3:
			return ARSMod.GUI_DEFLECTOR_PROJECTOR;
		case 4:
			return ARSMod.GUI_TUBE_PROJECTOR;
		case 5:
			return ARSMod.GUI_DIRECTIONAL_UPGRADE;
		default:
			return -1;
		}
	}

	public int getGuiUp(World world, int i, int j, int k, EntityPlayer entityplayer) {
		switch (world.getBlockMetadata(i, j, k)) {

		case 7:
			return ARSMod.GUI_CAMOFLAGE_UPGRADE;
		default:
			return -1;
		}
	}

	@Override
	public int isProvidingStrongPower(IBlockAccess world, int i, int j, int k, int l) {
		TileEntity tileentity = world.getBlockTileEntity(i, j, k);
		if (tileentity instanceof TileEntityReaktorConnector) {

			if (((TileEntityReaktorConnector) tileentity).isredpowert()) {

				switch (l) {

				case 0:
					if (world.getBlockTileEntity(i, j + 1, k) instanceof TileEntityReactorChamber) {
						return 15;
					}

					break;
				case 1:

					if (world.getBlockTileEntity(i, j - 1, k) instanceof TileEntityReactorChamber) {
						return 15;
					}

					break;
				case 2:
					if (world.getBlockTileEntity(i, j, k + 1) instanceof TileEntityReactorChamber) {
						return 15;
					}
					break;
				case 3:
					if (world.getBlockTileEntity(i, j, k - 1) instanceof TileEntityReactorChamber) {
						return 15;
					}

					break;
				case 4:
					if (world.getBlockTileEntity(i + 1, j, k) instanceof TileEntityReactorChamber) {
						return 15;
					}
					break;
				case 5:
					if (world.getBlockTileEntity(i - 1, j, k) instanceof TileEntityReactorChamber) {
						return 15;
					}
					break;
				default:
					return 0;

				}

			}

		}


		return 0;
	}

	@Override
	public int isProvidingWeakPower(IBlockAccess iblockaccess, int i, int j, int k, int l) {
		return isProvidingStrongPower(iblockaccess, i, j, k, l);
	}

	@Override
	public boolean canProvidePower() {

		return true;
	}

	@Override
	public void breakBlock(World world, int i, int j, int k, int par5, int par6) {
		if(world.isRemote)
			return;

		TileEntity tileentity = world.getBlockTileEntity(i, j, k);
		
		world.removeBlockTileEntity(i, j, k);
	}

	@Override
	public boolean onBlockActivated(World world, int i, int j, int k, EntityPlayer entityplayer, int par6, float par7, float par8, float par9) {
	
		int gui = getGuiUp(world, i, j, k, entityplayer);
		int meta = world.getBlockMetadata(i, j, k);

		if (gui < 0 && meta != 4 && meta != 5) {
			return false;
		}

		if (entityplayer.isSneaking())
			return false;

		if (entityplayer.getCurrentEquippedItem() != null && (entityplayer.getCurrentEquippedItem().getItem() instanceof ItemMFD)) {
			return false;
		}

		if (gui >= 0) {
			if(!world.isRemote)
				entityplayer.openGui(ARSMod.instance, gui, world, i, j, k);
			return true;
		}

		if (meta == 4 || meta == 5) {
			TileUpgradePassive tileentity = (TileUpgradePassive) world.getBlockTileEntity(i, j, k);
			if (tileentity.getconectet_ID() != 0) {
				TileEntityGeneratorCore tileentitygen = Linkgrid.getWorldMap(world).getGenerator().get(tileentity.getconectet_ID());
				if (tileentitygen != null && !world.isRemote) {
					int guiid = getGuiPro(world, tileentitygen.xCoord, tileentitygen.yCoord, tileentitygen.zCoord, entityplayer);
					if(guiid >= 0)
						entityplayer.openGui(ARSMod.instance, gui, world, tileentitygen.xCoord, tileentitygen.yCoord, tileentitygen.zCoord);
				}
			}
		}
		return false;
	}

	@Override
	public TileEntityMaschines createNewTileEntity(World w) {
		return null;
	}

	@Override
	public int damageDropped(int i) {
		return i;

	}

	@Override
	public TileEntityMaschines createTileEntity(World w, int i) {
		switch (i) {
		case 0:
			return null;
		case 1: // '\\ Projektor Subwater'
		case 2: // '\\ Projektor Dome'
		case 3: // '\\ Projektor Hardner'
		case 4: // '\\ Generator Array'
		case 5: // '\\ Generator Storage'
		case 6: // '\\ Projektor Zapper'
		case META_INHIBITOR:
			return new TileUpgradePassive();
		case 7: // '\\ Projektor camouflage'
			return new TileUpgradeCamouflage();
		case 8: // '\\ Reaktor Connector'
			return new TileEntityReaktorConnector();
		}
		return null;
	}

	public static boolean isActive(IBlockAccess iblockaccess, int i, int j, int k) {
		TileEntity tileentity = iblockaccess.getBlockTileEntity(i, j, k);

		if (tileentity instanceof TileUpgradePassive) {
			return ((TileUpgradePassive) tileentity).getconectet_ID() != 0;
		} else {
			return false;
		}
	}
	
	// icons[meta][active][side] -> icon
	private Icon[][][] icons;
	
	@Override
	@SideOnly(Side.CLIENT)
	public void registerIcons(IconRegister reg) {
		String[] names = new String[] {
			"client", "underwater", "dome", "breaker", "storage", "range", "zapper", "camo", "connector", "inhibitor"
		};
		if(names.length != MAX_META)
			throw new AssertionError();
		
		icons = new Icon[names.length][2][];
		for(int k = 0; k < names.length; k++) {
			icons[k][0] = RenderUtilsIC.loadIconArray(reg, "immibis/ars:upgrades>"+names[k]+"0", 6);
			icons[k][1] = RenderUtilsIC.loadIconArray(reg, "immibis/ars:upgrades>"+names[k]+"1", 6);
		}
	}

	@Override
	public Icon getBlockTexture(IBlockAccess iblockaccess, int i, int j, int k, int l) {
		TileEntity tileentity = iblockaccess.getBlockTileEntity(i, j, k);
		int meta = iblockaccess.getBlockMetadata(i, j, k);
		
		if(l < 2) l ^= 1; // swaps top and bottom

		if(meta >= icons.length)
			meta = 0;
		
		return icons[meta][isActive(iblockaccess, i, j, k) ? 1 : 0][l];
	}

	@Override
	public Icon getIcon(int side, int meta) {

		if(meta >= icons.length)
			meta = 0;
		
		return icons[meta][0][side];
	}

	@Override
	public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
		TileEntity tileentity = world.getBlockTileEntity(i, j, k);
		if (tileentity instanceof TileUpgradePassive) {
			((TileUpgradePassive) tileentity).updatecheck();
		}
	}

	@Override
	public float getExplosionResistance(Entity entity, World world, int i, int j, int k, double d, double d1, double d2) {
		if (world.getBlockTileEntity(i, j, k) instanceof TileEntityMaschines) {
			TileEntity tileentity = world.getBlockTileEntity(i, j, k);
			if (((TileEntityMaschines) tileentity).getActive()) {
				return 60000F;
			} else {
				return 50F;
			}
		}
		return 50F;
	}
	
	@Override
	public final void getSubBlocks(int par1, CreativeTabs par2CreativeTabs, List par3List) {
		for(int k = 0; k < MAX_META; k++)
			if(k != 0) // removed block
				par3List.add(new ItemStack(this, 1, k));
	}

}
