package immibis.chunkloader;

import net.minecraft.src.*;
import immibis.core.TileCombined;

public class TileChunkLoader extends TileCombined {
	public WorldInfo worldInfo;
	
	public String owner;
	public int radius = 0;

	public TileChunkLoader() {
	}
	
	@Override
	public void writeToNBT(NBTTagCompound tag) {
		super.writeToNBT(tag);
		tag.setString("owner", owner == null ? "" : owner);
		tag.setInteger("radius", radius);
	}
	
	@Override
	public void readFromNBT(NBTTagCompound tag) {
		super.readFromNBT(tag);
		owner = tag.getString("owner");
		if(owner != null && owner.equals(""))
			owner = null;
		radius = tag.getInteger("radius");
	}
	
	@Override
	public boolean onBlockActivated(EntityPlayer ply) {
		ply.openGui(Main.instance, Main.GUI_CHUNKLOADER, worldObj, xCoord, yCoord, zCoord);
		return true;
	}
	
	@Override
	public void validate() {
		super.validate();
		worldInfo = Main.instance.getWorld(worldObj);
		worldInfo.addLoader(this);
	}
	@Override
	public void invalidate() {
		super.invalidate();
		worldInfo.delayRemoveLoader(this);
	}
	
	public void loaderChanged() {
		worldInfo.readdLoader(this);
	}
	
	public void limitRadius() {
		if(owner == null) {
			radius = -1;
			return;
		}
		
		int max = Main.instance.getMaxQuota(owner);
		
		if(max == -2)
			return;
		
		while(radius >= 0 && Main.instance.getCurQuota(owner) + (2*radius+1)*(2*radius+1) > max) {
			radius--;
			loaderChanged();
		}
	}

	public WorldInfo.LoaderInfo getLoaderInfo() {
		return new WorldInfo.LoaderInfo(new WorldInfo.XYZ(this), owner, radius);
	}
}
