package immibis.chunkloader;

/* $if client$ */

import org.lwjgl.opengl.GL11;

import net.minecraft.client.Minecraft;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntityPlayerSP;
import net.minecraft.src.GuiContainer;
import net.minecraft.src.ModLoader;

public class GuiChunkLoader extends GuiContainer {
	private ContainerChunkLoader container;
	
	public GuiChunkLoader(ContainerChunkLoader container) {
		super(container);
		this.container = container;
		xSize = 186;
		ySize = 116;
	}

	@Override
	protected void drawGuiContainerBackgroundLayer(float var1, int var2, int var3) {
		int k = mc.renderEngine.getTexture("/immibis/chunkloader/gui.png");
        GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
        mc.renderEngine.bindTexture(k);
        int l = (width - xSize) / 2;
        int i1 = (height - ySize) / 2;
        drawTexturedModalRect(l, i1, 0, 0, xSize, ySize);
	}
	
	private void sendButton(int button)
	{
		this.mc.playerController.windowClick(this.inventorySlots.windowId, 0, button, false, this.mc.thePlayer);
	}
	
	protected void mouseClicked(int real_x, int real_y, int button)
    {
		int x = (real_x - this.guiLeft);
		int y = (real_y - this.guiTop);
		if(button == 0)
		{
			if(x >= 124 && y >= 85 && x <= 147 && y <= 108)
				// decrease size button
				container.sendButtonPressed(3);
			else if(x >= 153 && y >= 85 && x <= 176 && y <= 108)
				// increase size button
				container.sendButtonPressed(4);
			else
				super.mouseClicked(real_x, real_y, button);
		}
		else
			super.mouseClicked(real_x, real_y, button);
    }
	
	@Override
	protected void drawGuiContainerForegroundLayer() {
        TileChunkLoader tile = ((ContainerChunkLoader)inventorySlots).tile;
        ContainerChunkLoader cont = (ContainerChunkLoader)inventorySlots;
        
        Minecraft mc = ModLoader.getMinecraftInstance();
        
        if(!mc.theWorld.isRemote)
        	cont.updateFields();
        
        fontRenderer.drawString("Owner: " + tile.owner, 6, 6, 0x404040);
        
        if(cont.ownedByMe || cont.amIOp) {
        	int limit = cont.getMaxQuota();
        	String limitStr = (limit == -1 ? "" : limit == -2 ? "unlimited" : "" + limit);
        	fontRenderer.drawString((cont.ownedByMe ? "Your" : "Their") + " chunk limit: " + cont.getCurQuota() + " / " + limitStr, 6, 16, 0x404040);
        	int area = tile.radius*2+1;
        	if(area > 0)
        		fontRenderer.drawString("Area: " + area + "x" + area, 6, 36, 0x404040);
        	else
        		fontRenderer.drawString("Area: None", 6, 36, 0x404040);
        	
        	//if(!cont.ownedByMe) {
        		fontRenderer.drawString("Only ops and owner can see this.", 6, 46, 0x404040);
        	//}
        }
	}
}

/* $else$
public class GuiChunkLoader {}
$endif$ */