package immibis.chunkloader;

import immibis.core.NonSharedProxy;
import immibis.core.NullInventory;
import immibis.core.net.AbstractSyncedContainer;
import immibis.core.net.IPacket;
import immibis.core.net.ISyncedContainer;
import immibis.core.net.OneTwoFiveNetworking;

import java.util.List;

import net.minecraft.src.*;

public class ContainerChunkLoader extends AbstractSyncedContainer {
	
	public EntityPlayer player;
	public TileChunkLoader tile;
	
	public ContainerChunkLoader(EntityPlayer player, final TileChunkLoader tile) {
		super(player, new NullInventory() {
			@Override
			public boolean isUseableByPlayer(EntityPlayer var1) {
				return !tile.isInvalid() && var1.getDistanceSq(tile.xCoord + 0.5, tile.yCoord + 0.5, tile.zCoord + 0.5) <= 64;
			}
		});
		this.player = player;
		this.tile = tile;
	}
	
	public boolean canEdit() {
		return tile.owner != null && (ownedByMe || amIOp);
	}
	
	@Override
	public void onButtonPressed(int i) {
		if(!canEdit())
			return;
		if(i == 3) {
			// decrease size
			if(tile.radius > 0) {
				tile.radius--;
				tile.loaderChanged();
			}
		} else if(i == 4) {
			// increase size
			if(tile.radius < Main.MAX_RADIUS && Main.instance.canAddQuota(tile.owner, (tile.radius + 1) * 8)) {
				tile.radius++;
				tile.loaderChanged();
			}
		}
	}
	
	private String lastOwner = null;
	private int lastMaxQuota = -1, lastCurQuota = -1, lastRadius = -2;
	private boolean lastAmIOp;
	
	public boolean ownedByMe, amIOp;
	private int maxQuota, curQuota;
	
	public int getMaxQuota() {
		if(tile.worldObj.isRemote)
			return maxQuota;
		return tile.owner == null ? 0 : Main.instance.getMaxQuota(tile.owner);
	}
	public int getCurQuota() {
		if(tile.worldObj.isRemote)
			return curQuota;
		return tile.owner == null ? 0 : Main.instance.getCurQuota(tile.owner);
	}
	
	public void updateFields() {
		maxQuota = getMaxQuota();
		curQuota = getCurQuota();
		ownedByMe = (tile.owner != null && tile.owner.equals(player.username));
		amIOp = NonSharedProxy.isOp(player.username);
	}
	
	@Override
	public void updateCraftingResults() {
		// I use != for string comparisons here because
		// the lastOwner is explicitly set to tile.owner,
		// so the worst that happens is an extra packet gets
		// transmitted once. Also, ever tried
		// writing a null-safe .equals check?
		
		updateFields();
	
		if(lastOwner == tile.owner && lastMaxQuota == maxQuota && lastCurQuota == curQuota && lastRadius == tile.radius && lastAmIOp == amIOp)
			return;
		
		PacketGUIUpdate packet = new PacketGUIUpdate(tile.owner == null ? "" : tile.owner, curQuota, maxQuota, tile.radius, amIOp);
		sendUpdatePacket(packet);
		
		lastOwner = tile.owner;
		lastCurQuota = curQuota;
		lastMaxQuota = maxQuota;
		lastRadius = tile.radius;
		lastAmIOp = amIOp;
	}
	
	@Override
	public void onUpdatePacket(IPacket packet) {
		if(packet instanceof PacketGUIUpdate) {
			PacketGUIUpdate p = (PacketGUIUpdate)packet;
			tile.owner = p.owner.equals("") ? null : p.owner;
			tile.radius = p.radius;
			curQuota = p.curQuota;
			maxQuota = p.maxQuota;
			amIOp = p.amIOp;
			ownedByMe = (tile.owner != null && tile.owner.equals(player.username));
		}
	}

	@Override
	public String getChannel() {
		return Main.CHANNEL;
	}
	
}
