/*
 * Decompiled with CFR 0.152.
 */
package immibis.chunkloader;

import forge.DimensionManager;
import forge.IChunkLoadHandler;
import forge.IGuiHandler;
import forge.MinecraftForge;
import immibis.chunkloader.BlockChunkLoader;
import immibis.chunkloader.ContainerChunkLoader;
import immibis.chunkloader.ItemChunkLoader;
import immibis.chunkloader.PacketGUIUpdate;
import immibis.chunkloader.PacketShowChunksRequest;
import immibis.chunkloader.PacketShowChunksResponse;
import immibis.chunkloader.TileChunkLoader;
import immibis.chunkloader.WorldInfo;
import immibis.core.CompatibleBaseMod;
import immibis.core.Config;
import immibis.core.CoreProxy;
import immibis.core.IBlockIDCallback;
import immibis.core.ModInfoReader;
import immibis.core.NonSharedProxy;
import immibis.core.net.IPacket;
import immibis.core.net.IPacketMap;
import immibis.core.net.OneTwoFiveNetworking;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.server.MinecraftServer;

public class Main
extends CompatibleBaseMod
implements IChunkLoadHandler,
IGuiHandler,
IPacketMap {
    public static final int GUI_CHUNKLOADER = 0;
    public static final byte S2C_GUI_UPDATE = 0;
    public static final byte C2S_DATA_REQUEST = 1;
    public static final byte S2C_DATA_RESPONSE = 2;
    public static final String CHANNEL = "immibis.chunkldr";
    public static final int MAX_RADIUS = 4;
    public Map worlds = new HashMap();
    public int maxQuota = 18;
    public boolean showOtherPlayersLoaders = false;
    public static boolean DEBUG = false;
    public static Main instance;
    public BlockChunkLoader block;

    public boolean isWorldCurrent(ge ge2) {
        return DimensionManager.getWorld((int)ge2.t.g) == ge2;
    }

    public WorldInfo getWorld(ge ge2) {
        WorldInfo worldInfo = (WorldInfo)((Object)this.worlds.get(ge2));
        if (worldInfo != null) {
            return worldInfo;
        }
        worldInfo = WorldInfo.get(ge2);
        this.worlds.put(ge2, worldInfo);
        return worldInfo;
    }

    public Main() {
        instance = this;
    }

    public boolean clientSideRequired() {
        return true;
    }

    public boolean serverSideRequired() {
        return false;
    }

    public String getVersion() {
        return ModInfoReader.getModInfoField((String)"/immibis/chunkloader/mod_ImmiChunkLoaders.info.txt", (String)"version");
    }

    public void load() {
        CoreProxy.RegisterBlockID((String)"chunkloader", (IBlockIDCallback)new IBlockIDCallback(){

            public void registerBlock(int n) {
                Main.this.block = new BlockChunkLoader(n);
                ModLoader.registerBlock((vz)Main.this.block, ItemChunkLoader.class);
            }
        });
        ModLoader.registerTileEntity(TileChunkLoader.class, (String)"immibis.chunkloader.TileChunkLoader");
        ModLoader.setInGameHook((BaseMod)this, (boolean)true, (boolean)false);
        MinecraftForge.registerChunkLoadHandler((IChunkLoadHandler)this);
        MinecraftForge.setGuiHandler((BaseMod)this, (IGuiHandler)this);
        OneTwoFiveNetworking.initReceive((IPacketMap)this, (String)CHANNEL);
        this.maxQuota = Config.getInt((String)"chunkloader.maxChunksPerPlayer", (int)3);
        this.showOtherPlayersLoaders = !Config.getBoolean((String)"chunkloader.hideOtherPlayersLoadersInF9", (boolean)true);
    }

    public boolean onTickInGame(MinecraftServer minecraftServer) {
        HashSet hashSet = new HashSet();
        for (Map.Entry ge2 : this.worlds.entrySet()) {
            if (!this.isWorldCurrent((ge)ge2.getKey())) {
                hashSet.add(ge2.getKey());
                continue;
            }
            ((WorldInfo)((Object)ge2.getValue())).tick();
        }
        for (ge ge2 : hashSet) {
            this.worlds.remove(ge2);
        }
        return true;
    }

    public Object getGuiElement(int n, ih ih2, ge ge2, int n2, int n3, int n4) {
        qj qj2 = ge2.b(n2, n3, n4);
        if (n == 0) {
            return new ContainerChunkLoader(ih2, (TileChunkLoader)qj2);
        }
        return null;
    }

    public boolean canUpdateEntity(tv tv2) {
        return this.getWorld(tv2.bi).isChunkForceLoaded(new abl(tv2.ca, tv2.cc));
    }

    public boolean canUnloadChunk(my my2) {
        return !this.getWorld(my2.e).isChunkForceLoaded(my2.k());
    }

    public void addActiveChunks(ge ge2, Set set) {
        set.addAll(this.getWorld(ge2).getLoadedChunks());
    }

    public int getCurQuota(String string) {
        int n = 0;
        for (Map.Entry entry : this.worlds.entrySet()) {
            int n2 = ((WorldInfo)((Object)entry.getValue())).getCurQuota(string);
            n += n2;
        }
        return n;
    }

    public int getMaxQuota(String string) {
        return NonSharedProxy.isOp((String)string) ? -2 : this.maxQuota;
    }

    public boolean canAddQuota(String string, int n) {
        if (n <= 0) {
            return true;
        }
        int n2 = this.getMaxQuota(string);
        if (n2 == -2) {
            return true;
        }
        return this.getCurQuota(string) + n <= n2;
    }

    public IPacket createPacket(byte by) {
        if (by == 0 && NonSharedProxy.CLIENT) {
            return new PacketGUIUpdate("", 0, 0, 0, false);
        }
        if (by == 1 && NonSharedProxy.SERVER) {
            return new PacketShowChunksRequest();
        }
        if (by == 2 && NonSharedProxy.CLIENT) {
            return new PacketShowChunksResponse();
        }
        return null;
    }
}

